/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.io.UnsupportedEncodingException;
import org.jf.dexlib.Util.Input;

public class OdexDependencies {
    public final int modificationTime;
    public final int crc;
    public final int dalvikBuild;
    private final String[] dependencies;
    private final byte[][] dependencyChecksums;

    public OdexDependencies(Input in) {
        this.modificationTime = in.readInt();
        this.crc = in.readInt();
        this.dalvikBuild = in.readInt();
        int dependencyCount = in.readInt();
        this.dependencies = new String[dependencyCount];
        this.dependencyChecksums = new byte[dependencyCount][];
        for (int i = 0; i < dependencyCount; ++i) {
            int stringLength = in.readInt();
            try {
                this.dependencies[i] = new String(in.readBytes(stringLength), 0, stringLength - 1, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            this.dependencyChecksums[i] = in.readBytes(20);
        }
    }

    public int getDependencyCount() {
        return this.dependencies.length;
    }

    public String getDependency(int index) {
        return this.dependencies[index];
    }

    public byte[] getDependencyChecksum(int index) {
        return (byte[])this.dependencyChecksums[index].clone();
    }
}

