/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.LazyLoadingCachingMap;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class CategoryDB
extends DatabaseObject
implements Category {
    private DataTypeManagerDB mgr;
    private volatile CategoryDB parent;
    private volatile String name;
    private LazyLoadingCachingMap<String, CategoryDB> subcategoryMap;
    private LazyLoadingCachingMap<String, DataType> dataTypeMap;

    CategoryDB(DataTypeManagerDB dtMgr, DBObjectCache<CategoryDB> cache, long id, CategoryDB parent, String name) {
        super(cache, id);
        this.mgr = dtMgr;
        this.name = name;
        this.parent = parent;
        this.subcategoryMap = new LazyLoadingCachingMap<String, CategoryDB>(this.mgr.lock, CategoryDB.class){

            @Override
            public Map<String, CategoryDB> loadMap() {
                return CategoryDB.this.buildSubcategoryMap();
            }
        };
        this.dataTypeMap = new LazyLoadingCachingMap<String, DataType>(this.mgr.lock, DataType.class){

            @Override
            public Map<String, DataType> loadMap() {
                return CategoryDB.this.createDataTypeMap();
            }
        };
    }

    CategoryDB(DataTypeManagerDB dtMgr, DBObjectCache<CategoryDB> cache) {
        this(dtMgr, cache, DataTypeManagerDB.ROOT_CATEGORY_ID, null, "/");
    }

    @Override
    public CategoryPath getCategoryPath() {
        this.validate(this.mgr.lock);
        if (this.isRoot() || this.isDeleted()) {
            return CategoryPath.ROOT;
        }
        return new CategoryPath(this.parent.getCategoryPath(), this.name);
    }

    @Override
    protected boolean refresh() {
        return this.refresh(null);
    }

    @Override
    protected boolean refresh(Record rec) {
        this.subcategoryMap.clear();
        this.dataTypeMap.clear();
        if (this.isRoot()) {
            return true;
        }
        try {
            if (rec == null) {
                rec = this.mgr.getCategoryDBAdapter().getRecord(this.key);
            }
            if (rec == null) {
                return false;
            }
            this.parent = this.mgr.getCategoryDB(rec.getLongValue(1));
            this.name = rec.getString(0);
        }
        catch (IOException e) {
            this.mgr.dbError(e);
        }
        return true;
    }

    @Override
    public String getName() {
        this.mgr.lock.acquire();
        try {
            this.checkIsValid();
            if (this.isRoot()) {
                String string = this.mgr.getName();
                return string;
            }
            String string = this.name;
            return string;
        }
        finally {
            this.mgr.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String newName) throws InvalidNameException, DuplicateNameException {
        this.testName(newName);
        this.mgr.lock.acquire();
        try {
            this.checkDeleted();
            CategoryPath oldPath = this.getCategoryPath();
            if (this.isRoot()) {
                this.mgr.setName(newName);
                return;
            }
            if (newName.equals(this.name)) {
                return;
            }
            if (this.parent.getCategory(newName) != null) {
                throw new DuplicateNameException("Category named " + newName + " already exists");
            }
            String oldName = this.name;
            this.name = newName;
            try {
                this.mgr.getCategoryDBAdapter().updateRecord(this.key, this.parent.key, newName);
            }
            catch (IOException e) {
                this.mgr.dbError(e);
            }
            this.parent.catagoryRenamed(this, oldName);
            this.mgr.categoryRenamed(oldPath, this);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    private CategoryDB[] getCategories(long parentId) {
        try {
            long[] ids = this.mgr.getCategoryDBAdapter().getRecordIdsWithParent(parentId);
            CategoryDB[] cats = new CategoryDB[ids.length];
            for (int i = 0; i < cats.length; ++i) {
                cats[i] = this.mgr.getCategoryDB(ids[i]);
            }
            return cats;
        }
        catch (IOException e) {
            this.mgr.dbError(e);
            return null;
        }
    }

    private Map<String, CategoryDB> buildSubcategoryMap() {
        CategoryDB[] categories = this.getCategories(this.key);
        ConcurrentHashMap<String, CategoryDB> map = new ConcurrentHashMap<String, CategoryDB>(2 * categories.length);
        for (CategoryDB category : categories) {
            map.put(category.getName(), category);
        }
        return map;
    }

    private Map<String, DataType> createDataTypeMap() {
        List<DataType> dataTypeList = this.mgr.getDataTypesInCategory(this.key);
        ConcurrentHashMap<String, DataType> map = new ConcurrentHashMap<String, DataType>(2 * dataTypeList.size());
        for (DataType dataType : dataTypeList) {
            map.put(dataType.getName(), dataType);
        }
        return map;
    }

    @Override
    public Category[] getCategories() {
        this.validate(this.mgr.lock);
        return this.subcategoryMap.valuesToArray();
    }

    @Override
    public DataType[] getDataTypes() {
        this.validate(this.mgr.lock);
        return this.dataTypeMap.valuesToArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType addDataType(DataType dt, DataTypeConflictHandler handler) {
        this.mgr.lock.acquire();
        try {
            DataType resolvedDataType;
            this.checkDeleted();
            dt = dt.clone(dt.getDataTypeManager());
            try {
                dt.setCategoryPath(this.getCategoryPath());
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
            DataType dataType = resolvedDataType = this.mgr.resolve(dt, handler);
            return dataType;
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public CategoryDB getCategory(String subcategoryName) {
        this.validate(this.mgr.lock);
        return this.subcategoryMap.get(subcategoryName);
    }

    @Override
    public DataType getDataType(String dataTypeName) {
        this.validate(this.mgr.lock);
        return this.dataTypeMap.get(dataTypeName);
    }

    private void testName(String categoryName) throws InvalidNameException {
        if (categoryName == null || categoryName.length() == 0) {
            throw new InvalidNameException("Name cannot be null or zero length");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Category createCategory(String categoryName) throws InvalidNameException {
        this.testName(categoryName);
        this.mgr.lock.acquire();
        try {
            CategoryDB cat;
            this.checkDeleted();
            CategoryDB categoryDB = cat = this.mgr.createCategoryDB(this, categoryName);
            return categoryDB;
        }
        catch (IOException e1) {
            this.mgr.dbError(e1);
        }
        finally {
            this.mgr.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCategory(String categoryName, TaskMonitor monitor) {
        this.mgr.lock.acquire();
        try {
            DataType[] dts;
            Category[] cats;
            this.checkDeleted();
            CategoryDB c = this.getCategory(categoryName);
            if (c == null) {
                boolean bl = false;
                return bl;
            }
            for (Category cat : cats = c.getCategories()) {
                if (monitor.isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
                c.removeCategory(cat.getName(), monitor);
            }
            for (DataType dt : dts = c.getDataTypes()) {
                if (monitor.isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
                this.mgr.remove(dt, monitor);
            }
            try {
                this.mgr.getCategoryDBAdapter().removeCategory(c.getKey());
                this.subcategoryMap.remove(categoryName);
                this.mgr.categoryRemoved(this, categoryName, c.getKey());
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                this.mgr.dbError(e);
                boolean bl = false;
                this.mgr.lock.release();
                return bl;
            }
        }
        finally {
            this.mgr.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEmptyCategory(String categoryName, TaskMonitor monitor) {
        this.mgr.lock.acquire();
        try {
            this.checkDeleted();
            CategoryDB c = this.getCategory(categoryName);
            if (c == null) {
                boolean bl = false;
                return bl;
            }
            Category[] cats = c.getCategories();
            DataType[] dts = c.getDataTypes();
            if (cats.length != 0 || dts.length != 0) {
                boolean bl = false;
                return bl;
            }
            this.mgr.getCategoryDBAdapter().removeCategory(c.getKey());
            this.subcategoryMap.remove(categoryName);
            this.mgr.categoryRemoved(this, categoryName, c.getKey());
            boolean bl = true;
            return bl;
        }
        finally {
            this.mgr.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveCategory(Category category, TaskMonitor monitor) throws DuplicateNameException {
        if (this.mgr != category.getDataTypeManager()) {
            throw new IllegalArgumentException("Category does not belong to my DataTypeManager");
        }
        CategoryDB categoryDB = (CategoryDB)category;
        this.mgr.lock.acquire();
        try {
            this.checkDeleted();
            if (this.getCategory(categoryDB.getName()) != null) {
                throw new DuplicateNameException("Category named " + categoryDB.getName() + " already exists");
            }
            CategoryPath categoryPath = this.getCategoryPath();
            if (categoryPath.isAncestorOrSelf(categoryDB.getCategoryPath())) {
                throw new IllegalArgumentException("Moved category is an ancestor of destination category!");
            }
            CategoryPath oldPath = categoryDB.getCategoryPath();
            try {
                categoryDB.setParent(this);
            }
            catch (IOException e) {
                this.mgr.dbError(e);
            }
            this.subcategoryMap.put(categoryDB.getName(), categoryDB);
            this.mgr.categoryMoved(oldPath, categoryDB);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Category copyCategory(Category category, DataTypeConflictHandler handler, TaskMonitor monitor) {
        boolean isInSameArchive = this.mgr == category.getDataTypeManager();
        this.mgr.lock.acquire();
        try {
            DataType[] dts;
            Category[] cats;
            this.checkDeleted();
            Category cat = this.createCategory(category.getName());
            for (Category cat2 : cats = category.getCategories()) {
                if (monitor.isCancelled()) {
                    Category category2 = cat;
                    return category2;
                }
                cat.copyCategory(cat2, handler, monitor);
            }
            for (DataType dt : dts = category.getDataTypes()) {
                if (monitor.isCancelled()) break;
                DataType newDataType = isInSameArchive ? dt.copy(this.mgr) : dt.clone(this.mgr);
                cat.addDataType(newDataType, handler);
            }
            Category category3 = cat;
            return category3;
        }
        catch (InvalidNameException invalidNameException) {
        }
        finally {
            this.mgr.lock.release();
        }
        return null;
    }

    @Override
    public Category getParent() {
        this.validate(this.mgr.lock);
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public String getCategoryPathName() {
        CategoryPath path = this.getCategoryPath();
        return path.getPath();
    }

    @Override
    public Category getRoot() {
        return this.mgr.getCategory(DataTypeManagerDB.ROOT_CATEGORY_ID);
    }

    @Override
    public long getID() {
        return this.getKey();
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.mgr;
    }

    @Override
    public void moveDataType(DataType movedDataType, DataTypeConflictHandler handler) throws DataTypeDependencyException {
        this.mgr.lock.acquire();
        try {
            this.checkDeleted();
            CategoryPath path = this.getCategoryPath();
            if (handler == null) {
                handler = DataTypeConflictHandler.DEFAULT_HANDLER;
            }
            if (movedDataType.getDataTypeManager() != this.mgr) {
                throw new IllegalArgumentException("Given dataType not in this data type manager");
            }
            DataType existing = this.getDataType(movedDataType.getName());
            if (movedDataType == existing) {
                return;
            }
            if (existing != null) {
                DataTypeConflictHandler.ConflictResult result = this.mgr.resolveConflict(handler, movedDataType, existing);
                if (result == DataTypeConflictHandler.ConflictResult.REPLACE_EXISTING) {
                    this.mgr.replaceDataType(existing, movedDataType, true);
                } else if (result == DataTypeConflictHandler.ConflictResult.USE_EXISTING) {
                    this.mgr.replaceDataType(movedDataType, existing, false);
                } else {
                    movedDataType.setNameAndCategory(path, this.mgr.getUnusedConflictName(path, movedDataType.getName()));
                }
            } else {
                movedDataType.setCategoryPath(path);
            }
        }
        catch (InvalidNameException e) {
            throw new AssertException((Throwable)e);
        }
        catch (DuplicateNameException e) {
            throw new AssertException((Throwable)e);
        }
        finally {
            this.mgr.lock.release();
        }
    }

    @Override
    public boolean remove(DataType type, TaskMonitor monitor) {
        CategoryPath path = this.getCategoryPath();
        if (type.getDataTypeManager() != this.mgr || !type.getCategoryPath().equals(path)) {
            throw new IllegalArgumentException("can't remove dataType from category that its not a member of!");
        }
        return this.mgr.remove(type, monitor);
    }

    @Override
    public int compareTo(Category otherCategory) {
        CategoryPath path = this.getCategoryPath();
        return path.compareTo(otherCategory.getCategoryPath());
    }

    public String toString() {
        CategoryPath path = this.getCategoryPath();
        return this.mgr.getName() + path.toString();
    }

    private void setParent(CategoryDB newParent) throws IOException {
        this.mgr.getCategoryDBAdapter().updateRecord(this.key, newParent.key, this.name);
        if (this.parent == null) {
            throw new AssertException("Should not be able to reparent root!");
        }
        this.parent.subcategoryMap.remove(this.name);
        this.parent = newParent;
    }

    private void catagoryRenamed(CategoryDB childCategory, String oldName) {
        this.subcategoryMap.remove(oldName);
        this.subcategoryMap.put(childCategory.getName(), childCategory);
    }

    void dataTypeRenamed(DataType childDataType, String oldName) {
        this.dataTypeMap.remove(oldName);
        this.dataTypeMap.put(childDataType.getName(), childDataType);
    }

    void dataTypeAdded(DataType childDataType) {
        this.dataTypeMap.put(childDataType.getName(), childDataType);
    }

    void dataTypeRemoved(String dataTypeName) {
        this.dataTypeMap.remove(dataTypeName);
    }

    void categoryAdded(CategoryDB cat) {
        this.subcategoryMap.put(cat.getName(), cat);
    }
}

