/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.module.FragmentDB;
import ghidra.program.database.module.GroupDBAdapter;
import ghidra.program.database.module.GroupDBAdapterV0;
import ghidra.program.database.module.ModuleDB;
import ghidra.program.database.module.TreeManager;
import ghidra.program.database.util.AddressRangeMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Lock;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

class ModuleManager {
    private AddressMap addrMap;
    private long treeID;
    private GroupDBAdapter adapter;
    private DBObjectCache<ModuleDB> moduleCache;
    private DBObjectCache<FragmentDB> fragCache;
    private ProgramDB program;
    private TreeManager treeMgr;
    private HashSet<String> nameSet;
    private AddressRangeMapDB fragMap;
    private ErrorHandler errHandler;
    private Record record;
    private Object versionTag;
    private Lock lock;
    static long ROOT_MODULE_ID = 0L;

    ModuleManager(TreeManager treeMgr, Record rec, ProgramDB program, boolean createTables) throws IOException {
        this.treeMgr = treeMgr;
        this.treeID = rec.getKey();
        this.record = rec;
        this.program = program;
        this.lock = treeMgr.getLock();
        this.versionTag = new Object();
        DBHandle handle = treeMgr.getDatabaseHandle();
        this.addrMap = treeMgr.getAddressMap();
        this.nameSet = new HashSet();
        this.errHandler = treeMgr.getErrorHandler();
        this.fragMap = new AddressRangeMapDB(handle, this.addrMap, this.lock, TreeManager.getFragAddressTableName(this.treeID), this.errHandler, LongField.class, true);
        if (createTables) {
            this.createDBTables(handle);
        }
        this.findAdapters(handle);
        this.moduleCache = new DBObjectCache(100);
        this.fragCache = new DBObjectCache(100);
        if (createTables) {
            this.createRootModule();
        }
    }

    Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addressUpgrade(TreeManager treeMgr, long treeID, String name, AddressMap addrMap, TaskMonitor monitor) throws IOException, CancelledException {
        DBHandle handle = treeMgr.getDatabaseHandle();
        ErrorHandler errHandler = treeMgr.getErrorHandler();
        String mapName = TreeManager.getFragAddressTableName(treeID);
        AddressRangeMapDB map = new AddressRangeMapDB(handle, addrMap.getOldAddressMap(), treeMgr.getLock(), mapName, errHandler, LongField.class, true);
        if (map.isEmpty()) {
            return;
        }
        monitor.setMessage("Upgrading Program Tree (" + name + ")...");
        try (DBHandle tmpDb = new DBHandle();){
            AddressRange range;
            tmpDb.startTransaction();
            monitor.initialize((long)map.getRecordCount());
            int count = 0;
            AddressRangeMapDB tmpMap = new AddressRangeMapDB(tmpDb, addrMap, new Lock("Tmp Upgrade"), mapName, errHandler, LongField.class, false);
            AddressRangeIterator iter = map.getAddressRanges();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                range = (AddressRange)iter.next();
                Address startAddr = range.getMinAddress();
                Address endAddr = range.getMaxAddress();
                Field value = map.getValue(startAddr);
                tmpMap.paintRange(startAddr, endAddr, value);
                monitor.setProgress((long)(++count));
            }
            monitor.initialize((long)count);
            count = 0;
            map.dispose();
            map = new AddressRangeMapDB(handle, addrMap, treeMgr.getLock(), mapName, errHandler, LongField.class, true);
            iter = tmpMap.getAddressRanges();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                range = (AddressRange)iter.next();
                map.paintRange(range.getMinAddress(), range.getMaxAddress(), tmpMap.getValue(range.getMinAddress()));
                monitor.setProgress((long)(++count));
            }
            tmpMap.dispose();
        }
    }

    void setName(String name) {
        this.lock.acquire();
        try {
            this.record.setString(0, name);
            this.treeMgr.updateTreeRecord(this.record, false);
        }
        finally {
            this.lock.release();
        }
    }

    void imageBaseChanged(boolean commit) {
        this.lock.acquire();
        try {
            if (commit) {
                this.treeMgr.updateTreeRecord(this.record, true);
            }
            this.invalidateCache();
        }
        finally {
            this.lock.release();
        }
    }

    private void createRootModule() throws IOException {
        Record rootRecord = this.adapter.createRootModule(this.program.getName());
        ModuleDB root = new ModuleDB(this, this.moduleCache, rootRecord);
        this.nameSet.add(root.getName());
    }

    GroupDBAdapter getGroupDBAdapter() {
        return this.adapter;
    }

    void dbError(IOException e) {
        this.errHandler.dbError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProgramName(String oldName, String newName) {
        this.lock.acquire();
        try {
            ModuleDB root = this.getModuleDB(ROOT_MODULE_ID);
            Record rec = root.getRecord();
            rec.setString(0, newName);
            this.adapter.updateModuleRecord(rec);
            this.treeMgr.updateTreeRecord(this.record);
            this.nameChanged(oldName, root);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    ProgramModule getRootModule() throws IOException {
        return this.getModuleDB(0L);
    }

    ProgramModule getModule(String name) throws IOException {
        Record moduleRecord = this.adapter.getModuleRecord(name);
        return this.getModuleDB(moduleRecord);
    }

    ProgramFragment getFragment(String name) throws IOException {
        Record fragmentRecord = this.adapter.getFragmentRecord(name);
        return this.getFragmentDB(fragmentRecord);
    }

    ProgramFragment getFragment(Address addr) throws IOException {
        Field field = this.fragMap.getValue(addr);
        if (field != null) {
            return this.getFragmentDB(field.getLongValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMemoryBlock(String name, AddressRange range) throws IOException {
        this.lock.acquire();
        try {
            FragmentDB frag = (FragmentDB)this.getFragment(name);
            if (frag == null) {
                frag = this.createFragmentAdjustNameAsNeeded(name);
            }
            frag.addRange(range);
            this.fragMap.paintRange(range.getMinAddress(), range.getMaxAddress(), (Field)new LongField(frag.getKey()));
            this.treeMgr.updateTreeRecord(this.record);
            this.versionTag = new Object();
        }
        finally {
            this.lock.release();
        }
    }

    private FragmentDB createFragmentAdjustNameAsNeeded(String baseName) throws IOException {
        ProgramModule root = this.getRootModule();
        Object newFragmentName = baseName;
        long counter = 0L;
        while (true) {
            try {
                return (FragmentDB)root.createFragment((String)newFragmentName);
            }
            catch (DuplicateNameException e) {
                newFragmentName = baseName + "." + ++counter;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMemoryBlock(Address startAddr, Address endAddr, TaskMonitor monitor) throws IOException {
        this.lock.acquire();
        try {
            AddressRangeIterator iter = this.fragMap.getAddressRanges(startAddr, endAddr);
            while (iter.hasNext() && !monitor.isCancelled()) {
                AddressRange range = (AddressRange)iter.next();
                Field field = this.fragMap.getValue(range.getMinAddress());
                FragmentDB frag = this.getFragmentDB(field.getLongValue());
                frag.removeRange(new AddressRangeImpl(range.getMinAddress(), range.getMaxAddress()));
                if (!frag.isEmpty()) continue;
                this.removeFragment(frag);
            }
            if (monitor.isCancelled()) {
                return;
            }
            this.fragMap.clearRange(startAddr, endAddr);
            this.treeMgr.updateTreeRecord(this.record);
            this.invalidateCache();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, CancelledException {
        this.lock.acquire();
        try {
            Address rangeEnd = fromAddr.addNoWrap(length - 1L);
            AddressSet addrSet = new AddressSet(fromAddr, rangeEnd);
            ArrayList<FragmentHolder> list = new ArrayList<FragmentHolder>();
            AddressRangeIterator rangeIter = this.fragMap.getAddressRanges(fromAddr, rangeEnd);
            while (rangeIter.hasNext() && !addrSet.isEmpty()) {
                monitor.checkCanceled();
                AddressRange range = (AddressRange)rangeIter.next();
                Field field = this.fragMap.getValue(range.getMinAddress());
                try {
                    FragmentDB frag = this.getFragmentDB(field.getLongValue());
                    AddressSet intersection = addrSet.intersect(frag);
                    AddressRangeIterator fragRangeIter = intersection.getAddressRanges();
                    while (fragRangeIter.hasNext() && !monitor.isCancelled()) {
                        AddressRange fragRange = (AddressRange)fragRangeIter.next();
                        Address startAddr = fragRange.getMinAddress();
                        Address endAddr = fragRange.getMaxAddress();
                        long offset = startAddr.subtract(fromAddr);
                        startAddr = toAddr.add(offset);
                        offset = endAddr.subtract(fromAddr);
                        endAddr = toAddr.add(offset);
                        AddressRangeImpl newRange = new AddressRangeImpl(startAddr, endAddr);
                        frag.removeRange(fragRange);
                        list.add(new FragmentHolder(frag, newRange));
                    }
                    addrSet = addrSet.subtract(intersection);
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                    this.lock.release();
                    return;
                }
            }
            monitor.checkCanceled();
            this.fragMap.clearRange(fromAddr, rangeEnd);
            for (int i = 0; i < list.size(); ++i) {
                monitor.checkCanceled();
                FragmentHolder fh = (FragmentHolder)list.get(i);
                this.fragMap.paintRange(fh.range.getMinAddress(), fh.range.getMaxAddress(), (Field)new LongField(fh.frag.getKey()));
                fh.frag.addRange(fh.range);
            }
            this.treeMgr.updateTreeRecord(this.record);
            this.program.programTreeChanged(this.treeID, 87, null, new AddressRangeImpl(fromAddr, rangeEnd), new AddressRangeImpl(toAddr, toAddr.addNoWrap(length - 1L)));
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fragmentAdded(long parentID, ProgramFragment fragment) {
        this.lock.acquire();
        try {
            ModuleDB parent = this.getModuleDB(parentID);
            this.nameSet.add(fragment.getName());
            this.treeMgr.updateTreeRecord(this.record);
            this.program.programTreeChanged(this.treeID, 81, null, parent, fragment);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moduleAdded(long parentID, ProgramModule module) {
        this.lock.acquire();
        try {
            ModuleDB parent = this.getModuleDB(parentID);
            this.nameSet.add(module.getName());
            this.treeMgr.updateTreeRecord(this.record);
            this.program.programTreeChanged(this.treeID, 81, null, parent, module);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void groupRemoved(ModuleDB parentModule, long childID, String childName, boolean isFragment, boolean deleteChild) {
        this.lock.acquire();
        try {
            if (deleteChild && isFragment) {
                this.nameSet.remove(childName);
                this.fragCache.delete(childID);
            } else if (deleteChild) {
                this.nameSet.remove(childName);
                this.moduleCache.delete(childID);
            }
            this.treeMgr.updateTreeRecord(this.record);
            this.program.programTreeChanged(this.treeID, 82, null, parentModule, childName);
        }
        finally {
            this.lock.release();
        }
    }

    void commentsChanged(String oldComments, Group group) {
        this.lock.acquire();
        try {
            this.treeMgr.updateTreeRecord(this.record);
            this.program.programTreeChanged(this.treeID, 84, null, oldComments, group);
        }
        finally {
            this.lock.release();
        }
    }

    void nameChanged(String oldName, Group group) {
        this.lock.acquire();
        try {
            this.nameSet.remove(oldName);
            this.nameSet.add(group.getName());
            this.treeMgr.updateTreeRecord(this.record);
            this.program.programTreeChanged(this.treeID, 83, null, oldName, group);
        }
        finally {
            this.lock.release();
        }
    }

    boolean isDescendant(long ID, long moduleID) throws IOException {
        long[] keys = this.adapter.getParentChildKeys(moduleID, 0);
        if (keys.length == 0) {
            return false;
        }
        for (long key : keys) {
            Record parentChildRecord = this.adapter.getParentChildRecord(key);
            long childID = parentChildRecord.getLongValue(1);
            if (childID == ID) {
                return true;
            }
            if (!this.isDescendant(ID, childID)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FragmentDB getFragmentDB(Record fragmentRecord) {
        this.lock.acquire();
        try {
            if (fragmentRecord == null) {
                FragmentDB fragmentDB = null;
                return fragmentDB;
            }
            FragmentDB f = this.fragCache.get(fragmentRecord.getKey());
            if (f != null) {
                FragmentDB fragmentDB = f;
                return fragmentDB;
            }
            FragmentDB fragmentDB = this.createFragmentDB(fragmentRecord);
            return fragmentDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FragmentDB getFragmentDB(long fragID) throws IOException {
        this.lock.acquire();
        try {
            FragmentDB frag = this.fragCache.get(fragID);
            if (frag != null) {
                FragmentDB fragmentDB = frag;
                return fragmentDB;
            }
            Record fragmentRecord = this.adapter.getFragmentRecord(fragID);
            FragmentDB fragmentDB = this.createFragmentDB(fragmentRecord);
            return fragmentDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleDB getModuleDB(Record moduleRecord) {
        this.lock.acquire();
        try {
            if (moduleRecord == null) {
                ModuleDB moduleDB = null;
                return moduleDB;
            }
            ModuleDB moduleDB = this.moduleCache.get(moduleRecord.getKey());
            if (moduleDB != null) {
                ModuleDB moduleDB2 = moduleDB;
                return moduleDB2;
            }
            ModuleDB moduleDB3 = this.createModuleDB(moduleRecord);
            return moduleDB3;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleDB getModuleDB(long moduleID) throws IOException {
        this.lock.acquire();
        try {
            ModuleDB moduleDB = this.moduleCache.get(moduleID);
            if (moduleDB != null) {
                ModuleDB moduleDB2 = moduleDB;
                return moduleDB2;
            }
            Record moduleRecord = this.adapter.getModuleRecord(moduleID);
            ModuleDB moduleDB3 = this.createModuleDB(moduleRecord);
            return moduleDB3;
        }
        finally {
            this.lock.release();
        }
    }

    String getTreeName() {
        return this.treeMgr.getTreeName(this.treeID);
    }

    CodeUnitIterator getCodeUnits(FragmentDB fragmentDB) {
        return this.program.getListing().getCodeUnits(fragmentDB, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(FragmentDB destFrag, Address min, Address max) throws NotFoundException {
        this.lock.acquire();
        try {
            if (!this.program.getMemory().contains(min, max)) {
                throw new NotFoundException("Address range for " + min + ", " + max + " is not contained in memory");
            }
            AddressSet set = new AddressSet();
            AddressRangeIterator iter = this.fragMap.getAddressRanges(min, max);
            AddressSet addrSet = new AddressSet(min, max);
            while (iter.hasNext() && !addrSet.isEmpty()) {
                AddressRange range = (AddressRange)iter.next();
                Field field = this.fragMap.getValue(range.getMinAddress());
                try {
                    FragmentDB frag = this.getFragmentDB(field.getLongValue());
                    if (frag == destFrag) continue;
                    AddressSet intersection = addrSet.intersect(frag);
                    AddressRangeIterator fragRangeIter = intersection.getAddressRanges();
                    while (fragRangeIter.hasNext()) {
                        AddressRange fragRange = (AddressRange)fragRangeIter.next();
                        set.add(fragRange);
                        frag.removeRange(fragRange);
                    }
                    addrSet = addrSet.subtract(intersection);
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                    this.lock.release();
                    return;
                }
            }
            LongField field = new LongField(destFrag.getKey());
            AddressRangeIterator rangeIter = set.getAddressRanges();
            while (rangeIter.hasNext()) {
                AddressRange range = (AddressRange)rangeIter.next();
                this.fragMap.paintRange(range.getMinAddress(), range.getMaxAddress(), (Field)field);
                destFrag.addRange(range);
            }
            this.treeMgr.updateTreeRecord(this.record);
            this.program.programTreeChanged(this.treeID, 32, null, min, max);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FragmentDB getFragment(CodeUnit cu) {
        block6: {
            this.lock.acquire();
            try {
                Field field = this.fragMap.getValue(cu.getMinAddress());
                if (field == null) break block6;
                try {
                    FragmentDB fragmentDB = this.getFragmentDB(field.getLongValue());
                    return fragmentDB;
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
            }
            finally {
                this.lock.release();
            }
        }
        return null;
    }

    void childReordered(ModuleDB parentModule, Group child) {
        this.treeMgr.updateTreeRecord(this.record);
        this.program.programTreeChanged(this.treeID, 86, parentModule, child, child);
    }

    void childReparented(Group group, String oldParentName, String newParentName) {
        this.treeMgr.updateTreeRecord(this.record);
        this.program.programTreeChanged(this.treeID, 88, group, oldParentName, newParentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getParentNames(long childID) {
        this.lock.acquire();
        try {
            long[] keys = this.adapter.getParentChildKeys(childID, 1);
            String[] names = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                Record parentChildRecord = this.adapter.getParentChildRecord(keys[i]);
                Record mrec = this.adapter.getModuleRecord(parentChildRecord.getLongValue(0));
                names[i] = mrec.getString(0);
            }
            String[] stringArray = names;
            return stringArray;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProgramModule[] getParents(long childID) {
        this.lock.acquire();
        try {
            long[] keys = this.adapter.getParentChildKeys(childID, 1);
            ProgramModule[] modules = new ProgramModule[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                Record parentChildRecord = this.adapter.getParentChildRecord(keys[i]);
                Record mrec = this.adapter.getModuleRecord(parentChildRecord.getLongValue(0));
                modules[i] = this.getModuleDB(mrec);
            }
            ProgramModule[] programModuleArray = modules;
            return programModuleArray;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new ProgramModule[0];
    }

    private void findAdapters(DBHandle handle) throws IOException {
        try {
            this.adapter = new GroupDBAdapterV0(handle, this.getModuleTableName(), this.getFragmentTableName(), this.getParentChildTableName());
        }
        catch (VersionException e) {
            throw new IOException("Module tables created with newer version");
        }
    }

    private void createDBTables(DBHandle handle) throws IOException {
        handle.createTable(this.getModuleTableName(), TreeManager.MODULE_SCHEMA, new int[]{0});
        handle.createTable(this.getFragmentTableName(), TreeManager.FRAGMENT_SCHEMA, new int[]{0});
        handle.createTable(this.getParentChildTableName(), TreeManager.PARENT_CHILD_SCHEMA, new int[]{0, 1});
    }

    private String getModuleTableName() {
        return TreeManager.getModuleTableName(this.treeID);
    }

    private String getFragmentTableName() {
        return TreeManager.getFragmentTableName(this.treeID);
    }

    private String getParentChildTableName() {
        return TreeManager.getParentChildTableName(this.treeID);
    }

    private ModuleDB createModuleDB(Record moduleRecord) {
        if (moduleRecord != null) {
            ModuleDB moduleDB = new ModuleDB(this, this.moduleCache, moduleRecord);
            this.nameSet.add(moduleDB.getName());
            return moduleDB;
        }
        return null;
    }

    private FragmentDB createFragmentDB(Record fragmentRecord) {
        if (fragmentRecord != null) {
            FragmentDB f = new FragmentDB(this, this.fragCache, fragmentRecord, this.getFragmentAddressSet(fragmentRecord.getKey()));
            this.nameSet.add(f.getName());
            return f;
        }
        return null;
    }

    private void removeFragment(FragmentDB frag) {
        ProgramModule[] parents;
        for (ProgramModule parent : parents = frag.getParents()) {
            try {
                parent.removeChild(frag.getName());
            }
            catch (NotEmptyException e) {
                throw new AssertException("Should have removed " + frag.getName());
            }
        }
        this.fragCache.delete(frag.getKey());
    }

    AddressSet getFragmentAddressSet(long fragID) {
        return this.fragMap.getAddressSet((Field)new LongField(fragID));
    }

    public void invalidateCache() {
        this.lock.acquire();
        try {
            this.versionTag = new Object();
            this.moduleCache.invalidate();
            this.fragCache.invalidate();
            this.record = this.treeMgr.getTreeRecord(this.treeID);
        }
        finally {
            this.lock.release();
        }
    }

    Object getVersionTag() {
        return this.versionTag;
    }

    ProgramDB getProgram() {
        return this.program;
    }

    public long getModificationNumber() {
        return this.record.getLongValue(1);
    }

    public void dispose() {
        this.fragMap.dispose();
    }

    public long getTreeID() {
        return this.treeID;
    }

    private class FragmentHolder {
        FragmentDB frag;
        AddressRange range;

        FragmentHolder(FragmentDB frag, AddressRange range) {
            this.frag = frag;
            this.range = range;
        }
    }
}

