/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.pcodeCPort.slgh_compile.PcodeParser;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadCallfixup;
import ghidra.program.model.lang.InjectPayloadCallother;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Program;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.JDOMException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PcodeInjectLibrary {
    private SleighLanguage language;
    private long uniqueBase;
    private Map<String, InjectPayload> callFixupMap;
    private Map<String, InjectPayload> callOtherFixupMap;
    private Map<String, InjectPayload> callMechFixupMap;
    private Map<String, InjectPayload> exePcodeMap;

    public PcodeInjectLibrary(SleighLanguage l) {
        this.language = l;
        this.uniqueBase = this.language.getUniqueBase();
        this.callFixupMap = new TreeMap<String, InjectPayload>();
        this.callOtherFixupMap = new TreeMap<String, InjectPayload>();
        this.callMechFixupMap = new TreeMap<String, InjectPayload>();
        this.exePcodeMap = new TreeMap<String, InjectPayload>();
    }

    public InjectPayload getPayload(int type, String name, Program program, String context) {
        if (name == null) {
            return null;
        }
        if (type == 1) {
            return this.callFixupMap.get(name);
        }
        if (type == 2) {
            return this.callOtherFixupMap.get(name);
        }
        if (type == 3) {
            return this.callMechFixupMap.get(name);
        }
        if (type == 4) {
            return this.exePcodeMap.get(name);
        }
        return null;
    }

    private void parseInject(InjectPayload payload) throws SleighException {
        String sourceName = payload.getSource();
        if (sourceName == null) {
            sourceName = "unknown";
        }
        if (!(payload instanceof InjectPayloadSleigh)) {
            return;
        }
        InjectPayloadSleigh payloadSleigh = (InjectPayloadSleigh)payload;
        String translateSpec = this.language.buildTranslatorTag(this.language.getAddressFactory(), this.uniqueBase, this.language.getSymbolTable());
        String pcodeText = payloadSleigh.releaseParseString();
        if (pcodeText == null) {
            return;
        }
        try {
            InjectPayload.InjectParameter[] output;
            InjectPayload.InjectParameter[] input;
            PcodeParser parser = new PcodeParser(translateSpec);
            Location loc = new Location(sourceName, 1);
            for (InjectPayload.InjectParameter element : input = payload.getInput()) {
                parser.addOperand(loc, element.getName(), element.getIndex());
            }
            for (InjectPayload.InjectParameter element : output = payload.getOutput()) {
                parser.addOperand(loc, element.getName(), element.getIndex());
            }
            String constructTplXml = PcodeParser.stringifyTemplate(parser.compilePcode(pcodeText, sourceName, 1));
            if (constructTplXml == null) {
                throw new SleighException("pcode compile failed " + sourceName);
            }
            final SAXParseException[] exception = new SAXParseException[1];
            XmlPullParser xmlParser = XmlPullParserFactory.create((String)constructTplXml, (String)sourceName, (ErrorHandler)new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    Msg.warn((Object)this, (Object)e.getMessage());
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    exception[0] = e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    exception[0] = e;
                }
            }, (boolean)false);
            ConstructTpl constructTpl = new ConstructTpl();
            constructTpl.restoreXml(xmlParser, this.language.getAddressFactory());
            if (exception[0] != null) {
                throw new SleighException("pcode compiler returned invalid xml " + sourceName, exception[0]);
            }
            OpTpl[] opTemplates = constructTpl.getOpVec();
            this.adjustUniqueBase(opTemplates);
            payloadSleigh.setTemplate(constructTpl);
        }
        catch (UnknownInstructionException e) {
            throw new SleighException("compiled pcode contains invalid opcode " + sourceName, (Throwable)((Object)e));
        }
        catch (JDOMException e) {
            throw new SleighException("pcode compile failed due to invalid translator tag " + sourceName, e);
        }
        catch (SAXException e) {
            throw new SleighException("pcode compiler returned invalid xml " + sourceName, e);
        }
    }

    protected void adjustUniqueBase(OpTpl[] opTemplates) {
        for (OpTpl opt : opTemplates) {
            VarnodeTpl out = opt.getOutput();
            if (out != null) {
                this.adjustUniqueBase(out);
            }
            for (VarnodeTpl in : opt.getInput()) {
                this.adjustUniqueBase(in);
            }
        }
    }

    private void adjustUniqueBase(VarnodeTpl v) {
        ConstTpl space = v.getSpace();
        if (!space.isUniqueSpace()) {
            return;
        }
        ConstTpl c = v.getOffset();
        long offset = c.getReal();
        if (offset >= this.uniqueBase) {
            this.uniqueBase = offset + 16L;
        }
    }

    public String[] getCallFixupNames() {
        Set<String> keySet = this.callFixupMap.keySet();
        String[] names = new String[keySet.size()];
        keySet.toArray(names);
        return names;
    }

    public InjectContext buildInjectContext() {
        InjectContext res = new InjectContext();
        res.language = this.language;
        return res;
    }

    protected void registerInject(InjectPayload payload) {
        switch (payload.getType()) {
            case 1: {
                if (this.callFixupMap.containsKey(payload.getName())) {
                    throw new SleighException("CallFixup registered multiple times: " + payload.getName());
                }
                this.callFixupMap.put(payload.getName(), payload);
                break;
            }
            case 2: {
                if (this.callOtherFixupMap.size() == 0) {
                    int max = this.language.getNumberOfUserDefinedOpNames();
                    for (int i = 0; i < max; ++i) {
                        String opname = this.language.getUserDefinedOpName(i);
                        this.callOtherFixupMap.put(opname, null);
                    }
                }
                if (!this.callOtherFixupMap.containsKey(payload.getName())) {
                    throw new SleighException("Unknown callother name in <callotherfixup>: " + payload.getName());
                }
                if (this.callOtherFixupMap.get(payload.getName()) != null) {
                    throw new SleighException("Duplicate <callotherfixup> tag: " + payload.getName());
                }
                this.callOtherFixupMap.put(payload.getName(), payload);
                break;
            }
            case 3: {
                if (this.callMechFixupMap.containsKey(payload.getName())) {
                    throw new SleighException("CallMechanism registered multiple times: " + payload.getName());
                }
                this.callMechFixupMap.put(payload.getName(), payload);
                break;
            }
            case 4: {
                if (this.exePcodeMap.containsKey(payload.getName())) {
                    throw new SleighException("Executable p-code registered multiple times: " + payload.getName());
                }
                this.exePcodeMap.put(payload.getName(), payload);
                break;
            }
            default: {
                throw new SleighException("Unknown p-code inject type");
            }
        }
        this.parseInject(payload);
    }

    protected InjectPayloadSleigh allocateInject(String sourceName, String name, int tp) {
        if (tp == 1) {
            return new InjectPayloadCallfixup(sourceName);
        }
        if (tp == 2) {
            return new InjectPayloadCallother(sourceName);
        }
        return new InjectPayloadSleigh(name, tp, sourceName);
    }

    public InjectPayload restoreXmlInject(String source, String name, int tp, XmlPullParser parser) {
        InjectPayloadSleigh payload = this.allocateInject(source, name, tp);
        payload.restoreXml(parser);
        this.registerInject(payload);
        return payload;
    }

    public ConstantPool getConstantPool(Program program) throws IOException {
        return null;
    }

    protected long getUniqueBase() {
        return this.uniqueBase;
    }
}

