/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import generic.hash.SimpleCRC32;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class DynamicHash {
    public static final int[] transtable = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 13, 13, 15, 15, 17, 18, 19, 19, 21, 22, 23, 24, 25, 26, 27, 28, 32, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 41, 43, 43, 0, 46, 47, 48, 49, 47, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 19, 19, 67, 68, 69};
    private int vnproc;
    private int opproc;
    private int opedgeproc;
    private ArrayList<PcodeOp> markop = new ArrayList();
    private ArrayList<Varnode> markvn = new ArrayList();
    private ArrayList<Varnode> vnedge = new ArrayList();
    private ArrayList<ToOpEdge> opedge = new ArrayList();
    private HashSet<Object> markset;
    private Address addrresult;
    private long hash;

    private DynamicHash() {
    }

    public DynamicHash(Varnode root, int method) {
        this();
        this.calcHash(root, method);
    }

    public DynamicHash(Varnode root, PcodeSyntaxTree fd) {
        this();
        this.uniqueHash(root, fd);
    }

    public DynamicHash(PcodeOp op, int inputIndex) {
        this();
        VarnodeAST vnroot;
        Varnode[] vnarray = new VarnodeAST[op.getNumInputs()];
        Varnode vn = op.getInput(inputIndex);
        vnarray[inputIndex] = vnroot = new VarnodeAST(vn.getAddress(), vn.getSize(), 0);
        PcodeOp cloneop = new PcodeOp(op.getSeqnum(), op.getOpcode(), vnarray, null);
        vnroot.addDescendant(cloneop);
        this.calcHash(vnroot, 0);
    }

    public long getHash() {
        return this.hash;
    }

    public Address getAddress() {
        return this.addrresult;
    }

    private void clear() {
        this.markop.clear();
        this.markvn.clear();
        this.vnedge.clear();
        this.opedge.clear();
    }

    private void calcHash(Varnode root, int method) {
        int ct;
        this.vnproc = 0;
        this.opproc = 0;
        this.opedgeproc = 0;
        this.markset = new HashSet();
        this.vnedge.add(root);
        this.gatherUnmarkedVn();
        for (int i = this.vnproc; i < this.markvn.size(); ++i) {
            this.buildVnUp(this.markvn.get(i));
        }
        while (this.vnproc < this.markvn.size()) {
            this.buildVnDown(this.markvn.get(this.vnproc));
            ++this.vnproc;
        }
        switch (method) {
            case 0: {
                break;
            }
            case 1: {
                this.gatherUnmarkedOp();
                while (this.opproc < this.markop.size()) {
                    this.buildOpUp(this.markop.get(this.opproc));
                    ++this.opproc;
                }
                this.gatherUnmarkedVn();
                while (this.vnproc < this.markvn.size()) {
                    this.buildVnUp(this.markvn.get(this.vnproc));
                    ++this.vnproc;
                }
                break;
            }
            case 2: {
                this.gatherUnmarkedOp();
                while (this.opproc < this.markop.size()) {
                    this.buildOpDown(this.markop.get(this.opproc));
                    ++this.opproc;
                }
                this.gatherUnmarkedVn();
                while (this.vnproc < this.markvn.size()) {
                    this.buildVnDown(this.markvn.get(this.vnproc));
                    ++this.vnproc;
                }
                break;
            }
            case 3: {
                this.gatherUnmarkedOp();
                while (this.opproc < this.markop.size()) {
                    this.buildOpUp(this.markop.get(this.opproc));
                    ++this.opproc;
                }
                this.gatherUnmarkedVn();
                while (this.vnproc < this.markvn.size()) {
                    this.buildVnDown(this.markvn.get(this.vnproc));
                    ++this.vnproc;
                }
                break;
            }
        }
        if (this.opedge.size() == 0) {
            this.hash = 0L;
            this.addrresult = null;
            return;
        }
        int reg = 1000406534;
        reg = SimpleCRC32.hashOneByte((int)reg, (int)root.getSize());
        if (root.isConstant()) {
            long val = root.getOffset();
            for (int i = 0; i < root.getSize(); ++i) {
                reg = SimpleCRC32.hashOneByte((int)reg, (int)((int)val));
                val >>>= 8;
            }
        }
        for (int i = 0; i < this.opedge.size(); ++i) {
            reg = this.opedge.get(i).hash(reg);
        }
        PcodeOp op = null;
        int slot = 0;
        boolean attachedop = true;
        for (ct = 0; ct < this.opedge.size(); ++ct) {
            op = this.opedge.get(ct).getOp();
            slot = this.opedge.get(ct).getSlot();
            if (slot < 0 && op.getOutput() == root || slot >= 0 && op.getInput(slot) == root) break;
        }
        if (ct == this.opedge.size()) {
            op = this.opedge.get(0).getOp();
            slot = this.opedge.get(0).getSlot();
            attachedop = false;
        }
        this.hash = attachedop ? 0L : 1L;
        this.hash <<= 4;
        this.hash |= (long)method;
        this.hash <<= 7;
        this.hash |= (long)op.getOpcode();
        this.hash <<= 5;
        this.hash |= (long)(slot & 0x1F);
        this.hash <<= 32;
        this.hash |= (long)reg & 0xFFFFFFFFL;
        this.addrresult = op.getSeqnum().getTarget();
    }

    private void uniqueHash(Varnode root, PcodeSyntaxTree fd) {
        int pos;
        ArrayList<Varnode> vnlist = new ArrayList<Varnode>();
        ArrayList<Varnode> vnlist2 = new ArrayList<Varnode>();
        ArrayList champion = new ArrayList();
        long tmphash = 0L;
        Address tmpaddr = null;
        int maxduplicates = 8;
        for (int method = 0; method < 4; ++method) {
            this.clear();
            this.calcHash(root, method);
            if (this.hash == 0L) {
                return;
            }
            tmphash = this.hash;
            tmpaddr = this.addrresult;
            vnlist.clear();
            vnlist2.clear();
            DynamicHash.gatherFirstLevelVars(vnlist, fd, tmpaddr, tmphash);
            for (int i = 0; i < vnlist.size(); ++i) {
                Varnode tmpvn = vnlist.get(i);
                this.clear();
                this.calcHash(tmpvn, method);
                if (this.hash != tmphash) continue;
                vnlist2.add(tmpvn);
                if (vnlist2.size() > maxduplicates) break;
            }
            if (vnlist2.size() > maxduplicates || champion.size() != 0 && vnlist2.size() >= champion.size()) continue;
            champion = vnlist2;
            vnlist2 = new ArrayList();
            if (champion.size() == 1) break;
        }
        if (champion.size() == 0) {
            this.hash = 0L;
            this.addrresult = Address.NO_ADDRESS;
            return;
        }
        int total = champion.size() - 1;
        for (pos = 0; pos <= total && champion.get(pos) != root; ++pos) {
        }
        if (pos > total) {
            this.hash = 0L;
            this.addrresult = Address.NO_ADDRESS;
            return;
        }
        this.hash = tmphash | (long)pos << 49;
        this.hash |= (long)total << 52;
        this.addrresult = tmpaddr;
    }

    private void buildVnUp(Varnode vn) {
        PcodeOp op;
        while (true) {
            PcodeOp tmpop;
            if ((tmpop = vn.getDef()) == null) {
                return;
            }
            op = tmpop;
            if (transtable[op.getOpcode()] != 0) break;
            vn = op.getInput(0);
        }
        this.opedge.add(new ToOpEdge(op, -1));
    }

    private void buildVnDown(Varnode vn) {
        Iterator<PcodeOp> iter = vn.getDescendants();
        if (iter == null) {
            return;
        }
        ArrayList<ToOpEdge> newedge = new ArrayList<ToOpEdge>();
        while (iter.hasNext()) {
            PcodeOp op = iter.next();
            Varnode tmpvn = vn;
            while (transtable[op.getOpcode()] == 0) {
                tmpvn = op.getOutput();
                if (tmpvn == null) {
                    op = null;
                    break;
                }
                op = tmpvn.getLoneDescend();
                if (op != null) continue;
            }
            if (op == null) continue;
            int slot = op.getSlot(tmpvn);
            newedge.add(new ToOpEdge(op, slot));
        }
        if (newedge.size() > 1) {
            Collections.sort(newedge);
        }
        this.opedge.addAll(newedge);
    }

    private void buildOpUp(PcodeOp op) {
        for (int i = 0; i < op.getNumInputs(); ++i) {
            Varnode vn = op.getInput(i);
            this.vnedge.add(vn);
        }
    }

    private void buildOpDown(PcodeOp op) {
        Varnode vn = op.getOutput();
        if (vn == null) {
            return;
        }
        this.vnedge.add(vn);
    }

    private void gatherUnmarkedVn() {
        for (Varnode vn : this.vnedge) {
            if (this.markset.contains(vn)) continue;
            this.markvn.add(vn);
            this.markset.add(vn);
        }
        this.vnedge.clear();
    }

    private void gatherUnmarkedOp() {
        while (this.opedgeproc < this.opedge.size()) {
            PcodeOp op = this.opedge.get(this.opedgeproc).getOp();
            if (!this.markset.contains(op)) {
                this.markop.add(op);
                this.markset.add(op);
            }
            ++this.opedgeproc;
        }
    }

    public static Varnode findVarnode(PcodeSyntaxTree fd, Address addr, long h) {
        DynamicHash dhash = new DynamicHash();
        int method = DynamicHash.getMethodFromHash(h);
        int total = DynamicHash.getTotalFromHash(h);
        int pos = DynamicHash.getPositionFromHash(h);
        h = DynamicHash.clearTotalPosition(h);
        ArrayList<Varnode> vnlist = new ArrayList<Varnode>();
        ArrayList<Varnode> vnlist2 = new ArrayList<Varnode>();
        DynamicHash.gatherFirstLevelVars(vnlist, fd, addr, h);
        for (int i = 0; i < vnlist.size(); ++i) {
            Varnode tmpvn = vnlist.get(i);
            dhash.clear();
            dhash.calcHash(tmpvn, method);
            if (dhash.getHash() != h) continue;
            vnlist2.add(tmpvn);
        }
        if (total != vnlist2.size()) {
            return null;
        }
        return (Varnode)vnlist2.get(pos);
    }

    public static void gatherFirstLevelVars(ArrayList<Varnode> varlist, PcodeSyntaxTree fd, Address addr, long h) {
        int opc = DynamicHash.getOpCodeFromHash(h);
        int slot = DynamicHash.getSlotFromHash(h);
        boolean isnotattached = DynamicHash.getIsNotAttached(h);
        Iterator<PcodeOpAST> iter = fd.getPcodeOps(addr);
        while (iter.hasNext()) {
            Varnode vn;
            PcodeOp op = iter.next();
            if (op.getOpcode() != opc) continue;
            if (slot < 0) {
                vn = op.getOutput();
                if (vn == null || isnotattached && (op = vn.getLoneDescend()) != null && transtable[op.getOpcode()] == 0 && (vn = op.getOutput()) == null) continue;
                varlist.add(vn);
                continue;
            }
            if (slot >= op.getNumInputs()) continue;
            vn = op.getInput(slot);
            if (isnotattached && (op = vn.getDef()) != null && transtable[op.getOpcode()] == 0) {
                vn = op.getInput(0);
            }
            varlist.add(vn);
        }
    }

    public static int getSlotFromHash(long h) {
        int res = (int)(h >> 32 & 0x1FL);
        if (res == 31) {
            res = -1;
        }
        return res;
    }

    public static int getMethodFromHash(long h) {
        return (int)(h >> 44 & 0xFL);
    }

    public static int getOpCodeFromHash(long h) {
        return (int)(h >> 37 & 0x7FL);
    }

    public static int getPositionFromHash(long h) {
        return (int)(h >> 49 & 7L);
    }

    public static int getTotalFromHash(long h) {
        return (int)(h >> 52 & 7L) + 1;
    }

    public static boolean getIsNotAttached(long h) {
        return (h >> 48 & 1L) != 0L;
    }

    public static long clearTotalPosition(long h) {
        long val = 63L;
        val <<= 49;
        return h &= (val ^= 0xFFFFFFFFFFFFFFFFL);
    }

    private static boolean matchWithPossibleExtension(long val1, int size, long extendval) {
        if (extendval >= 0L) {
            return val1 == extendval;
        }
        long mask = -1L;
        long maskcomp = (mask >>>= (8 - size) * 8) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((extendval & (maskcomp >>= 1)) != maskcomp) {
            return false;
        }
        return val1 == (mask & extendval);
    }

    public static long[] calcConstantHash(Instruction instr, long value) {
        long[] tmp = new long[2];
        int count = 0;
        for (PcodeOp op : instr.getPcode(true)) {
            Varnode[] inputs = op.getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                if (!inputs[i].isConstant() || !DynamicHash.matchWithPossibleExtension(inputs[i].getOffset(), inputs[i].getSize(), value)) continue;
                if (count >= tmp.length) {
                    long[] newtmp = new long[count + 10];
                    for (int j = 0; j < tmp.length; ++j) {
                        newtmp[j] = tmp[j];
                    }
                    tmp = newtmp;
                }
                DynamicHash dynamicHash = new DynamicHash(op, i);
                tmp[count] = dynamicHash.getHash();
                if (tmp[count] == 0L) continue;
                ++count;
            }
        }
        long[] res = new long[count];
        for (int i = 0; i < count; ++i) {
            res[i] = tmp[i];
        }
        return res;
    }

    private class ToOpEdge
    implements Comparable<ToOpEdge> {
        private PcodeOp op;
        private int slot;

        public ToOpEdge(PcodeOp o, int s) {
            this.op = o;
            this.slot = s;
        }

        public PcodeOp getOp() {
            return this.op;
        }

        public int getSlot() {
            return this.slot;
        }

        public int hash(int reg) {
            reg = SimpleCRC32.hashOneByte((int)reg, (int)this.slot);
            reg = SimpleCRC32.hashOneByte((int)reg, (int)transtable[this.op.getOpcode()]);
            long val = this.op.getSeqnum().getTarget().getOffset();
            int sz = this.op.getSeqnum().getTarget().getSize();
            for (int i = 0; i < sz; i += 8) {
                reg = SimpleCRC32.hashOneByte((int)reg, (int)((int)val));
                val >>= 8;
            }
            return reg;
        }

        @Override
        public int compareTo(ToOpEdge o) {
            int ord2;
            Address addr2;
            Address addr1 = this.op.getSeqnum().getTarget();
            int cmp = addr1.compareTo(addr2 = o.op.getSeqnum().getTarget());
            if (cmp != 0) {
                return cmp;
            }
            int ord1 = this.op.getSeqnum().getOrder();
            if (ord1 != (ord2 = o.op.getSeqnum().getOrder())) {
                return ord1 < ord2 ? -1 : 1;
            }
            if (this.slot == o.slot) {
                return 0;
            }
            return this.slot < o.slot ? -1 : 1;
        }
    }
}

