/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.ResourceName;
import ghidra.app.util.bin.format.ne.ResourceTable;
import ghidra.util.Conv;
import java.io.IOException;

public class Resource {
    public static final short FLAG_MOVEABLE = 16;
    public static final short FLAG_PURE = 32;
    public static final short FLAG_PRELOAD = 64;
    private FactoryBundledWithBinaryReader reader;
    private ResourceTable rt;
    private short fileOffset;
    private short fileLength;
    private short flagword;
    private short resourceID;
    private short handle;
    private short usage;

    Resource(FactoryBundledWithBinaryReader reader, ResourceTable rt) throws IOException {
        this.reader = reader;
        this.rt = rt;
        this.fileOffset = reader.readNextShort();
        this.fileLength = reader.readNextShort();
        this.flagword = reader.readNextShort();
        this.resourceID = reader.readNextShort();
        this.handle = reader.readNextShort();
        this.usage = reader.readNextShort();
    }

    public short getFileOffset() {
        return this.fileOffset;
    }

    public short getFileLength() {
        return this.fileLength;
    }

    public short getFlagword() {
        return this.flagword;
    }

    public short getResourceID() {
        return this.resourceID;
    }

    public short getHandle() {
        return this.handle;
    }

    public short getUsage() {
        return this.usage;
    }

    public boolean isMoveable() {
        return (this.flagword & 0x10) != 0;
    }

    public boolean isPure() {
        return (this.flagword & 0x20) != 0;
    }

    public boolean isPreload() {
        return (this.flagword & 0x40) != 0;
    }

    public int getFileOffsetShifted() {
        int shift_int = Conv.shortToInt((short)this.rt.getAlignmentShiftCount());
        int offset_int = Conv.shortToInt((short)this.fileOffset);
        return offset_int << shift_int;
    }

    public int getFileLengthShifted() {
        int shift_int = Conv.shortToInt((short)this.rt.getAlignmentShiftCount());
        int length_int = Conv.shortToInt((short)this.fileLength);
        return length_int << shift_int;
    }

    public byte[] getBytes() throws IOException {
        return this.reader.readByteArray(this.getFileOffsetShifted(), this.getFileLengthShifted());
    }

    public String toString() {
        if ((this.resourceID & 0x8000) != 0) {
            return "" + (this.resourceID & Short.MAX_VALUE);
        }
        ResourceName[] names = this.rt.getResourceNames();
        for (int i = 0; i < names.length; ++i) {
            if ((long)this.resourceID != names[i].getIndex() - (long)this.rt.getIndex()) continue;
            return names[i].getName();
        }
        throw new RuntimeException("NE - Resource - unknown id - " + Conv.toHexString((short)this.resourceID));
    }
}

