/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.util.Conv;
import java.io.IOException;
import java.util.ArrayList;

public class OMFFileIndex {
    private short cMod;
    private short cRef;
    private short[] modStart;
    private short[] cRefCnt;
    private int[] nameRef;
    private String[] names;

    static OMFFileIndex createOMFFileIndex(FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        OMFFileIndex omfFileIndex = (OMFFileIndex)reader.getFactory().create(OMFFileIndex.class, new Object[0]);
        omfFileIndex.initOMFFileIndex(reader, ptr);
        return omfFileIndex;
    }

    private void initOMFFileIndex(FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        int i;
        int index = ptr;
        this.cMod = reader.readShort(index);
        this.cRef = reader.readShort(index += 2);
        index += 2;
        this.modStart = new short[Conv.shortToInt((short)this.cMod)];
        for (i = 0; i < this.cMod; ++i) {
            this.modStart[i] = reader.readShort(index);
            index += 2;
        }
        this.cRefCnt = new short[Conv.shortToInt((short)this.cMod)];
        for (i = 0; i < this.cMod; ++i) {
            this.cRefCnt[i] = reader.readShort(index);
            index += 2;
        }
        this.nameRef = new int[Conv.shortToInt((short)this.cRef)];
        for (i = 0; i < this.cRef; ++i) {
            this.nameRef[i] = reader.readInt(index);
            index += 4;
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (int i2 = 0; i2 < Conv.shortToInt((short)this.cRef); ++i2) {
            int nameIndex = index + this.nameRef[i2];
            byte len = reader.readByte(nameIndex);
            int length = Conv.byteToInt((byte)len);
            String name = reader.readAsciiString(++nameIndex, length);
            namesList.add(name);
        }
        this.names = new String[namesList.size()];
        namesList.toArray(this.names);
    }

    public short getCMod() {
        return this.cMod;
    }

    public short getCRef() {
        return this.cRef;
    }

    public int[] getNameRef() {
        return this.nameRef;
    }

    public String[] getNames() {
        return this.names;
    }

    public short[] getCRefCnt() {
        return this.cRefCnt;
    }

    public short[] getModStart() {
        return this.modStart;
    }
}

