/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.util.Conv;
import java.io.IOException;

class S_OBJNAME
extends DebugSymbol {
    private int signature;
    private byte nameLen;
    private byte[] padding;

    static S_OBJNAME createS_OBJNAME(short length, short type, FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        S_OBJNAME s_objname = (S_OBJNAME)reader.getFactory().create(S_OBJNAME.class, new Object[0]);
        s_objname.initS_OBJNAME(length, type, reader, ptr);
        return s_objname;
    }

    private void initS_OBJNAME(short length, short type, FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        this.processDebugSymbol(length, type);
        this.signature = reader.readInt(ptr);
        this.nameLen = reader.readByte(ptr += 4);
        this.name = reader.readAsciiString(++ptr, Conv.byteToInt((byte)this.nameLen));
        int sizeOfPadding = 15 + Conv.byteToInt((byte)this.nameLen) + 1;
        this.padding = reader.readByteArray(ptr += this.nameLen + 1, sizeOfPadding);
    }

    public int getSignature() {
        return this.signature;
    }

    public byte getNameLen() {
        return this.nameLen;
    }

    public byte[] getPadding() {
        return this.padding;
    }
}

