/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo2;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class DyldCacheProgramBuilder
extends MachoProgramBuilder {
    private static final int DATA_PAGE_MAP_ENTRY = 1;
    private static final int BYTES_PER_CHAIN_OFFSET = 4;
    private static final int CHAIN_OFFSET_MASK = 16383;
    private static final int DYLD_CACHE_SLIDE_PAGE_ATTR_NO_REBASE = 16384;
    private static final int DYLD_CACHE_SLIDE_PAGE_ATTR_EXTRA = 32768;
    protected DyldCacheHeader dyldCacheHeader;
    private boolean shouldProcessSymbols;
    private boolean shouldCreateDylibSections;
    private boolean shouldAddRelocationEntries;

    protected DyldCacheProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, boolean shouldProcessSymbols, boolean shouldCreateDylibSections, boolean shouldAddRelocationEntries, MessageLog log, TaskMonitor monitor) {
        super(program, provider, fileBytes, log, monitor);
        this.shouldProcessSymbols = shouldProcessSymbols;
        this.shouldCreateDylibSections = shouldCreateDylibSections;
        this.shouldAddRelocationEntries = shouldAddRelocationEntries;
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, boolean shouldProcessSymbols, boolean shouldCreateDylibSections, boolean addRelocationEntries, MessageLog log, TaskMonitor monitor) throws Exception {
        DyldCacheProgramBuilder dyldCacheProgramBuilder = new DyldCacheProgramBuilder(program, provider, fileBytes, shouldProcessSymbols, shouldCreateDylibSections, addRelocationEntries, log, monitor);
        dyldCacheProgramBuilder.build();
    }

    @Override
    protected void build() throws Exception {
        this.monitor.setMessage("Parsing DYLD Cache header ...");
        this.monitor.initialize(1L);
        this.dyldCacheHeader = new DyldCacheHeader(new BinaryReader(this.provider, true));
        this.dyldCacheHeader.parseFromFile(this.shouldProcessSymbols, this.log, this.monitor);
        this.monitor.incrementProgress(1L);
        this.setDyldCacheImageBase();
        this.processDyldCacheMemoryBlocks();
        this.fixPageChains();
        this.markupHeaders();
        this.markupBranchIslands();
        this.createSymbols();
        this.processDylibs();
    }

    private void setDyldCacheImageBase() throws Exception {
        this.monitor.setMessage("Setting image base...");
        this.monitor.initialize(1L);
        this.program.setImageBase(this.space.getAddress(this.dyldCacheHeader.getBaseAddress()), true);
        this.monitor.incrementProgress(1L);
    }

    private void processDyldCacheMemoryBlocks() throws Exception {
        List<DyldCacheMappingInfo> mappingInfos = this.dyldCacheHeader.getMappingInfos();
        this.monitor.setMessage("Processing DYLD mapped memory blocks...");
        this.monitor.initialize((long)mappingInfos.size());
        long endOfMappedOffset = 0L;
        for (DyldCacheMappingInfo mappingInfo : mappingInfos) {
            long offset = mappingInfo.getFileOffset();
            long size = mappingInfo.getSize();
            MemoryBlockUtils.createInitializedBlock(this.program, false, "DYLD", this.space.getAddress(mappingInfo.getAddress()), this.fileBytes, offset, size, "", "", mappingInfo.isRead(), mappingInfo.isWrite(), mappingInfo.isExecute(), this.log);
            if (offset + size > endOfMappedOffset) {
                endOfMappedOffset = offset + size;
            }
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
        if (endOfMappedOffset < this.provider.length()) {
            this.monitor.setMessage("Processing DYLD unmapped memory block...");
            MemoryBlockUtils.createInitializedBlock(this.program, true, "FILE", AddressSpace.OTHER_SPACE.getAddress(endOfMappedOffset), this.fileBytes, endOfMappedOffset, this.provider.length() - endOfMappedOffset, "Useful bytes that don't get mapped into memory", "", false, false, false, this.log);
        }
    }

    private void markupHeaders() throws Exception {
        this.monitor.setMessage("Marking up DYLD headers...");
        this.monitor.initialize(1L);
        this.dyldCacheHeader.parseFromMemory(this.program, this.space, this.log, this.monitor);
        this.dyldCacheHeader.markup(this.program, this.space, this.monitor, this.log);
        this.monitor.incrementProgress(1L);
    }

    private void markupBranchIslands() throws Exception {
        this.monitor.setMessage("Marking up DYLD branch islands...");
        this.monitor.initialize((long)this.dyldCacheHeader.getBranchPoolAddresses().size());
        for (Long addr : this.dyldCacheHeader.getBranchPoolAddresses()) {
            try {
                MachHeader header = MachHeader.createMachHeader((GenericFactory)MessageLogContinuesFactory.create((MessageLog)this.log), this.provider, addr - this.dyldCacheHeader.getBaseAddress());
                header.parse();
                super.markupHeaders(header, this.space.getAddress(addr.longValue()));
            }
            catch (MachException | IOException exception) {
                // empty catch block
            }
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
    }

    private void createSymbols() throws Exception {
        DyldCacheLocalSymbolsInfo localSymbolsInfo = this.dyldCacheHeader.getLocalSymbolsInfo();
        if (localSymbolsInfo != null) {
            this.monitor.setMessage("Processing DYLD symbols...");
            this.monitor.initialize((long)localSymbolsInfo.getNList().size());
            for (NList nlist : localSymbolsInfo.getNList()) {
                if (!nlist.getString().trim().isEmpty()) {
                    try {
                        this.program.getSymbolTable().createLabel(this.space.getAddress(nlist.getValue()), SymbolUtilities.replaceInvalidChars((String)nlist.getString(), (boolean)true), this.program.getGlobalNamespace(), SourceType.IMPORTED);
                    }
                    catch (Exception e) {
                        this.log.appendMsg(e.getMessage() + " " + nlist.getString());
                    }
                }
                this.monitor.checkCanceled();
                this.monitor.incrementProgress(1L);
            }
        }
    }

    private void fixPageChains() throws MemoryAccessException, CancelledException {
        long fixedAddressCount = 0L;
        DyldCacheSlideInfoCommon slideInfo = this.dyldCacheHeader.getSlideInfo();
        if (slideInfo == null || !(slideInfo instanceof DyldCacheSlideInfo2)) {
            this.log.appendMsg("Can't handle version " + slideInfo.getVersion() + " slide info, only version 2");
            return;
        }
        DyldCacheSlideInfo2 slideInfo2 = (DyldCacheSlideInfo2)slideInfo;
        List<DyldCacheMappingInfo> mappingInfos = this.dyldCacheHeader.getMappingInfos();
        DyldCacheMappingInfo dyldCacheMappingInfo = mappingInfos.get(1);
        long dataPageStart = dyldCacheMappingInfo.getAddress();
        long pageSize = slideInfo2.getPageSize();
        long pageStartsCount = slideInfo2.getPageStartsCount();
        long deltaMask = slideInfo2.getDeltaMask();
        long deltaShift = Long.numberOfTrailingZeros(deltaMask);
        long valueAdd = slideInfo2.getValueAdd();
        short[] pageEntries = slideInfo2.getPageStartsEntries();
        short[] extraEntries = slideInfo2.getPageExtrasEntries();
        this.monitor.setMessage("Fixing chained data page pointers...");
        this.monitor.setMaximum(pageStartsCount);
        int index = 0;
        while ((long)index < pageStartsCount) {
            this.monitor.checkCanceled();
            long page = dataPageStart + pageSize * (long)index;
            this.monitor.setProgress((long)index);
            int pageEntry = pageEntries[index] & 0xFFFF;
            if (pageEntry != 16384) {
                ArrayList<Address> unchainedLocList = new ArrayList<Address>(1024);
                if ((pageEntry & 0x8000) != 0) {
                    int extraIndex = pageEntry & 0x3FFF;
                    do {
                        pageEntry = extraEntries[extraIndex] & 0xFFFF;
                        long pageOffset = (pageEntry & 0x3FFF) * 4;
                        this.processPointerChain(unchainedLocList, page, pageOffset, deltaMask, deltaShift, valueAdd);
                        ++extraIndex;
                    } while ((pageEntry & 0x8000) == 0);
                } else {
                    long pageOffset = pageEntry * 4;
                    this.processPointerChain(unchainedLocList, page, pageOffset, deltaMask, deltaShift, valueAdd);
                }
                fixedAddressCount += (long)unchainedLocList.size();
                unchainedLocList.forEach(entry -> {
                    try {
                        this.listing.createData(entry, (DataType)Pointer64DataType.dataType);
                    }
                    catch (CodeUnitInsertionException codeUnitInsertionException) {
                        // empty catch block
                    }
                });
            }
            ++index;
        }
        this.log.appendMsg("Fixed " + fixedAddressCount + " chained pointers.  Creating Pointers");
        this.monitor.setMessage("Created " + fixedAddressCount + " chained pointers");
    }

    private void processPointerChain(List<Address> unchainedLocList, long page, long nextOff, long deltaMask, long deltaShift, long valueAdd) throws MemoryAccessException, CancelledException {
        Address chainStart = this.memory.getProgram().getLanguage().getDefaultSpace().getAddress(page);
        byte[] origBytes = new byte[8];
        long valueMask = -1L >>> (int)(64L - deltaShift);
        long delta = -1L;
        while (delta != 0L) {
            this.monitor.checkCanceled();
            Address chainLoc = chainStart.add(nextOff);
            long chainValue = this.memory.getLong(chainLoc);
            delta = (chainValue & deltaMask) >> (int)deltaShift;
            if ((chainValue &= valueMask) != 0L) {
                chainValue += valueAdd;
            }
            if (this.shouldAddRelocationEntries) {
                this.memory.getBytes(chainLoc, origBytes);
                this.program.getRelocationTable().add(chainLoc, 1, new long[]{chainValue}, origBytes, null);
            }
            this.memory.setLong(chainLoc, chainValue);
            unchainedLocList.add(chainLoc);
            nextOff += delta * 4L;
        }
    }

    private void processDylibs() throws Exception {
        this.monitor.setMessage("Parsing DYLIB's...");
        this.monitor.initialize((long)this.dyldCacheHeader.getImageInfos().size());
        TreeSet<DyldCacheMachoInfo> infoSet = new TreeSet<DyldCacheMachoInfo>((a, b) -> a.headerAddr.compareTo((Object)b.headerAddr));
        for (DyldCacheImageInfo dyldCacheImageInfo : this.dyldCacheHeader.getImageInfos()) {
            infoSet.add(new DyldCacheMachoInfo(this.provider, dyldCacheImageInfo.getAddress() - this.dyldCacheHeader.getBaseAddress(), this.space.getAddress(dyldCacheImageInfo.getAddress()), dyldCacheImageInfo.getPath()));
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Marking up DYLIB headers...");
        this.monitor.initialize((long)infoSet.size());
        for (DyldCacheMachoInfo info : infoSet) {
            info.markupHeaders();
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Adding DYLIB's to program tree...");
        this.monitor.initialize((long)infoSet.size());
        Iterator iter = infoSet.iterator();
        if (iter.hasNext()) {
            DyldCacheMachoInfo curr = (DyldCacheMachoInfo)iter.next();
            do {
                DyldCacheMachoInfo next = iter.hasNext() ? (DyldCacheMachoInfo)iter.next() : null;
                curr.addToProgramTree(next);
                curr = next;
                this.monitor.checkCanceled();
                this.monitor.incrementProgress(1L);
            } while (iter.hasNext());
        }
        this.monitor.setMessage("Processing DYLIB memory blocks...");
        this.monitor.initialize((long)infoSet.size());
        for (DyldCacheMachoInfo info : infoSet) {
            info.processMemoryBlocks();
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
    }

    private class DyldCacheMachoInfo {
        private Address headerAddr;
        private MachHeader header;
        private String path;
        private String name;

        public DyldCacheMachoInfo(ByteProvider provider, long offset, Address headerAddr, String path) throws Exception {
            this.headerAddr = headerAddr;
            this.header = MachHeader.createMachHeader((GenericFactory)MessageLogContinuesFactory.create((MessageLog)DyldCacheProgramBuilder.this.log), provider, offset);
            this.header.parse();
            this.path = path;
            this.name = new File(path).getName();
        }

        public void processMemoryBlocks() throws Exception {
            DyldCacheProgramBuilder.this.processMemoryBlocks(this.header, this.name, DyldCacheProgramBuilder.this.shouldCreateDylibSections, false);
        }

        public void markupHeaders() throws Exception {
            DyldCacheProgramBuilder.this.markupHeaders(this.header, this.headerAddr);
            if (!this.name.isEmpty()) {
                DyldCacheProgramBuilder.this.listing.setComment(this.headerAddr, 3, this.path);
            }
        }

        public void addToProgramTree(DyldCacheMachoInfo next) throws Exception {
            ProgramFragment fragment = DyldCacheProgramBuilder.this.listing.getDefaultRootModule().createFragment(this.path);
            if (next != null) {
                fragment.move(this.headerAddr, next.headerAddr.subtract(1L));
            } else {
                for (DyldCacheMappingInfo mappingInfo : DyldCacheProgramBuilder.this.dyldCacheHeader.getMappingInfos()) {
                    Address mappingAddr = DyldCacheProgramBuilder.this.space.getAddress(mappingInfo.getAddress());
                    if (this.headerAddr.compareTo((Object)mappingAddr) < 0 || this.headerAddr.compareTo((Object)mappingAddr.add(mappingInfo.getSize() - 1L)) > 0) continue;
                    fragment.move(this.headerAddr, mappingAddr.add(mappingInfo.getSize() - 1L));
                }
            }
        }
    }
}

