/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.prelink.NoPreLinkSectionException;
import ghidra.app.util.bin.format.macho.prelink.PrelinkMap;
import ghidra.app.util.bin.format.macho.prelink.PrelinkParser;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.MachoLoader;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.jdom.JDOMException;

public class MachoPrelinkUtils {
    public static List<PrelinkMap> parsePrelinkXml(ByteProvider provider, TaskMonitor monitor) throws IOException, JDOMException {
        try {
            MachHeader mainHeader = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, provider);
            mainHeader.parse();
            monitor.setMessage("Parsing PRELINK XML...");
            return new PrelinkParser(mainHeader, provider).parse(monitor);
        }
        catch (MachException | NoPreLinkSectionException e) {
            return Collections.emptyList();
        }
    }

    public static List<Long> findPrelinkMachoHeaderOffsets(ByteProvider provider, TaskMonitor monitor) throws IOException {
        monitor.setMessage("Finding PRELINK Mach-O headers...");
        monitor.initialize((long)((int)provider.length()));
        ArrayList<Long> list = new ArrayList<Long>();
        for (long offset = 0L; offset < provider.length() - 4L && !monitor.isCancelled(); offset += 8L) {
            monitor.setProgress((long)((int)offset));
            if (MachoPrelinkUtils.getMachoLoadSpec(provider, offset) != null) {
                if (offset <= 0L) continue;
                list.add(offset);
                continue;
            }
            if (offset == 0L) break;
        }
        return list;
    }

    public static BidiMap<PrelinkMap, Long> matchPrelinkToMachoHeaderOffsets(ByteProvider provider, List<PrelinkMap> prelinkList, List<Long> machoHeaderOffsets, TaskMonitor monitor) throws MachException, IOException {
        monitor.setMessage("Matching PRELINK to Mach-O headers...");
        monitor.initialize((long)prelinkList.size());
        DualHashBidiMap map = new DualHashBidiMap();
        long maxModuleIndex = prelinkList.stream().mapToLong(info -> info.getPrelinkModuleIndex()).max().orElse(-1L);
        if (maxModuleIndex >= 0L) {
            Msg.debug(MachoPrelinkUtils.class, (Object)String.format("Using ModuleIndex to find Mach-O offsets (%d module indexes, %d indexed modules found)", maxModuleIndex + 1L, machoHeaderOffsets.size()));
            if (maxModuleIndex + 1L != (long)machoHeaderOffsets.size()) {
                Msg.warn(MachoPrelinkUtils.class, (Object)String.format("Maximum ModuleIndex is not consistent with # of modules found! (%d vs %d)", maxModuleIndex + 1L, machoHeaderOffsets.size()));
            }
            for (PrelinkMap info2 : prelinkList) {
                if (!monitor.isCancelled()) {
                    monitor.incrementProgress(1L);
                    int machoOffsetIndex = (int)info2.getPrelinkModuleIndex();
                    if (machoOffsetIndex == -1 || machoOffsetIndex >= machoHeaderOffsets.size()) continue;
                    long machoHeaderOffset = machoHeaderOffsets.get(machoOffsetIndex);
                    map.put((Object)info2, (Object)machoHeaderOffset);
                    continue;
                }
                break;
            }
        } else {
            Msg.debug(MachoPrelinkUtils.class, (Object)String.format("Using PrelinkExecutableLoadAddr to find Mach-O offsets (%d modules found)", machoHeaderOffsets.size()));
            MachHeader machoHeader = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, provider, 0L, true);
            machoHeader.parse();
            long prelinkStart = MachoPrelinkUtils.getPrelinkStartAddr(machoHeader);
            for (PrelinkMap info3 : prelinkList) {
                if (!monitor.isCancelled()) {
                    monitor.incrementProgress(1L);
                    map.put((Object)info3, (Object)(info3.getPrelinkExecutableLoadAddr() - prelinkStart + machoHeaderOffsets.get(0)));
                    continue;
                }
                break;
            }
        }
        return map;
    }

    public static long getPrelinkStartAddr(MachHeader header) {
        SegmentCommand prelinkTextSegment = header.getSegment("__PRELINK_TEXT");
        if (prelinkTextSegment != null && prelinkTextSegment.getVMsize() > 0L) {
            return prelinkTextSegment.getVMaddress();
        }
        return 0L;
    }

    private static LoadSpec getMachoLoadSpec(ByteProvider provider, long offset) throws IOException {
        LoadSpec loadSpec;
        Collection<LoadSpec> loadSpecs = new MachoLoader().findSupportedLoadSpecs(new ByteProviderWrapper(provider, offset, provider.length() - offset));
        if (!loadSpecs.isEmpty() && (loadSpec = loadSpecs.iterator().next()).getLanguageCompilerSpec() != null) {
            return loadSpec;
        }
        return null;
    }
}

