/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeTranslator;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.OffsetAddressFactory;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VarnodeContext
implements ProcessorContext {
    public Address BAD_ADDRESS = null;
    public static final int BAD_SPACE_ID_VALUE = 65535;
    protected DisassemblerContextImpl offsetContext;
    protected DisassemblerContextImpl spaceContext;
    protected HashMap<Varnode, Varnode> memoryVals = new HashMap();
    private HashMap<Varnode, Varnode> tempVals = new HashMap();
    protected HashMap<Varnode, Varnode> tempUniqueVals = new HashMap();
    protected boolean keepTempUniqueValues = false;
    protected HashSet<Varnode> clearVals = new HashSet();
    protected HashMap<Varnode, Address> lastSet = new HashMap();
    protected HashMap<Varnode, AddressSet> allLastSet = new HashMap();
    protected Program program;
    protected VarnodeTranslator trans;
    protected Varnode[] retVarnodes = null;
    protected Varnode stackVarnode = null;
    protected Register stackReg = null;
    private HashSet<String> validSymbolicStackNames = new HashSet();
    protected static final NotFoundException notFoundExc = new NotFoundException();
    protected boolean hitDest = false;
    protected AddressFactory addrFactory = null;
    protected ProgramContext programContext;
    protected Address currentAddress;
    protected Instruction currentInstruction = null;
    public boolean debug = false;

    public VarnodeContext(Program program, ProgramContext programContext, ProgramContext spaceProgramContext) {
        this.program = program;
        this.addrFactory = new OffsetAddressFactory(program.getLanguage().getAddressFactory());
        this.BAD_ADDRESS = this.addrFactory.getAddress(this.getAddressSpace("BAD_ADDRESS_SPACE"), 0L);
        this.programContext = programContext;
        this.offsetContext = new DisassemblerContextImpl(programContext);
        this.spaceContext = new DisassemblerContextImpl(spaceProgramContext);
        this.setupValidSymbolicStackNames(program);
        this.trans = new VarnodeTranslator(program);
        Language language = program.getLanguage();
        if (language instanceof SleighLanguage) {
            this.keepTempUniqueValues = ((SleighLanguage)language).numSections() != 0;
        }
    }

    public void setDebug(boolean debugOn) {
        this.debug = debugOn;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setCurrentInstruction(Instruction instr) {
        this.currentInstruction = instr;
    }

    public Instruction getCurrentInstruction(Address addr) {
        if (this.currentInstruction != null) {
            return this.currentInstruction;
        }
        this.currentInstruction = this.program.getListing().getInstructionContaining(addr);
        return this.currentInstruction;
    }

    public Register getBaseContextRegister() {
        return null;
    }

    public void flowEnd(Address address) {
        this.offsetContext.flowEnd(address);
        this.spaceContext.flowEnd(address);
        this.currentAddress = null;
    }

    public void flowToAddress(Address fromAddr, Address toAddr) {
        this.currentAddress = toAddr = fromAddr.getAddressSpace().getOverlayAddress(toAddr);
        this.offsetContext.flowToAddress(fromAddr, toAddr);
        this.spaceContext.flowToAddress(fromAddr, toAddr);
    }

    public Address[] getKnownFlowToAddresses(Address toAddr) {
        return this.offsetContext.getKnownFlowToAddresses(toAddr);
    }

    public void flowStart(Address fromAddr, Address toAddr) {
        this.currentAddress = toAddr = fromAddr.getAddressSpace().getOverlayAddress(toAddr);
        this.lastSet = new HashMap();
        this.offsetContext.flowStart(fromAddr, toAddr);
        this.spaceContext.flowStart(fromAddr, toAddr);
    }

    public void copyToFutureFlowState(Address fromAddr, Address toAddr) {
        toAddr = fromAddr.getAddressSpace().getOverlayAddress(toAddr);
        this.offsetContext.copyToFutureFlowState(fromAddr, toAddr);
        this.spaceContext.copyToFutureFlowState(fromAddr, toAddr);
    }

    public boolean mergeToFutureFlowState(Address fromAddr, Address toAddr) {
        if (toAddr == null) {
            return false;
        }
        toAddr = fromAddr.getAddressSpace().getOverlayAddress(toAddr);
        ArrayList conflicts = this.offsetContext.mergeToFutureFlowState(fromAddr, toAddr);
        ArrayList spaceConflicts = this.spaceContext.mergeToFutureFlowState(fromAddr, toAddr);
        conflicts.addAll(spaceConflicts);
        if (conflicts.size() == 0) {
            return false;
        }
        boolean isWorthContinueing = false;
        for (RegisterValue registerValue : spaceConflicts) {
            if (!registerValue.hasValue()) continue;
            registerValue.getUnsignedValue();
            if (!BigInteger.ZERO.equals(registerValue.getUnsignedValue())) continue;
            isWorthContinueing = true;
        }
        return isWorthContinueing;
    }

    public void setFutureRegisterValue(Address address, RegisterValue regVal) {
        this.offsetContext.setFutureRegisterValue(address, regVal);
    }

    public Varnode[] getReturnVarnode(Function targetFunc) {
        PrototypeModel defaultCallingConvention = this.program.getCompilerSpec().getDefaultCallingConvention();
        if (targetFunc != null) {
            int pointerSize;
            DataType undefinedDataType;
            VariableStorage retStorage;
            Varnode[] varnodes = null;
            if (targetFunc.hasCustomVariableStorage()) {
                Parameter retStorage2 = targetFunc.getReturn();
                varnodes = retStorage2.getVariableStorage().getVarnodes();
                return varnodes;
            }
            PrototypeModel callingConvention = targetFunc.getCallingConvention();
            if (callingConvention != null && callingConvention != defaultCallingConvention && (retStorage = callingConvention.getReturnLocation(undefinedDataType = Undefined.getUndefinedDataType((int)(pointerSize = this.program.getDefaultPointerSize())), this.program)) != null && retStorage.isValid()) {
                return retStorage.getVarnodes();
            }
        }
        if (this.retVarnodes != null) {
            return this.retVarnodes;
        }
        DataType undefDT = Undefined.getUndefinedDataType((int)this.program.getDefaultPointerSize());
        VariableStorage retStore = defaultCallingConvention.getReturnLocation(undefDT, this.program);
        this.retVarnodes = retStore != null && retStore.isValid() ? retStore.getVarnodes() : new Varnode[0];
        return this.retVarnodes;
    }

    public Varnode getStackVarnode() {
        if (this.stackVarnode != null) {
            return this.stackVarnode;
        }
        Register stackRegister = this.getStackRegister();
        if (stackRegister == null) {
            return null;
        }
        this.stackVarnode = this.trans.getVarnode(stackRegister);
        return this.stackVarnode;
    }

    private void setupValidSymbolicStackNames(Program program) {
        Register stackRegister = this.getStackRegister();
        this.validSymbolicStackNames.add(stackRegister.getName());
        List childRegisters = stackRegister.getChildRegisters();
        for (Register register : childRegisters) {
            this.validSymbolicStackNames.add(register.getName());
        }
    }

    public boolean isStackSymbolicSpace(Varnode varnode) {
        AddressSpace regSpace = this.addrFactory.getAddressSpace(varnode.getSpace());
        return this.validSymbolicStackNames.contains(regSpace.getName());
    }

    public Register getStackRegister() {
        if (this.stackReg != null) {
            return this.stackReg;
        }
        this.stackReg = this.program.getCompilerSpec().getStackPointer();
        if (this.stackReg == null) {
            return null;
        }
        Register stackBaseReg = this.stackReg.getParentRegister();
        if (stackBaseReg != null && stackBaseReg.getChildRegisters().size() == 1) {
            this.stackReg = stackBaseReg;
        }
        return this.stackReg;
    }

    public Varnode getValue(Varnode varnode, ContextEvaluator evaluator) throws NotFoundException {
        return this.getValue(varnode, false, evaluator);
    }

    public Varnode getValue(Varnode varnode, boolean signed, ContextEvaluator evaluator) throws NotFoundException {
        Instruction instr;
        Long lval;
        if (varnode.isConstant()) {
            return varnode;
        }
        Varnode rvnode = null;
        rvnode = varnode.isUnique() ? this.tempUniqueVals.get(varnode) : this.tempVals.get(varnode);
        if (rvnode != null) {
            if (this.debug) {
                Msg.info((Object)this, (Object)("     Tmp " + varnode + "  =  " + rvnode));
            }
            if (rvnode.getAddress().equals((Object)this.BAD_ADDRESS)) {
                throw notFoundExc;
            }
            return rvnode;
        }
        if (this.isRegister(varnode)) {
            BigInteger bigVal;
            Register reg = this.trans.getRegister(varnode);
            if (reg != null && (bigVal = this.offsetContext.getValue(reg, signed)) != null) {
                BigInteger spaceVal = this.getTranslatedSpaceValue(reg);
                rvnode = this.createVarnode(bigVal, spaceVal, varnode.getSize());
                if (rvnode == null) {
                    throw notFoundExc;
                }
                if (!rvnode.getAddress().equals((Object)this.BAD_ADDRESS) && this.debug) {
                    Msg.info((Object)this, (Object)("  " + reg.getName() + " = " + this.print(rvnode)));
                }
                return rvnode;
            }
            return varnode;
        }
        boolean isAddr = varnode.isAddress();
        boolean isSymbolicAddr = this.isSymbolicSpace(varnode.getSpace());
        if (isAddr || isSymbolicAddr) {
            long diff;
            long varnodeOffset = varnode.getOffset();
            if (isAddr && (varnodeOffset == 0L || varnodeOffset == -1L || varnodeOffset == -1L)) {
                throw notFoundExc;
            }
            Varnode lvalue = this.memoryVals.get(varnode);
            if (lvalue != null) {
                if (this.debug) {
                    Msg.info((Object)this, (Object)("   " + varnode + " = " + this.print(lvalue)));
                }
                if (this.isSymbolicSpace(lvalue.getSpace())) {
                    if (this.debug) {
                        Msg.info((Object)this, (Object)("     out   " + varnode + " = " + this.print(lvalue)));
                    }
                    throw notFoundExc;
                }
                if (isSymbolicAddr) {
                    AddressSpace regSpace = this.addrFactory.getAddressSpace(varnode.getSpace());
                    Register stackRegister = this.getStackRegister();
                    if (!this.isStackSymbolicSpace(varnode)) {
                        if (this.debug) {
                            Msg.info((Object)this, (Object)("Don't Trust value from  " + varnode + " = " + this.print(lvalue)));
                        }
                        throw notFoundExc;
                    }
                    if (lvalue.isConstant() && lvalue.getOffset() == 0L) {
                        throw notFoundExc;
                    }
                }
                return lvalue;
            }
            Address addr = varnode.getAddress();
            if (this.spaceContext.getAddress().getAddressSpace().isOverlaySpace()) {
                addr = this.spaceContext.getAddress().getAddressSpace().getOverlayAddress(addr);
            }
            if (isSymbolicAddr) {
                throw notFoundExc;
            }
            if (this.program.getListing().getInstructionContaining(addr) != null) {
                this.hitDest = true;
                throw notFoundExc;
            }
            Reference[] refsFrom = this.program.getReferenceManager().getReferencesFrom(addr);
            if (refsFrom.length > 0 && refsFrom[0].isExternalReference()) {
                return varnode;
            }
            if (!(this.isReadOnly(addr) || !addr.getAddressSpace().equals(this.spaceContext.getAddress().getAddressSpace()) || (diff = addr.subtract(this.spaceContext.getAddress())) >= 0L && diff <= 4096L || evaluator == null || evaluator.allowAccess(this, addr))) {
                throw notFoundExc;
            }
            int size = varnode.getSize();
            try {
                long value = 0L;
                switch (size) {
                    case 1: {
                        value = this.program.getMemory().getByte(addr) & 0xFF;
                        break;
                    }
                    case 2: {
                        value = this.program.getMemory().getShort(addr) & 0xFFFF;
                        break;
                    }
                    case 4: {
                        value = this.program.getMemory().getInt(addr) & 0xFFFFFFFF;
                        break;
                    }
                    case 8: {
                        value = this.program.getMemory().getLong(addr);
                        break;
                    }
                    default: {
                        throw notFoundExc;
                    }
                }
                if (value == 0L) {
                    throw notFoundExc;
                }
                if (signed) {
                    value = value << 8 * (8 - size) >> 8 * (8 - size);
                }
                return this.createConstantVarnode(value, size);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        if (evaluator != null && !varnode.isAddress() && (lval = evaluator.unknownValue(this, instr = this.getCurrentInstruction(this.offsetContext.getAddress()), varnode)) == null && !varnode.isUnique()) {
            return varnode;
        }
        throw notFoundExc;
    }

    private BigInteger getTranslatedSpaceValue(Register reg) {
        BigInteger spaceVal = this.spaceContext.getValue(reg, true);
        if (spaceVal != null) {
            spaceVal = spaceVal.not();
        }
        if (spaceVal != null && BigInteger.ZERO.equals(spaceVal)) {
            return null;
        }
        return spaceVal;
    }

    private BigInteger getTranslatedSpaceValue(Register reg, Address fromAddr, Address toAddr) {
        BigInteger spaceVal = this.spaceContext.getValue(reg, fromAddr, toAddr, true);
        if (spaceVal != null) {
            spaceVal = spaceVal.not();
        }
        if (spaceVal != null && BigInteger.ZERO.equals(spaceVal)) {
            return null;
        }
        return spaceVal;
    }

    protected boolean isReadOnly(Address addr) {
        boolean readonly = false;
        MemoryBlock block = this.program.getMemory().getBlock(addr);
        if (block != null) {
            boolean bl = readonly = !block.isWrite();
            if (readonly) {
                ReferenceIterator refIter = this.program.getReferenceManager().getReferencesTo(addr);
                for (int count = 0; refIter.hasNext() && count < 100; ++count) {
                    Reference ref = refIter.next();
                    if (!ref.getReferenceType().isWrite()) continue;
                    readonly = false;
                    break;
                }
            }
        }
        return readonly;
    }

    public Varnode createVarnode(long value, int spaceID, int size) {
        if (spaceID == 0) {
            return this.createConstantVarnode(value, size);
        }
        AddressSpace spc = this.addrFactory.getAddressSpace(spaceID);
        Address addr = null;
        addr = spaceID == 65535 || spc == null || spc.equals(this.BAD_ADDRESS.getAddressSpace()) ? this.BAD_ADDRESS : spc.getTruncatedAddress(value, true);
        return new Varnode(addr, size);
    }

    public Varnode createConstantVarnode(long value, int size) {
        AddressSpace spc = this.addrFactory.getConstantSpace();
        Address addr = spc.getAddress(value);
        return new Varnode(addr, size);
    }

    public Varnode createBadVarnode() {
        return new Varnode(this.BAD_ADDRESS, 0);
    }

    public Varnode createVarnode(BigInteger bigVal, BigInteger spaceVal, int size) {
        if (size > 8) {
            return null;
        }
        if (spaceVal == null) {
            return this.createConstantVarnode(bigVal.longValue(), size);
        }
        long spaceID = spaceVal.longValue();
        int intSpaceID = (int)spaceID;
        if ((long)intSpaceID != spaceID) {
            return null;
        }
        return this.createVarnode(bigVal.longValue(), spaceVal.intValue(), size);
    }

    public void putValue(Varnode out, Varnode result, boolean mustClear) {
        if (out == null) {
            return;
        }
        if ((out.isAddress() || this.isSymbolicSpace(out.getSpace())) && !this.isRegister(out)) {
            if (this.debug) {
                Msg.info((Object)this, (Object)("      " + this.print(out) + " <- " + this.print(result) + " at " + this.offsetContext.getAddress()));
            }
            Address location = this.offsetContext.getAddress();
            this.addSetVarnodeToLastSetLocations(out, location);
            this.memoryVals.put(out, result);
            return;
        }
        if (result != null && result.isUnique()) {
            result = null;
        }
        if (out.isUnique()) {
            this.tempUniqueVals.put(out, result);
        } else {
            this.tempVals.put(out, result);
        }
        if (this.debug) {
            Msg.info((Object)this, (Object)("      " + this.print(out) + " <- " + this.print(result) + " at " + this.offsetContext.getAddress()));
        }
        if (mustClear) {
            this.clearVals.add(out);
        }
    }

    public boolean readExecutableCode() {
        return this.hitDest;
    }

    public void setReadExecutableCode() {
        this.hitDest = true;
    }

    public void clearReadExecutableCode() {
        this.hitDest = false;
    }

    public void propogateResults(boolean clearContext) {
        for (Map.Entry<Varnode, Varnode> element : this.tempVals.entrySet()) {
            Register reg;
            Varnode node = element.getKey();
            if (!this.isRegister(node) || (reg = this.trans.getRegister(node)) == null) continue;
            Varnode val = element.getValue();
            if (this.clearVals.contains(node)) {
                val = null;
            }
            if (val != null) {
                this.propogateValue(reg, node, val, this.offsetContext.getAddress());
                continue;
            }
            if (this.debug) {
                Msg.info((Object)this, (Object)("      " + reg.getName() + "<- Clear"));
            }
            this.clearRegister(reg);
        }
        if (clearContext) {
            if (!this.keepTempUniqueValues) {
                this.tempUniqueVals = new HashMap();
            }
            this.tempVals = new HashMap();
            this.clearVals = new HashSet();
        }
    }

    public void propogateValue(Register reg, Varnode node, Varnode val, Address address) {
        if (this.debug) {
            Msg.info((Object)this, (Object)("   " + reg.getName() + "<-" + val.toString() + " at " + this.offsetContext.getAddress()));
        }
        this.addSetVarnodeToLastSetLocations(node, address);
        this.offsetContext.setValue(reg, BigInteger.valueOf(val.getOffset()));
        List childRegisters = reg.getChildRegisters();
        for (Register register : childRegisters) {
            if (register.getMinimumByteSize() < this.program.getDefaultPointerSize()) continue;
            node = this.getRegisterVarnode(register);
            this.addSetVarnodeToLastSetLocations(node, address);
        }
        BigInteger bigSpaceID = BigInteger.ZERO;
        if (!val.isConstant()) {
            int spaceID = val.getSpace();
            bigSpaceID = BigInteger.valueOf(spaceID);
        }
        bigSpaceID = bigSpaceID.not();
        this.spaceContext.setValue(reg, bigSpaceID);
    }

    private void addSetVarnodeToLastSetLocations(Varnode node, Address address) {
        this.lastSet.put(node, address);
        AddressSet addressSet = this.allLastSet.get(node);
        if (addressSet == null) {
            addressSet = new AddressSet();
            this.allLastSet.put(node, addressSet);
        }
        addressSet.add(address);
    }

    public Address getLastSetLocation(Register reg, BigInteger bval) {
        Varnode rvar = this.trans.getVarnode(reg);
        Address lastSetAddr = this.lastSet.get(rvar);
        if (lastSetAddr != null) {
            return lastSetAddr;
        }
        AddressSet addressSet = this.allLastSet.get(rvar);
        if (addressSet == null) {
            return lastSetAddr;
        }
        AddressIterator addresses = addressSet.getAddresses(true);
        while (addresses.hasNext()) {
            BigInteger rbval;
            Address address = addresses.next();
            RegisterValue rval = this.getRegisterValue(reg, Address.NO_ADDRESS, address);
            if (rval == null || !bval.equals(rbval = rval.getUnsignedValue())) continue;
            lastSetAddr = address;
            break;
        }
        return lastSetAddr;
    }

    public Address getLastSetLocation(Varnode rvar, BigInteger bval) {
        Address lastSetAddr = this.lastSet.get(rvar);
        if (lastSetAddr != null) {
            return lastSetAddr;
        }
        return lastSetAddr;
    }

    public Varnode getVarnode(int spaceID, long offset, int size) {
        AddressSpace space = this.addrFactory.getAddressSpace(spaceID);
        if (space == null) {
            return new Varnode(null, size);
        }
        Address target = space.getTruncatedAddress(offset, true);
        Varnode vt = new Varnode(target, size);
        return vt;
    }

    public long getConstant(Varnode vnode, ContextEvaluator evaluator) throws NotFoundException {
        if (!vnode.isConstant()) {
            if (evaluator == null) {
                throw notFoundExc;
            }
            Instruction instr = this.getCurrentInstruction(this.offsetContext.getAddress());
            Long lval = evaluator.unknownValue(this, instr, vnode);
            if (lval != null) {
                return lval;
            }
            throw notFoundExc;
        }
        return vnode.getOffset();
    }

    public Varnode getVarnode(Varnode space, Varnode offset, int size, ContextEvaluator evaluator) throws NotFoundException {
        int spaceID = offset.getSpace();
        long valbase = 0L;
        if (this.isRegister(offset)) {
            Register reg = this.trans.getRegister(offset);
            if (reg == null) {
                throw notFoundExc;
            }
            spaceID = this.getAddressSpace(reg.getName());
            valbase = 0L;
        } else if (offset.isConstant()) {
            valbase = offset.getOffset();
            spaceID = (int)space.getOffset();
        } else if (OffsetAddressFactory.isSymbolSpace(spaceID)) {
            if (evaluator == null) {
                throw notFoundExc;
            }
            Instruction instr = this.getCurrentInstruction(this.offsetContext.getAddress());
            Long lval = evaluator.unknownValue(this, instr, offset);
            valbase = offset.getOffset();
            if (lval != null) {
                spaceID = (int)space.getOffset();
                valbase += lval.longValue();
            }
        } else {
            throw notFoundExc;
        }
        return this.getVarnode(spaceID, valbase, size);
    }

    public Varnode getRegisterVarnodeValue(Register reg, Address fromAddr, Address toAddr, boolean signed) {
        Varnode rvnode = null;
        if (reg == null) {
            return null;
        }
        BigInteger bigVal = this.offsetContext.getValue(reg, fromAddr, toAddr, signed);
        if (bigVal == null) {
            return null;
        }
        BigInteger spaceVal = this.getTranslatedSpaceValue(reg, fromAddr, toAddr);
        rvnode = this.createVarnode(bigVal, spaceVal, reg.getMinimumByteSize());
        if (rvnode == null) {
            return null;
        }
        if (!rvnode.getAddress().equals((Object)this.BAD_ADDRESS)) {
            if (this.debug) {
                Msg.info((Object)this, (Object)("     " + reg.getName() + " = " + this.print(rvnode)));
            }
            return rvnode;
        }
        return null;
    }

    protected String print(Varnode rvnode) {
        if (rvnode == null) {
            return "<null>";
        }
        if (rvnode.isRegister()) {
            Register reg = this.trans.getRegister(rvnode);
            return reg == null ? "<bad reg " + rvnode.getOffset() + ">" : reg.getName();
        }
        return rvnode.toString();
    }

    public RegisterValue getRegisterValue(Register reg, Address toAddr) {
        return this.getRegisterValue(reg, Address.NO_ADDRESS, toAddr);
    }

    public RegisterValue getRegisterValue(Register reg, Address fromAddr, Address toAddr) {
        RegisterValue regVal = this.offsetContext.getRegisterValue(reg, fromAddr, toAddr);
        if (regVal == null) {
            return null;
        }
        BigInteger spaceVal = this.getTranslatedSpaceValue(reg, fromAddr, toAddr);
        if (spaceVal != null && this.addrFactory.getConstantSpace().getBaseSpaceID() != spaceVal.intValue()) {
            return null;
        }
        return regVal;
    }

    public AddressRangeIterator getRegisterValueAddressRanges(Register reg) {
        return this.programContext.getRegisterValueAddressRanges(reg);
    }

    public boolean hasValueOverRange(Register reg, BigInteger bval, AddressSet set) {
        return this.programContext.hasValueOverRange(reg, bval, (AddressSetView)set);
    }

    public void copy(Varnode out, Varnode in, boolean mustClearAll, ContextEvaluator evaluator) throws NotFoundException {
        Varnode val1 = null;
        if (!in.isRegister() || !out.isRegister()) {
            val1 = this.getValue(in, evaluator);
            this.putValue(out, val1, mustClearAll);
            return;
        }
        if (mustClearAll) {
            this.clearVals.add(out);
        }
        val1 = this.getValue(in, evaluator);
        this.putValue(out, val1, mustClearAll);
    }

    public Varnode add(Varnode val1, Varnode val2, ContextEvaluator evaluator) throws NotFoundException {
        if (val1.isConstant() || val1.isAddress()) {
            Varnode swap = val1;
            val1 = val2;
            val2 = swap;
        }
        int spaceID = val1.getSpace();
        long valbase = 0L;
        if (!this.isRegister(val1) || !val1.equals((Object)val2)) {
            Instruction instr;
            if (this.isRegister(val1)) {
                Long uval;
                Register reg = this.trans.getRegister(val1);
                if (reg == null) {
                    throw notFoundExc;
                }
                spaceID = this.getAddressSpace(reg.getName());
                valbase = 0L;
                Instruction instr2 = this.getCurrentInstruction(this.offsetContext.getAddress());
                if (evaluator != null && (uval = evaluator.unknownValue(this, instr2, val1)) != null) {
                    valbase = uval;
                    spaceID = val2.getSpace();
                }
            } else if (val1.getAddress() == this.BAD_ADDRESS) {
                Long uval;
                spaceID = this.getAddressSpace("(bad address)");
                valbase = 0L;
                instr = this.getCurrentInstruction(this.offsetContext.getAddress());
                if (evaluator != null && (uval = evaluator.unknownValue(this, instr, val1)) != null) {
                    valbase = uval;
                    spaceID = val2.getSpace();
                }
            } else if (val1.isConstant()) {
                valbase = val1.getOffset();
            } else if (this.isSymbolicSpace(spaceID)) {
                Long uval;
                instr = this.getCurrentInstruction(this.offsetContext.getAddress());
                valbase = val1.getOffset();
                if (evaluator != null && (uval = evaluator.unknownValue(this, instr, val1)) != null) {
                    Register reg2;
                    String spaceName;
                    if (val2.isRegister() && ((spaceName = this.addrFactory.getAddressSpace(spaceID).getName()).equals((reg2 = this.trans.getRegister(val2)).getName()) || spaceName.startsWith(reg2.getName() + "-"))) {
                        return this.createConstantVarnode(valbase += uval * 2L, val1.getSize());
                    }
                    valbase = uval;
                    return this.add(this.createConstantVarnode(valbase, val1.getSize()), val2, evaluator);
                }
            } else {
                throw notFoundExc;
            }
        }
        long result = valbase + this.getConstant(val2, null) & -1L >>> (8 - val1.getSize()) * 8;
        return this.createVarnode(result, spaceID, val1.getSize());
    }

    protected boolean isRegister(Varnode varnode) {
        return varnode.isRegister() || this.trans.getRegister(varnode) != null;
    }

    public Varnode and(Varnode val1, Varnode val2, ContextEvaluator evaluator) throws NotFoundException {
        if (val1.isConstant() || val1.isAddress()) {
            Varnode swap = val1;
            val1 = val2;
            val2 = swap;
        }
        int spaceID = val1.getSpace();
        long valbase = 0L;
        if (this.isRegister(val1) && val1.equals((Object)val2)) {
            return val1;
        }
        if (this.isRegister(val1)) {
            Register reg = this.trans.getRegister(val1);
            if (reg == null) {
                throw notFoundExc;
            }
            spaceID = this.getAddressSpace(reg.getName());
            valbase = 0L;
        } else if (val1.isConstant()) {
            valbase = val1.getOffset();
        } else if (this.isSymbolicSpace(spaceID)) {
            long val2Const;
            valbase = val1.getOffset();
            if (val2.isConstant() && (val2Const = this.getConstant(val2, null)) >> 1 << 1 != val2Const && val2Const >> 2 << 2 != val2Const) {
                throw notFoundExc;
            }
        } else {
            throw notFoundExc;
        }
        long result = valbase & this.getConstant(val2, null) & -1L >>> (8 - val1.getSize()) * 8;
        return this.createVarnode(result, spaceID, val1.getSize());
    }

    public Varnode left(Varnode val1, Varnode val2, ContextEvaluator evaluator) throws NotFoundException {
        long lresult = this.getConstant(val1, evaluator) << (int)this.getConstant(val2, evaluator);
        Varnode result = this.createConstantVarnode(lresult &= -1L >>> (8 - val1.getSize()) * 8, val1.getSize());
        return result;
    }

    public int getAddressSpace(String name) {
        AddressSpace regSpace = this.addrFactory.getAddressSpace(name);
        if (regSpace == null) {
            regSpace = ((OffsetAddressFactory)this.addrFactory).createNewOffsetSpace(name);
        }
        int spaceID = regSpace.getBaseSpaceID();
        return spaceID;
    }

    public Varnode subtract(Varnode val1, Varnode val2, ContextEvaluator evaluator) throws NotFoundException {
        if (val1.equals((Object)val2)) {
            return this.createVarnode(0L, this.addrFactory.getConstantSpace().getBaseSpaceID(), val1.getSize());
        }
        int spaceID = val1.getSpace();
        long valbase = 0L;
        if (val1.isConstant()) {
            valbase = val1.getOffset();
        } else if (this.isRegister(val1)) {
            Register reg = this.trans.getRegister(val1);
            if (reg == null) {
                throw notFoundExc;
            }
            spaceID = this.getAddressSpace(reg.getName());
            valbase = 0L;
        } else if (this.isSymbolicSpace(spaceID)) {
            Long uval;
            Instruction instr = this.getCurrentInstruction(this.offsetContext.getAddress());
            valbase = val1.getOffset();
            if (evaluator != null && (uval = evaluator.unknownValue(this, instr, val1)) != null) {
                valbase = uval;
                return this.add(this.createConstantVarnode(valbase, val1.getSize()), val2, evaluator);
            }
        } else {
            throw notFoundExc;
        }
        long result = valbase - this.getConstant(val2, null) & -1L >>> (8 - val1.getSize()) * 8;
        return this.createVarnode(result, spaceID, val1.getSize());
    }

    public Varnode extendValue(Varnode out, Varnode[] in, boolean signExtend, ContextEvaluator evaluator) throws NotFoundException {
        Varnode vnodeVal = this.getValue(in[0], signExtend, evaluator);
        if (vnodeVal.isConstant() && in[0].getSize() < out.getSize()) {
            if (vnodeVal.getSize() <= 8) {
                Scalar sVal = new Scalar(8 * vnodeVal.getSize(), vnodeVal.getOffset(), signExtend);
                vnodeVal = this.createConstantVarnode(sVal.getValue(), out.getSize());
            } else {
                vnodeVal = this.createConstantVarnode(vnodeVal.getOffset(), out.getSize());
            }
        } else if (vnodeVal.isRegister() && vnodeVal.getSize() < out.getSize()) {
            Register reg = this.getRegister(vnodeVal);
            if (reg == null) {
                throw notFoundExc;
            }
            int spaceID = this.getAddressSpace(reg.getName());
            vnodeVal = this.createVarnode(0L, spaceID, out.getSize());
        }
        return vnodeVal;
    }

    public void clearRegister(Register reg) {
        if (reg == null) {
            return;
        }
        String spaceName = reg.getName() + "-" + this.currentAddress;
        int spaceId = this.getAddressSpace(spaceName);
        this.offsetContext.setValue(reg, BigInteger.ZERO);
        BigInteger bigSpaceID = BigInteger.valueOf(spaceId).not();
        this.spaceContext.setValue(reg, bigSpaceID);
    }

    public Register getRegister(String name) {
        return this.offsetContext.getRegister(name);
    }

    public RegisterValue getRegisterValue(Register register) {
        Varnode regVnode = this.trans.getVarnode(register);
        try {
            Varnode value = this.getValue(regVnode, false, null);
            if (value.isConstant()) {
                return new RegisterValue(register, BigInteger.valueOf(value.getOffset()));
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public Varnode getRegisterVarnodeValue(Register register) {
        Varnode regVnode = this.trans.getVarnode(register);
        try {
            Varnode value = this.getValue(regVnode, false, null);
            return value;
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    public Varnode getRegisterVarnode(Register register) {
        return this.trans.getVarnode(register);
    }

    public Register getRegister(Varnode vnode) {
        return this.trans.getRegister(vnode);
    }

    public Register[] getRegisters() {
        return this.offsetContext.getRegisters();
    }

    public BigInteger getValue(Register register, boolean signed) {
        Varnode regVnode = this.trans.getVarnode(register);
        try {
            Varnode value = this.getValue(regVnode, signed, null);
            if (value.isConstant()) {
                return BigInteger.valueOf(value.getOffset());
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasValue(Register register) {
        return this.offsetContext.hasValue(register);
    }

    public void setRegisterValue(RegisterValue value) {
        this.setValue(value.getRegister(), value.getUnsignedValue());
    }

    public void setValue(Register register, BigInteger value) {
        Varnode regVnode = this.trans.getVarnode(register);
        this.putValue(regVnode, this.createConstantVarnode(value.longValue(), regVnode.getSize()), false);
        this.propogateResults(false);
    }

    public boolean isSymbol(Varnode node) {
        return this.isSymbolicSpace(node.getAddress().getAddressSpace());
    }

    public boolean isSymbolicSpace(AddressSpace space) {
        int spaceID = space.getUniqueSpaceID();
        return OffsetAddressFactory.isSymbolSpace(spaceID);
    }

    public boolean isSymbolicSpace(int spaceID) {
        return OffsetAddressFactory.isSymbolSpace(spaceID);
    }
}

