/*
 * Decompiled with CFR 0.152.
 */
package generic.cache;

import generic.cache.BasicFactory;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;

public class CachingPool<T> {
    private static final long TIMEOUT = 0L;
    private AtomicBoolean isDisposed = new AtomicBoolean(false);
    private BasicFactory<T> factory;
    private Deque<T> cache = new ArrayDeque<T>();
    private long disposeTimeout = 0L;
    private GTimerMonitor timerMonitor;
    private Runnable cleanupRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CachingPool cachingPool = CachingPool.this;
            synchronized (cachingPool) {
                for (Object t : CachingPool.this.cache) {
                    CachingPool.this.factory.dispose(t);
                }
            }
        }
    };

    public CachingPool(BasicFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        this.factory = factory;
    }

    public void setCleanupTimeout(long timeout) {
        this.disposeTimeout = timeout;
    }

    public synchronized T get() throws Exception {
        this.cancel();
        if (this.cache.isEmpty()) {
            return this.factory.create();
        }
        return this.cache.pop();
    }

    public synchronized void release(T t) {
        this.restart();
        if (this.isDisposed.get()) {
            this.factory.dispose(t);
            return;
        }
        this.cache.push(t);
    }

    public synchronized void dispose() {
        this.cancel();
        this.isDisposed.set(true);
        for (T t : this.cache) {
            this.factory.dispose(t);
        }
    }

    private void cancel() {
        if (this.timerMonitor != null) {
            this.timerMonitor.cancel();
        }
    }

    private void restart() {
        if (this.timerMonitor != null) {
            this.timerMonitor.cancel();
        }
        this.timerMonitor = GTimer.scheduleRunnable(this.disposeTimeout, this.cleanupRunnable);
    }
}

