/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.dialogs.InputDialogListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public abstract class RenameTask {
    protected String newName = null;
    protected String oldName;
    protected String errorMsg = null;
    protected PluginTool tool;

    public RenameTask(PluginTool tool, String old) {
        this.tool = tool;
        this.oldName = old;
    }

    public abstract String getTransactionName();

    public abstract boolean isValid(String var1);

    public abstract void commit() throws DuplicateNameException, InvalidInputException;

    public String getNewName() {
        return this.newName;
    }

    public boolean runDialog() {
        InputDialogListener listener = new InputDialogListener(){

            public boolean inputIsValid(InputDialog dialog) {
                String name = dialog.getValue();
                if (name == null || name.length() == 0) {
                    dialog.setStatusText("Cannot have empty name");
                    return false;
                }
                if (name.equals(RenameTask.this.oldName)) {
                    RenameTask.this.newName = name;
                    return true;
                }
                boolean res = RenameTask.this.isValid(name);
                if (!res) {
                    dialog.setStatusText(RenameTask.this.errorMsg);
                }
                return res;
            }
        };
        String label = "Rename " + this.oldName + ":";
        InputDialog renameVarDialog = new InputDialog(this.getTransactionName(), new String[]{label}, new String[]{this.oldName}, true, listener);
        this.tool.showDialog((DialogComponentProvider)renameVarDialog);
        if (renameVarDialog.isCanceled()) {
            return false;
        }
        return !this.newName.equals(this.oldName);
    }
}

