/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote.security;

import ch.ethz.ssh2.crypto.Base64;
import ch.ethz.ssh2.crypto.PEMDecoder;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ghidra.security.KeyStorePasswordProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SSHKeyManager {
    private static KeyStorePasswordProvider passwordProvider;

    private SSHKeyManager() {
    }

    public static synchronized void setProtectedKeyStorePasswordProvider(KeyStorePasswordProvider provider) {
        passwordProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSSHPrivateKey(File sshPrivateKeyFile) throws IOException {
        if (!sshPrivateKeyFile.isFile()) {
            throw new FileNotFoundException("SSH private key file not found: " + sshPrivateKeyFile);
        }
        FileInputStream keyIn = new FileInputStream(sshPrivateKeyFile);
        try {
            Object object = SSHKeyManager.getSSHPrivateKey(keyIn, sshPrivateKeyFile.getAbsolutePath());
            return object;
        }
        finally {
            try {
                ((InputStream)keyIn).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Object getSSHPrivateKey(InputStream sshPrivateKeyIn) throws IOException {
        return SSHKeyManager.getSSHPrivateKey(sshPrivateKeyIn, "Protected SSH Key");
    }

    private static Object getSSHPrivateKey(InputStream sshPrivateKeyIn, String srcName) throws IOException {
        String line;
        boolean isEncrypted = false;
        StringBuffer keyBuf = new StringBuffer();
        BufferedReader r = new BufferedReader(new InputStreamReader(sshPrivateKeyIn));
        while ((line = r.readLine()) != null) {
            if (line.startsWith("Proc-Type:")) {
                isEncrypted = line.indexOf("ENCRYPTED") > 0;
            }
            keyBuf.append(line);
            keyBuf.append('\n');
        }
        r.close();
        String password = null;
        if (isEncrypted) {
            char[] pwd = passwordProvider.getKeyStorePassword(srcName, false);
            if (pwd == null) {
                throw new IOException("Password required to open SSH private keystore");
            }
            password = new String(pwd);
        }
        return PEMDecoder.decode((char[])keyBuf.toString().toCharArray(), password);
    }

    public static Object getSSHPublicKey(File sshPublicKeyFile) throws IOException {
        String[] pieces;
        String line;
        BufferedReader r = new BufferedReader(new FileReader(sshPublicKeyFile));
        String keyLine = null;
        while ((line = r.readLine()) != null) {
            if (!line.startsWith("ssh-")) continue;
            keyLine = line;
            break;
        }
        r.close();
        if (keyLine != null && (pieces = keyLine.split(" ")).length >= 2) {
            byte[] pubkeyBytes = Base64.decode((char[])pieces[1].toCharArray());
            if ("ssh-rsa".equals(pieces[0])) {
                return RSASHA1Verify.decodeSSHRSAPublicKey((byte[])pubkeyBytes);
            }
            if ("ssh-dsa".equals(pieces[0])) {
                return DSASHA1Verify.decodeSSHDSAPublicKey((byte[])pubkeyBytes);
            }
        }
        throw new IOException("Invalid SSH public key file, valid ssh-rsa or ssh-dsa entry not found: " + sshPublicKeyFile);
    }
}

