/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DockingUtils;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.main.EditPluginPathDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

class BrowsePathPanel
extends JPanel {
    private boolean changed;
    private GhidraFileChooser fileChooser;
    private JTextField pathTextField;
    private EditPluginPathDialog dialog;
    private JButton browseButton;

    BrowsePathPanel(EditPluginPathDialog editDialog, ActionListener buttonListener, String fieldName) {
        this.setLayout(new BoxLayout(this, 1));
        this.dialog = editDialog;
        this.create(fieldName);
        this.addListeners(buttonListener);
    }

    private void create(String fieldName) {
        this.pathTextField = new JTextField();
        this.pathTextField.setName(fieldName);
        this.pathTextField.setEditable(false);
        this.pathTextField.setBackground(this.getBackground());
        this.browseButton = ButtonPanelFactory.createButton((int)2);
        this.browseButton.setToolTipText("Choose Directory");
        JPanel browsePathPanel = new JPanel(new BorderLayout(5, 5));
        browsePathPanel.add((Component)this.pathTextField, "Center");
        browsePathPanel.add((Component)this.browseButton, "East");
        this.add(browsePathPanel);
    }

    private void createFileChooser() {
        this.fileChooser = new GhidraFileChooser((Component)this.dialog.getComponent());
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setApproveButtonToolTipText("Choose Directory With Plugin JAR Files");
        this.fileChooser.setApproveButtonText("Choose JAR Directory");
    }

    private void addListeners(ActionListener listener) {
        this.browseButton.addActionListener(listener);
        this.pathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 27 || DockingUtils.isControlModifier((KeyEvent)e) && keyCode == 67) {
                    BrowsePathPanel.this.dialog.initJarDirectory();
                } else {
                    BrowsePathPanel.this.dialog.setApplyEnabled(true);
                }
            }
        });
    }

    String getPath() {
        return this.pathTextField.getText().trim();
    }

    boolean isChanged() {
        return this.changed;
    }

    @Override
    public boolean hasFocus() {
        return this.pathTextField.hasFocus();
    }

    @Override
    public void requestFocus() {
        this.pathTextField.requestFocus();
        this.pathTextField.selectAll();
    }

    void showFileChooser() {
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        this.dialog.setStatusMessage(" ");
        File pluginFile = this.fileChooser.getSelectedFile();
        if (pluginFile != null) {
            this.setPath(pluginFile);
        } else {
            this.pathTextField.requestFocus();
            this.pathTextField.selectAll();
        }
    }

    void setChanged(boolean changed) {
        this.changed = changed;
    }

    private boolean setPath(File path) {
        boolean pathOK = false;
        this.dialog.setStatusMessage(" ");
        if (!path.canRead()) {
            this.pathTextField.selectAll();
            this.dialog.setStatusMessage("Cannot read path: " + path.toString());
        } else {
            this.pathTextField.setText(path.getAbsolutePath());
            boolean bl = pathOK = this.pathTextField.getText().trim().length() > 0;
        }
        if (pathOK) {
            this.dialog.setStatusMessage("Press Apply or OK to set JAR directory.");
        }
        this.changed = this.changed || pathOK;
        this.dialog.enableApply();
        return pathOK;
    }

    void setText(String text) {
        this.pathTextField.setText(text);
    }
}

