/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import java.util.HashMap;
import java.util.Map;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.naming.MDFragmentName;
import mdemangler.object.MDMangObjectParser;

public class MDMangGenericize
extends MDMang {
    private StringBuilder genericizedString = new StringBuilder();
    private int uniqueCount = -1;
    private String nextUnique = this.nextUnique();
    private Map<String, String> uniqueFragments = new HashMap<String, String>();

    @Override
    public MDParsableItem demangle(boolean errorOnRemainingChars) throws MDException {
        if (this.mangled == null) {
            throw new MDException("MDMang: Mangled string is null.");
        }
        this.pushContext();
        this.item = MDMangObjectParser.parse(this);
        if (this.item != null) {
            this.item.parse();
        }
        this.numCharsRemaining = this.iter.getLength() - this.iter.getIndex();
        this.appendRemainder();
        this.popContext();
        return this.item;
    }

    @Override
    public char next() {
        return super.next();
    }

    @Override
    public char getAndIncrement() {
        char c = super.getAndIncrement();
        this.genericizedString.append(c);
        return c;
    }

    @Override
    public void increment() {
        char c = super.getAndIncrement();
        this.genericizedString.append(c);
    }

    @Override
    public void increment(int count) {
        while (count-- > 0) {
            char c = super.getAndIncrement();
            this.genericizedString.append(c);
        }
    }

    private String nextUnique() {
        ++this.uniqueCount;
        return "name" + this.uniqueCount;
    }

    private void createAndAppendGenericFragment(String fragment) {
        String uniqueFragment;
        if (fragment.isEmpty()) {
            return;
        }
        if (fragment.charAt(0) == 'A') {
            this.nextUnique = "A" + this.nextUnique;
        }
        if ((uniqueFragment = this.uniqueFragments.putIfAbsent(fragment, this.nextUnique)) == null) {
            uniqueFragment = this.nextUnique;
            this.nextUnique = this.nextUnique();
        }
        this.genericizedString.append(uniqueFragment);
    }

    private void appendRemainder() {
        if (this.iter.getIndex() < this.iter.getLength()) {
            this.genericizedString.append(this.iter.getString().substring(this.iter.getIndex()));
        }
    }

    public String getGenericSymbol() {
        return this.genericizedString.toString();
    }

    @Override
    public String parseFragmentName(MDFragmentName fn) throws MDException {
        String name = super.parseFragmentName(fn);
        this.createAndAppendGenericFragment(name);
        return name;
    }
}

