/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.iso9660.ISO9660BaseVolume;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ISO9660BootRecordVolumeDescriptor
extends ISO9660BaseVolume {
    private byte[] bootSystemIdentifier;
    private byte[] bootIdentifier;
    private byte[] bootSystemUse;

    public ISO9660BootRecordVolumeDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.bootSystemIdentifier = reader.readNextByteArray(32);
        this.bootIdentifier = reader.readNextByteArray(32);
        this.bootSystemUse = reader.readNextByteArray(1977);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = new StructureDataType("ISO9600BootRecord", 0);
        struc.add(BYTE, "Type", "Volume Descriptor Type");
        struc.add((DataType)new ArrayDataType(BYTE, super.getIdentifier().length, 1), "Identifier", "Identifier");
        struc.add(BYTE, "Version", "Volume Descriptor Version");
        struc.add((DataType)new ArrayDataType(BYTE, this.bootSystemIdentifier.length, 1), "Boot System Identifier", "ID of the system which can act on and boot the system");
        struc.add((DataType)new ArrayDataType(BYTE, this.bootIdentifier.length, 1), "Boot Identifier", "Identification of the boot system");
        struc.add((DataType)new ArrayDataType(BYTE, this.bootSystemUse.length, 1), "Boot System Use", "Custom - used by the boot system");
        return struc;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Type: 0x" + Integer.toHexString(super.getTypeCode()) + " => " + this.getTypeCodeString() + "\n");
        buff.append("Identifier: " + new String(super.getIdentifier()).trim() + "\n");
        buff.append("Version: 0x" + Integer.toHexString(super.getVersion()) + "\n");
        buff.append("Boot System Identifier: " + new String(this.bootSystemIdentifier).trim() + "\n");
        buff.append("Boot Identifier: " + new String(this.bootIdentifier).trim() + "\n");
        return buff.toString();
    }

    public byte[] getBootSystemIdentifier() {
        return this.bootSystemIdentifier;
    }

    public byte[] getBootIdentifier() {
        return this.bootIdentifier;
    }

    public byte[] getBootSystemUse() {
        return this.bootSystemUse;
    }
}

