/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionToGuiMapper;
import docking.ComponentPlaceholder;
import docking.DockingWindowListener;
import docking.DockingWindowManager;
import docking.RootNode;
import docking.WindowActionManager;
import docking.WindowNode;
import docking.action.DockingActionIf;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import ghidra.util.Swing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalMenuAndToolBarManager
implements DockingWindowListener {
    private Map<WindowNode, WindowActionManager> windowToActionManagerMap;
    private final MenuHandler menuHandler;
    private final MenuGroupMap menuGroupMap;
    private final DockingWindowManager windowManager;

    public GlobalMenuAndToolBarManager(DockingWindowManager windowManager, MenuHandler menuHandler, MenuGroupMap menuGroupMap) {
        this.windowManager = windowManager;
        this.menuHandler = menuHandler;
        this.menuGroupMap = menuGroupMap;
        RootNode rootNode = windowManager.getRootNode();
        rootNode.addDockingWindowListener(this);
        WindowActionManager mainWindowActionManager = new WindowActionManager(rootNode, menuHandler, windowManager, menuGroupMap);
        this.windowToActionManagerMap = new HashMap<WindowNode, WindowActionManager>();
        this.windowToActionManagerMap.put(rootNode, mainWindowActionManager);
    }

    public void addAction(DockingActionIf action) {
        for (WindowNode node : this.windowToActionManagerMap.keySet()) {
            Set<Class<?>> contextTypes;
            if (!action.shouldAddToWindow(node instanceof RootNode, contextTypes = node.getContextTypes())) continue;
            WindowActionManager windowActionManager = this.windowToActionManagerMap.get(node);
            windowActionManager.addAction(action);
        }
    }

    public void removeAction(DockingActionIf action) {
        for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
            actionManager.removeAction(action);
        }
    }

    public void update() {
        for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
            actionManager.update();
        }
    }

    public DockingActionIf getToolbarAction(String actionName) {
        for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
            DockingActionIf action = actionManager.getToolbarAction(actionName);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public void dispose() {
        for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
            actionManager.dispose();
        }
        this.windowToActionManagerMap.clear();
    }

    @Override
    public void dockingWindowAdded(WindowNode windowNode) {
    }

    @Override
    public void dockingWindowRemoved(WindowNode windowNode) {
        this.removeWindowActionManager(windowNode);
    }

    @Override
    public void dockingWindowChanged(WindowNode windowNode) {
        List<DockingActionIf> actionsForWindow = this.getActionsForWindow(windowNode);
        if (actionsForWindow.isEmpty()) {
            this.removeWindowActionManager(windowNode);
            return;
        }
        WindowActionManager actionManager = this.windowToActionManagerMap.get(windowNode);
        if (actionManager == null) {
            this.createWindowActionManager(windowNode, actionsForWindow);
        } else {
            actionManager.setActions(actionsForWindow);
        }
    }

    @Override
    public void dockingWindowFocusChanged(WindowNode windowNode) {
        ComponentPlaceholder lastFocused = windowNode.getLastFocusedProviderInWindow();
        WindowActionManager windowActionManager = this.windowToActionManagerMap.get(windowNode);
        if (windowActionManager == null) {
            return;
        }
        windowActionManager.contextChanged(lastFocused);
    }

    private void removeWindowActionManager(WindowNode windowNode) {
        WindowActionManager removedActionManager = this.windowToActionManagerMap.remove(windowNode);
        if (removedActionManager != null) {
            removedActionManager.dispose();
        }
    }

    private void createWindowActionManager(WindowNode windowNode, List<DockingActionIf> actionsForWindow) {
        WindowActionManager newActionManager = new WindowActionManager(windowNode, this.menuHandler, this.windowManager, this.menuGroupMap);
        this.windowToActionManagerMap.put(windowNode, newActionManager);
        newActionManager.setActions(actionsForWindow);
        ComponentPlaceholder lastFocused = windowNode.getLastFocusedProviderInWindow();
        newActionManager.contextChanged(lastFocused);
    }

    private List<DockingActionIf> getActionsForWindow(WindowNode windowNode) {
        ActionToGuiMapper actionManager = this.windowManager.getActionToGuiMapper();
        Set<DockingActionIf> globalActions = actionManager.getGlobalActions();
        ArrayList<DockingActionIf> actionsForWindow = new ArrayList<DockingActionIf>(globalActions.size());
        Set<Class<?>> contextTypes = windowNode.getContextTypes();
        for (DockingActionIf action : globalActions) {
            if (!action.shouldAddToWindow(windowNode instanceof RootNode, contextTypes)) continue;
            actionsForWindow.add(action);
        }
        return actionsForWindow;
    }

    public void contextChangedAll() {
        Swing.runIfSwingOrRunLater(this::updateAllWindowActions);
    }

    private void updateAllWindowActions() {
        for (WindowNode windowNode : this.windowToActionManagerMap.keySet()) {
            ComponentPlaceholder lastFocused = windowNode.getLastFocusedProviderInWindow();
            this.windowToActionManagerMap.get(windowNode).contextChanged(lastFocused);
        }
    }

    public void contextChanged(ComponentPlaceholder placeHolder) {
        if (placeHolder == null) {
            return;
        }
        WindowNode topLevelNode = placeHolder.getTopLevelNode();
        if (topLevelNode == null) {
            return;
        }
        if (topLevelNode.getLastFocusedProviderInWindow() != placeHolder) {
            return;
        }
        WindowActionManager windowActionManager = this.windowToActionManagerMap.get(topLevelNode);
        if (windowActionManager != null) {
            windowActionManager.contextChanged(placeHolder);
        }
    }
}

