/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentNode;
import docking.ComponentPlaceholder;
import docking.DockingWindowManager;
import docking.SplitNode;
import docking.WindowNode;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;

abstract class Node {
    Node parent;
    boolean invalid = true;
    DockingWindowManager winMgr;

    Node(DockingWindowManager winMgr) {
        this.winMgr = winMgr;
    }

    DockingWindowManager getDockingWindowManager() {
        return this.winMgr;
    }

    abstract List<Node> getChildren();

    abstract void close();

    abstract JComponent getComponent();

    abstract boolean contains(ComponentPlaceholder var1);

    abstract Element saveToXML();

    abstract void removeNode(Node var1);

    abstract void replaceNode(Node var1, Node var2);

    abstract WindowNode getTopLevelNode();

    abstract void populateActiveComponents(List<ComponentPlaceholder> var1);

    void invalidate() {
        this.invalid = true;
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    Node processChildElement(Element elem, DockingWindowManager mgr, Node parentNode, List<ComponentPlaceholder> restoredPlaceholders) {
        if (elem.getName().equals("SPLIT_NODE")) {
            return new SplitNode(elem, mgr, parentNode, restoredPlaceholders);
        }
        if (elem.getName().equals("COMPONENT_NODE")) {
            return new ComponentNode(elem, mgr, parentNode, restoredPlaceholders);
        }
        return null;
    }

    abstract String getDescription();

    String printTree() {
        StringBuilder buffy = new StringBuilder();
        this.printNodes(buffy, this.getTopLevelNode(), 0);
        return buffy.toString();
    }

    private String printNodes(StringBuilder buffy, Node node, int level) {
        String indent = this.indent(level * 3);
        String name = node.getDescription();
        if (this == node) {
            buffy.append(indent);
            buffy.append("***   ");
            buffy.append(name);
            buffy.append("   ***").append('\n');
        } else {
            buffy.append(indent).append(name).append('\n');
        }
        List<Node> children = node.getChildren();
        for (Node n : children) {
            this.printNodes(buffy, n, level + 1);
        }
        return buffy.toString();
    }

    private String indent(int n) {
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            buffy.append(' ');
        }
        return buffy.toString();
    }

    void dispose() {
    }
}

