/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.common.SolrException;
import org.apache.solr.update.VersionBucket;

public class TimedVersionBucket
extends VersionBucket {
    private final Lock lock = new ReentrantLock(true);
    private final Condition condition = this.lock.newCondition();

    @Override
    public <T, R> R runWithLock(int lockTimeoutMs, VersionBucket.CheckedFunction<T, R> function) throws IOException {
        if (this.tryLock(lockTimeoutMs)) {
            return function.apply();
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to get version bucket lock in " + lockTimeoutMs + " ms");
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void signalAll() {
        this.condition.signalAll();
    }

    @Override
    public void awaitNanos(long nanosTimeout) {
        try {
            if (nanosTimeout > 0L) {
                this.condition.awaitNanos(nanosTimeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected boolean tryLock(int lockTimeoutMs) {
        try {
            return this.lock.tryLock(lockTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

