/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextFieldInplaceEditorProvider
implements InplaceEditorProvider<JTextField> {
    private TextFieldInplaceEditor editor;
    private EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections;
    private KeyListener keyListener;
    private FocusListener focusListener;
    private DocumentListener documentListener;

    public TextFieldInplaceEditorProvider(TextFieldInplaceEditor textFieldInplaceEditor, EnumSet<InplaceEditorProvider.ExpansionDirection> enumSet) {
        this.editor = textFieldInplaceEditor;
        this.expansionDirections = enumSet;
    }

    @Override
    public JTextField createEditorComponent(InplaceEditorProvider.EditorController editorController, Widget widget) {
        if (!this.editor.isEnabled(widget)) {
            return null;
        }
        JTextField jTextField = new JTextField(this.editor.getText(widget));
        jTextField.selectAll();
        Scene scene = widget.getScene();
        double d = scene.getZoomFactor();
        if (d > 1.0) {
            Font font = scene.getDefaultFont();
            font = font.deriveFont((float)((double)font.getSize2D() * d));
            jTextField.setFont(font);
        }
        return jTextField;
    }

    @Override
    public void notifyOpened(final InplaceEditorProvider.EditorController editorController, Widget widget, JTextField jTextField) {
        jTextField.setMinimumSize(new Dimension(64, 19));
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyChar()) {
                    case '\u001b': {
                        keyEvent.consume();
                        editorController.closeEditor(false);
                        break;
                    }
                    case '\n': {
                        keyEvent.consume();
                        editorController.closeEditor(true);
                    }
                }
            }
        };
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                editorController.closeEditor(true);
            }
        };
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                editorController.notifyEditorComponentBoundsChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                editorController.notifyEditorComponentBoundsChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                editorController.notifyEditorComponentBoundsChanged();
            }
        };
        jTextField.addKeyListener(this.keyListener);
        jTextField.addFocusListener(this.focusListener);
        jTextField.getDocument().addDocumentListener(this.documentListener);
        jTextField.selectAll();
    }

    @Override
    public void notifyClosing(InplaceEditorProvider.EditorController editorController, Widget widget, JTextField jTextField, boolean bl) {
        jTextField.getDocument().removeDocumentListener(this.documentListener);
        jTextField.removeFocusListener(this.focusListener);
        jTextField.removeKeyListener(this.keyListener);
        if (bl) {
            this.editor.setText(widget, jTextField.getText());
            if (widget != null) {
                widget.getScene().validate();
            }
        }
    }

    @Override
    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController editorController, Widget widget, JTextField jTextField, Rectangle rectangle) {
        return null;
    }

    @Override
    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController editorController, Widget widget, JTextField jTextField) {
        return this.expansionDirections;
    }
}

