/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.crypto;

import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySetGenerator;
import de.rub.nds.tlsattacker.core.record.crypto.Decryptor;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordDecryptor
extends Decryptor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext context;
    private RecordNullCipher nullCipher;

    public RecordDecryptor(RecordCipher recordCipher, TlsContext context) {
        super(recordCipher);
        this.context = context;
        this.nullCipher = new RecordNullCipher(context);
    }

    @Override
    public void decrypt(BlobRecord record) {
        LOGGER.warn("We are not decrypting BlobRecords. Using NullCipher");
        try {
            this.nullCipher.decrypt(record);
        }
        catch (CryptoException ex1) {
            LOGGER.warn("Could not decrypt BlobRecord with NullCipher", (Throwable)ex1);
        }
    }

    @Override
    public void decrypt(Record record) {
        LOGGER.debug("Decrypting Record");
        RecordCipher recordCipher = this.context.getChooser().getSelectedProtocolVersion().isDTLS() ? this.getRecordCipher((Integer)record.getEpoch().getValue()) : this.getRecordMostRecentCipher();
        record.prepareComputations();
        record.setSequenceNumber(BigInteger.valueOf(this.context.getReadSequenceNumber()));
        try {
            recordCipher.decrypt(record);
        }
        catch (CryptoException | ParserException ex) {
            LOGGER.warn("Could not decrypt Record. Using NulLCipher instead", (Throwable)ex);
            try {
                this.nullCipher.decrypt(record);
            }
            catch (CryptoException ex1) {
                LOGGER.warn("Could not decrypt Record with null cipher", (Throwable)ex1);
            }
        }
        this.context.increaseReadSequenceNumber();
        if (this.context.getChooser().getConnectionEndType() == ConnectionEndType.SERVER && this.context.getActiveClientKeySetType() == Tls13KeySetType.EARLY_TRAFFIC_SECRETS) {
            this.checkForEndOfEarlyData((byte[])record.getComputations().getPlainRecordBytes().getValue());
        }
    }

    private void checkForEndOfEarlyData(byte[] unpaddedBytes) {
        byte[] endOfEarlyData = new byte[]{5, 0, 0, 0};
        if (Arrays.equals(unpaddedBytes, endOfEarlyData)) {
            this.adjustClientCipherAfterEarly();
        }
    }

    public void adjustClientCipherAfterEarly() {
        try {
            this.context.setActiveClientKeySetType(Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
            LOGGER.debug("Setting cipher for client to use handshake secrets");
            KeySet clientKeySet = KeySetGenerator.generateKeySet(this.context, this.context.getChooser().getSelectedProtocolVersion(), this.context.getActiveClientKeySetType());
            RecordCipher recordCipherClient = RecordCipherFactory.getRecordCipher(this.context, clientKeySet, this.context.getChooser().getSelectedCipherSuite());
            this.context.getRecordLayer().setRecordCipher(recordCipherClient);
            this.context.getRecordLayer().updateDecryptionCipher();
            this.context.setReadSequenceNumber(0L);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            LOGGER.error("Generating KeySet failed", (Throwable)ex);
            throw new WorkflowExecutionException(ex.toString());
        }
    }
}

