/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.model.User;
import org.traccar.notification.FullMessage;
import org.traccar.reports.ReportUtils;

public final class TextTemplateFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextTemplateFormatter.class);

    private TextTemplateFormatter() {
    }

    public static VelocityContext prepareContext(User user) {
        VelocityContext velocityContext = new VelocityContext();
        if (user != null) {
            velocityContext.put("user", (Object)user);
            velocityContext.put("timezone", (Object)ReportUtils.getTimezone(user.getId()));
        }
        velocityContext.put("webUrl", Context.getVelocityEngine().getProperty("web.url"));
        velocityContext.put("dateTool", (Object)new DateTool());
        velocityContext.put("numberTool", (Object)new NumberTool());
        velocityContext.put("locale", (Object)Locale.getDefault());
        return velocityContext;
    }

    public static Template getTemplate(String name, String path) {
        Template template;
        try {
            String templateFilePath = Paths.get(path, name + ".vm").toString();
            template = Context.getVelocityEngine().getTemplate(templateFilePath, StandardCharsets.UTF_8.name());
        }
        catch (ResourceNotFoundException error) {
            LOGGER.warn("Notification template error", (Throwable)error);
            String templateFilePath = Paths.get(path, "unknown.vm").toString();
            template = Context.getVelocityEngine().getTemplate(templateFilePath, StandardCharsets.UTF_8.name());
        }
        return template;
    }

    public static FullMessage formatFullMessage(VelocityContext velocityContext, String name) {
        String formattedMessage = TextTemplateFormatter.formatMessage(velocityContext, name, "full");
        return new FullMessage((String)velocityContext.get("subject"), formattedMessage);
    }

    public static String formatShortMessage(VelocityContext velocityContext, String name) {
        return TextTemplateFormatter.formatMessage(velocityContext, name, "short");
    }

    private static String formatMessage(VelocityContext velocityContext, String name, String templatePath) {
        StringWriter writer = new StringWriter();
        TextTemplateFormatter.getTemplate(name, templatePath).merge((org.apache.velocity.context.Context)velocityContext, (Writer)writer);
        return writer.toString();
    }
}

