/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.layout.FruchtermanReingoldForceLayout;
import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.olap.undo.OLAPUndoManager;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AutoLayoutAction;
import ca.sqlpower.architect.swingui.action.RedoAction;
import ca.sqlpower.architect.swingui.action.UndoAction;
import ca.sqlpower.architect.swingui.action.ZoomAction;
import ca.sqlpower.architect.swingui.action.ZoomResetAction;
import ca.sqlpower.architect.swingui.action.ZoomToFitAction;
import ca.sqlpower.architect.swingui.olap.OLAPPlayPenFactory;
import ca.sqlpower.architect.swingui.olap.OLAPTree;
import ca.sqlpower.architect.swingui.olap.OLAPTreeCellRenderer;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.architect.swingui.olap.action.CreateCalculatedMemberAction;
import ca.sqlpower.architect.swingui.olap.action.CreateCubeAction;
import ca.sqlpower.architect.swingui.olap.action.CreateCubeUsageAction;
import ca.sqlpower.architect.swingui.olap.action.CreateDimensionAction;
import ca.sqlpower.architect.swingui.olap.action.CreateDimensionUsageAction;
import ca.sqlpower.architect.swingui.olap.action.CreateHierarchyAction;
import ca.sqlpower.architect.swingui.olap.action.CreateLevelAction;
import ca.sqlpower.architect.swingui.olap.action.CreateMeasureAction;
import ca.sqlpower.architect.swingui.olap.action.CreateVirtualCubeAction;
import ca.sqlpower.architect.swingui.olap.action.ExportSchemaAction;
import ca.sqlpower.architect.swingui.olap.action.OLAPDeleteSelectedAction;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.swingui.event.SessionLifecycleEvent;
import ca.sqlpower.swingui.event.SessionLifecycleListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class OLAPEditSession
extends AbstractSPListener {
    private final OLAPTree tree;
    private final PlayPen pp;
    private JFrame frame;
    private final Preferences prefs = Preferences.userNodeForPackage(OLAPEditSession.class);
    private JScrollPane ppScrollPane;
    private final OLAPSession olapSession;
    private final OLAPUndoManager undoManager;
    public static final double ZOOM_STEP = 0.25;
    private ZoomAction zoomInAction;
    private ZoomAction zoomOutAction;
    private ZoomResetAction zoomNormalAction;
    private ZoomToFitAction zoomToFitAction;
    private CreateDimensionAction createDimensionAction;
    private CreateCubeAction createCubeAction;
    private CreateVirtualCubeAction createVirtualCubeAction;
    private CreateMeasureAction createMeasureAction;
    private CreateHierarchyAction createHierarchyAction;
    private CreateLevelAction createLevelAction;
    private CreateDimensionUsageAction createDimensionUsageAction;
    private CreateCubeUsageAction createCubeUsageAction;
    private CreateCalculatedMemberAction createCalculatedMemberAction;
    private ExportSchemaAction exportSchemaAction;
    private OLAPDeleteSelectedAction olapDeleteSelectedAction;
    private AutoLayoutAction autoLayoutAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private final ArchitectSwingSession swingSession;
    private static final Logger logger = Logger.getLogger(OLAPPlayPenFactory.class);

    public OLAPEditSession(ArchitectSwingSession swingSession, OLAPSession olapSession) {
        this.olapSession = olapSession;
        this.swingSession = swingSession;
        swingSession.getOLAPRootObject().addSPListener((SPListener)this);
        swingSession.getOLAPEditSessions().add(this);
        this.tree = new OLAPTree(swingSession, this, olapSession.getSchema());
        this.tree.setCellRenderer(new OLAPTreeCellRenderer());
        this.undoManager = new OLAPUndoManager(olapSession);
        this.undoManager.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (OLAPEditSession.this.frame != null) {
                    OLAPEditSession.this.frame.setTitle(OLAPEditSession.this.generateDialogTitle());
                }
            }
        });
        this.pp = OLAPPlayPenFactory.createPlayPen(swingSession, this, this.undoManager);
        swingSession.addSessionLifecycleListener(new SessionLifecycleListener<ArchitectSession>(){

            public void sessionClosing(SessionLifecycleEvent<ArchitectSession> e) {
                OLAPEditSession.this.close();
            }

            public void sessionOpening(SessionLifecycleEvent<ArchitectSession> e) {
            }
        });
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            this.initGUI();
        }
        return this.frame;
    }

    private void initGUI() {
        this.frame = new JFrame(this.generateDialogTitle());
        MondrianModel.Schema schema = this.olapSession.getSchema();
        this.zoomInAction = new ZoomAction(this.swingSession, this.pp, 0.25);
        this.zoomOutAction = new ZoomAction(this.swingSession, this.pp, -0.25);
        this.zoomNormalAction = new ZoomResetAction(this.swingSession, this.pp);
        this.zoomToFitAction = new ZoomToFitAction(this.swingSession, this.pp);
        this.zoomToFitAction.putValue("ShortDescription", Messages.getString("ArchitectFrame.zoomToFitActionDescription"));
        this.createDimensionAction = new CreateDimensionAction(this.swingSession, schema, this.pp);
        this.createCubeAction = new CreateCubeAction(this.swingSession, schema, this.pp);
        this.createVirtualCubeAction = new CreateVirtualCubeAction(this.swingSession, schema, this.pp);
        this.createMeasureAction = new CreateMeasureAction(this.swingSession, this.pp);
        this.createHierarchyAction = new CreateHierarchyAction(this.swingSession, this.pp);
        this.createLevelAction = new CreateLevelAction(this.swingSession, this.pp);
        this.createDimensionUsageAction = new CreateDimensionUsageAction(this.swingSession, this.pp);
        this.createCubeUsageAction = new CreateCubeUsageAction(this.swingSession, this.pp);
        this.createCalculatedMemberAction = new CreateCalculatedMemberAction(this.swingSession, this.pp);
        this.exportSchemaAction = new ExportSchemaAction(this.swingSession, schema);
        this.olapDeleteSelectedAction = new OLAPDeleteSelectedAction(this.swingSession, this);
        this.autoLayoutAction = new AutoLayoutAction(this.swingSession, this.pp, "Automatic Layout", "Automatic Layout", "auto_layout");
        this.autoLayoutAction.setLayout(new FruchtermanReingoldForceLayout());
        this.undoAction = new UndoAction(this.swingSession, this.undoManager);
        this.redoAction = new RedoAction(this.swingSession, this.undoManager);
        JToolBar toolbar = new JToolBar(1);
        toolbar.add(this.zoomInAction);
        toolbar.add(this.zoomOutAction);
        toolbar.add(this.zoomNormalAction);
        toolbar.add(this.zoomToFitAction);
        toolbar.addSeparator();
        toolbar.add(this.undoAction);
        toolbar.add(this.redoAction);
        toolbar.addSeparator();
        toolbar.add(this.autoLayoutAction);
        toolbar.addSeparator();
        toolbar.add(this.createDimensionAction);
        toolbar.add(this.createCubeAction);
        toolbar.add(this.createVirtualCubeAction);
        toolbar.add(this.createMeasureAction);
        toolbar.add(this.createHierarchyAction);
        toolbar.add(this.createLevelAction);
        toolbar.add(this.createDimensionUsageAction);
        toolbar.add(this.createCubeUsageAction);
        toolbar.add(this.createCalculatedMemberAction);
        toolbar.addSeparator();
        toolbar.add(this.exportSchemaAction);
        this.ppScrollPane = new JScrollPane(this.pp);
        JPanel panel = new JPanel(new BorderLayout());
        final JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.tree), this.ppScrollPane);
        splitPane.setDividerLocation(this.prefs.getInt(PrefKeys.DIVIDER_LOCATION.name(), 240));
        splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OLAPEditSession.this.prefs.putInt(PrefKeys.DIVIDER_LOCATION.name(), splitPane.getDividerLocation());
            }
        });
        panel.add((Component)splitPane, "Center");
        panel.add((Component)toolbar, "East");
        this.olapSession.getSchema().addSPListener((SPListener)new AbstractSPListener(){

            public void propertyChanged(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("name")) {
                    OLAPEditSession.this.frame.setTitle(OLAPEditSession.this.generateDialogTitle());
                }
            }
        });
        this.frame.setContentPane(panel);
        this.frame.pack();
        this.frame.setIconImage(OSUtils.SCHEMA_ICON.getImage());
        ArchitectSwingSessionContext context = this.swingSession.getContext();
        if (context.isMacOSX()) {
            this.frame.setJMenuBar(this.swingSession.getArchitectFrame().createNewMenuBar());
        }
        OLAPPlayPenFactory.setupOLAPKeyboardActions(this.pp, this);
        this.undoManager.rememberPosition();
    }

    public PlayPen getOlapPlayPen() {
        return this.pp;
    }

    public OLAPTree getOlapTree() {
        return this.tree;
    }

    public JScrollPane getPPScrollPane() {
        return this.ppScrollPane;
    }

    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public void saveNotify() {
        this.undoManager.rememberPosition();
    }

    public boolean isModified() {
        return !this.undoManager.isAtRememberedPosition();
    }

    private String generateDialogTitle() {
        StringBuilder title = new StringBuilder();
        if (!this.undoManager.isAtRememberedPosition() && !this.swingSession.isEnterpriseSession()) {
            title.append("*");
        }
        title.append(this.olapSession.getSchema().getName());
        title.append(" - OLAP Schema Editor");
        return title.toString();
    }

    public OLAPSession getOlapSession() {
        return this.olapSession;
    }

    public CreateDimensionAction getCreateDimensionAction() {
        return this.createDimensionAction;
    }

    public CreateCubeAction getCreateCubeAction() {
        return this.createCubeAction;
    }

    public CreateVirtualCubeAction getCreateVirtualCubeAction() {
        return this.createVirtualCubeAction;
    }

    public CreateMeasureAction getCreateMeasureAction() {
        return this.createMeasureAction;
    }

    public CreateHierarchyAction getCreateHierarchyAction() {
        return this.createHierarchyAction;
    }

    public CreateLevelAction getCreateLevelAction() {
        return this.createLevelAction;
    }

    public ExportSchemaAction getExportSchemaAction() {
        return this.exportSchemaAction;
    }

    public OLAPDeleteSelectedAction getOLAPDeleteSelectedAction() {
        return this.olapDeleteSelectedAction;
    }

    public AutoLayoutAction getAutoLayoutAction() {
        return this.autoLayoutAction;
    }

    public void childRemoved(SPChildEvent e) {
        if (e.getChild() == this.olapSession) {
            this.swingSession.getOLAPEditSessions().remove((Object)this);
            this.swingSession.getOLAPRootObject().removeSPListener((SPListener)this);
            this.frame.dispose();
        }
    }

    public ZoomAction getZoomInAction() {
        return this.zoomInAction;
    }

    public ZoomAction getZoomOutAction() {
        return this.zoomOutAction;
    }

    public ZoomResetAction getZoomNormalAction() {
        return this.zoomNormalAction;
    }

    public ZoomToFitAction getZoomToFitAction() {
        return this.zoomToFitAction;
    }

    public CreateDimensionUsageAction getCreateDimensionUsageAction() {
        return this.createDimensionUsageAction;
    }

    public CreateCubeUsageAction getCreateCubeUsageAction() {
        return this.createCubeUsageAction;
    }

    public CreateCalculatedMemberAction getCreateCalculatedMemberAction() {
        return this.createCalculatedMemberAction;
    }

    private static enum PrefKeys {
        DIVIDER_LOCATION;

    }
}

