/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.SPDataSource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class ConnectionComboBoxModel
implements ComboBoxModel,
DatabaseListChangeListener {
    private static final Logger logger = Logger.getLogger(ConnectionComboBoxModel.class);
    SPDataSource selectedItem;
    List<? extends SPDataSource> connections;
    List<ListDataListener> listenerList;
    DataSourceCollection plini;

    public ConnectionComboBoxModel(DataSourceCollection plini) {
        this.plini = plini;
        this.listenerList = new ArrayList<ListDataListener>();
        this.connections = plini.getConnections();
        plini.addDatabaseListChangeListener(this);
    }

    public void cleanup() {
        this.plini.removeDatabaseListChangeListener(this);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        int selectedIndex = this.connections.indexOf(anItem);
        if (selectedIndex >= 0) {
            if (anItem instanceof SPDataSource) {
                this.selectedItem = (SPDataSource)anItem;
            } else if (anItem == null) {
                this.selectedItem = null;
            }
            this.fireContentChangedEvent(selectedIndex);
        }
    }

    public void setSelectedItem(String anItem) {
        for (SPDataSource sPDataSource : this.connections) {
            if (!sPDataSource.getName().equals(anItem)) continue;
            this.selectedItem = sPDataSource;
            this.setSelectedItem(this.selectedItem);
            return;
        }
        logger.debug((Object)("warning: set selected item:" + anItem));
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.connections.size() + 1;
    }

    @Override
    public Object getElementAt(int index) {
        if (index == 0) {
            return null;
        }
        return this.connections.get(index - 1);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(l);
    }

    private void fireContentChangedEvent(int index) {
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).contentsChanged(new ListDataEvent(this, 0, index, index));
        }
    }

    @Override
    public void databaseAdded(DatabaseListChangeEvent e) {
        this.connections = this.plini.getConnections();
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).contentsChanged(new ListDataEvent(this, 1, e.getListIndex(), e.getListIndex()));
        }
    }

    @Override
    public void databaseRemoved(DatabaseListChangeEvent e) {
        this.connections = this.plini.getConnections();
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).contentsChanged(new ListDataEvent(this, 2, e.getListIndex(), e.getListIndex()));
        }
    }
}

