(define-library (chibi crypto sha2-test)
  (export run-tests)
  (import (scheme base) (chibi crypto sha2) (chibi test))
  (begin
    (define (run-tests)
      (test-begin "sha2")
      (test "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f"
          (sha-224 ""))
      (test "23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7"
          (sha-224 "abc"))
      (test "730e109bd7a8a32b1cb9d9a09aa2325d2430587ddbc0c38bad911525"
          (sha-224 "The quick brown fox jumps over the lazy dog"))
      (test "7c9da3bf97ccdeee630639aacdce35d3c136e514332a28e67097a4a4"
          (sha-224 "Boundary test for 448 bits (-1) - 012345678901234567890"))
      (test "35aebce593c857a2c817428340ff465922ffe43ed076d24553db1a24"
          (sha-224 "Boundary test for 448 bits (0)  - 0123456789012345678901"))
      (test "3f8dbeb9c33981d7007e20641d506d048e89e98a9546ecccc3224d3b"
          (sha-224 "Boundary test for 448 bits (+1) - 01234567890123456789012"))
      (test "8b311209d5880800911d3e72ffe7e75ec33a6e83932d5cdd00c96327"
          (sha-224 "Boundary test for 512 bits (-1) - 01234567890123456789012345678"))
      (test "9b68fdc122e1cb38575ba97f54699d71eaf0e58ee88f9e653b31d6ce"
          (sha-224 "Boundary test for 512 bits (0)  - 012345678901234567890123456789"))
      (test "52b28e31226ee5e6ada43e33194e11d8015abf8b5511c1631ad11aea"
          (sha-224 "Boundary test for 512 bits (+1) - 0123456789012345678901234567890"))
      (test "aa85fe2924d9c259f92e154fa88d0c845654fe69aa7dc1e3f7e4c789"
          (sha-224 "Boundary test for 960 bits (-1) - 0123456789012345678901234567890123456789012345678901234567890123456789012345678901234"))
      (test "dd8af6abfe24e78065afd1ae06220e8d46401db13f202109770ca2d2"
          (sha-224 "Boundary test for 960 bits (0)  - 01234567890123456789012345678901234567890123456789012345678901234567890123456789012345"))
      (test "5299a41ce9c6e8b405f42b193922fb4af3da16a1519610057baca20f"
          (sha-224 "Boundary test for 960 bits (+1) - 012345678901234567890123456789012345678901234567890123456789012345678901234567890123456"))
      (test "cb88e45dc662233ef4e7171e9e1c4903bd6502dd25923105778ea82e"
          (sha-224 "Boundary test for 1024 bits (-1) - 01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901"))
      (test "f41c907a7fd2fa3aec70815669fe467760f4fd15763a75192d2c9f45"
          (sha-224 "Boundary test for 1024 bits (0)  - 012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012"))
      (test "cc1501345f86b1ef60eaf3637f7a37c38c63252b5674d343a3cc4aea"
          (sha-224 "Boundary test for 1024 bits (+1) - 0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123"))
      (test "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f"
          (sha-224 #u8()))
      (test "ae40be26ae2072dd84f37c13a5f6af48e3c33ea1c08a5ef4a54b22e3"
          (sha-224 #u8(1 2 3 4 5 6 7 8 9)))
      (test "54e5eb52479c241cc4759318619f548994ae46979124cb9b1435db14"
          (sha-224 (open-input-bytevector #u8(1 2 3 9))))
      (test "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855"
          (sha-256 ""))
      (test "ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad"
          (sha-256 "abc"))
      (test "d7a8fbb307d7809469ca9abcb0082e4f8d5651e46d3cdb762d02d0bf37c9e592"
          (sha-256 "The quick brown fox jumps over the lazy dog"))
      (test "61f8fe4c4cdc8b3e10673933fcd0c5b1f6b46d3392550e42b265daefc7bc0d31"
          (sha-256 "abcdbcdecdefdefgefghfghighijhijkijkljklmklm"))
      (test "248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1"
          (sha-256 "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"))
      (test "f904e41d6488bc982a929e1f9307d9b47f12e6cc01ab42d109b083a780dbb70a"
          (sha-256 "Boundary test for 448 bits (-1) - 012345678901234567890"))
      (test "4621c7c067a12951ed5b0339a6c6811aec2dea4adcb2dcbb1383868765dbbc21"
          (sha-256 "Boundary test for 448 bits (0)  - 0123456789012345678901"))
      (test "a62bd24e12494c5a213dc366fec9d79e2bd77789febf6b1437191f264ad0a7fe"
          (sha-256 "Boundary test for 448 bits (+1) - 01234567890123456789012"))
      (test "2c47adeb018cd5634aa3c121bf0e6d122789448568814e7243b19b6c26ac4860"
          (sha-256 "Boundary test for 512 bits (-1) - 01234567890123456789012345678"))
      (test "eb1018cf7e5f40ba45a711c4154584234e2194f10cc6fa7559a438bed9e4a388"
          (sha-256 "Boundary test for 512 bits (0)  - 012345678901234567890123456789"))
      (test "714f030e4971ade8976564693a8fe202ca357e87cb1cb7391a9af3c45590f7c0"
          (sha-256 "Boundary test for 512 bits (+1) - 0123456789012345678901234567890"))
      (test "a745d68a9999da92558757735428346439e2af5668b188e9e4da7935e318335b"
          (sha-256 "Boundary test for 960 bits (-1) - 0123456789012345678901234567890123456789012345678901234567890123456789012345678901234"))
      (test "f2d7ad79e0360fbad145dd551db33548dc7cd253e6c56c975f2820e4c99dee51"
          (sha-256 "Boundary test for 960 bits (0)  - 01234567890123456789012345678901234567890123456789012345678901234567890123456789012345"))
      (test "9f0378e0ba55965bd17232f994710b786e9d72a88a806c0b10cd9d36a06e41ed"
          (sha-256 "Boundary test for 960 bits (+1) - 012345678901234567890123456789012345678901234567890123456789012345678901234567890123456"))
      (test "483a36ca7824cc0d9bff2d63901301ba8ca7deb675628c71d8a08d52a0396cfe"
          (sha-256 "Boundary test for 1024 bits (-1) - 01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901"))
      (test "8bd16f15e5f1b753650753497d09e1956137fba0cb2162a61dc6a2b49c7fcda3"
          (sha-256 "Boundary test for 1024 bits (0)  - 012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012"))
      (test "c6c960e1c106d214e82d58c12c44adb000903d2022ea2ce239f273294d3055e5"
          (sha-256 "Boundary test for 1024 bits (+1) - 0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123"))
      (test "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855"
          (sha-256 #u8()))
      (test "47e4ee7f211f73265dd17658f6e21c1318bd6c81f37598e20a2756299542efcf"
          (sha-256 #u8(1 2 3 4 5 6 7 8 9)))
      (test "a745f3ca4f474d583c050eaf476ce76439d171ebe2b49d4af8b44f13ba71fb56"
          (sha-256 (open-input-bytevector #u8(1 2 3 9))))
      (test-end))))
