/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.util;

import com.amazon.aes.util.LangUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.codehaus.xfire.util.Base64;

public abstract class CryptoUtils {
    private static final String ASYM_ALG = "RSA/ECB/PKCS1Padding";

    public static String signSha1(String string, String keyfile) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, SignatureException, InvalidKeyException {
        PrivateKey privateKey = CryptoUtils.getKeyFromFile(keyfile);
        Signature signature = Signature.getInstance("SHA1/RSA");
        signature.initSign(privateKey);
        signature.update(string.getBytes("UTF-8"));
        return LangUtils.byteArrayToHexString(signature.sign());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptFile(String filePath, String keyfile) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, BadPaddingException, IllegalBlockSizeException {
        PrivateKey privateKey;
        try {
            privateKey = CryptoUtils.getKeyFromFile(keyfile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading private key", e);
        }
        Cipher c = Cipher.getInstance(ASYM_ALG);
        c.init(2, privateKey);
        FileInputStream inputStream = new FileInputStream(filePath);
        String decryptedFilePath = filePath + ".decrypted";
        FileOutputStream outputStream = new FileOutputStream(decryptedFilePath);
        try {
            int len;
            byte[] inbuf = new byte[8192];
            byte[] outbuf = new byte[16384];
            while ((len = ((InputStream)inputStream).read(inbuf)) != -1) {
                int requiredOutlen = c.getOutputSize(len);
                if (requiredOutlen > outbuf.length) {
                    outbuf = new byte[requiredOutlen];
                }
                try {
                    int outlen = c.update(inbuf, 0, len, outbuf);
                    ((OutputStream)outputStream).write(outbuf, 0, outlen);
                }
                catch (ShortBufferException e) {
                    throw new RuntimeException("Got ShortBufferException despite updating outbut buffer", e);
                }
            }
            ((OutputStream)outputStream).write(c.doFinal());
        }
        finally {
            try {
                ((OutputStream)outputStream).close();
            }
            catch (Exception ignored) {}
            try {
                ((InputStream)inputStream).close();
            }
            catch (Exception ignored) {}
        }
        return decryptedFilePath;
    }

    public static byte[] decryptData(byte[] data, String keyfile) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, BadPaddingException, IllegalBlockSizeException {
        PrivateKey privateKey;
        try {
            privateKey = CryptoUtils.getKeyFromFile(keyfile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading private key", e);
        }
        Cipher c = Cipher.getInstance(ASYM_ALG);
        c.init(2, privateKey);
        c.update(data);
        return c.doFinal();
    }

    public static PrivateKey getKeyFromFile(String keyfile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(keyfile));
        StringBuffer keyBuf = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("-----BEGIN") || line.startsWith("-----END")) continue;
            keyBuf.append(line);
            keyBuf.append("\n");
        }
        br.close();
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)keyBuf.toString()));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(privKeySpec);
    }
}

