/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;

public class FileFontDataInputSource
implements FontDataInputSource {
    private File file;
    private RandomAccessFile fileReader;
    private long lastPosition;

    public FileFontDataInputSource(File file) throws IOException {
        this.file = file;
        this.fileReader = new RandomAccessFile(file, "r");
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public void readFullyAt(long position, byte[] buffer, int length) throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new RandomAccessFile(this.file, "r");
            if (position > this.fileReader.length()) {
                throw new EOFException("Given position is beyond the end of the file.");
            }
            this.fileReader.seek(position);
        } else {
            if (position > this.fileReader.length()) {
                throw new EOFException("Given position is beyond the end of the file.");
            }
            if (position != this.lastPosition) {
                this.fileReader.seek(position);
            }
        }
        try {
            this.fileReader.readFully(buffer, 0, length);
            this.lastPosition = position + (long)length;
        }
        catch (IOException ioe) {
            this.lastPosition = -1L;
            throw ioe;
        }
    }

    public int readAt(long position, byte[] buffer, int offset, int length) throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new RandomAccessFile(this.file, "r");
            if (position > this.fileReader.length()) {
                return 0;
            }
            this.fileReader.seek(position);
        } else {
            if (position > this.fileReader.length()) {
                return 0;
            }
            if (position != this.lastPosition) {
                this.fileReader.seek(position);
            }
        }
        try {
            int readLength = (int)Math.min((long)length, this.fileReader.length() - position);
            this.fileReader.readFully(buffer, offset, readLength);
            this.lastPosition = position + (long)readLength;
            return readLength;
        }
        catch (IOException ioe) {
            this.lastPosition = -1L;
            throw ioe;
        }
    }

    @Override
    public int readAt(long position) throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new RandomAccessFile(this.file, "r");
            this.fileReader.seek(position);
        } else if (position != this.lastPosition) {
            this.fileReader.seek(position);
        }
        int retval = this.fileReader.read();
        if (retval == -1) {
            return -1;
        }
        this.lastPosition = position + 1L;
        return retval;
    }

    @Override
    public void dispose() {
        if (this.fileReader == null) {
            return;
        }
        try {
            this.fileReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileReader = null;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getFileName() {
        return this.file.getPath();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileFontDataInputSource that = (FileFontDataInputSource)o;
        return this.file.equals(that.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }
}

