/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.payara.tooling.data.JDKVersion;
import org.netbeans.modules.payara.tooling.server.parser.TreeParser;
import org.netbeans.modules.payara.tooling.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JvmConfigReader
extends TreeParser.NodeListener
implements XMLReader {
    private static String JVM_OPTIONS_TAG = "jvm-options";
    private String serverName;
    private List<JvmOption> jvmOptions = new ArrayList<JvmOption>();
    private HashMap<String, String> propMap = new HashMap();
    private boolean isMonitoringEnabled = false;
    private String serverConfigName;
    private boolean readConfig = false;
    private StringBuilder b = new StringBuilder();

    public JvmConfigReader(String serverName) {
        this.serverName = serverName;
    }

    public TreeParser.NodeListener getServerFinder() {
        return new TreeParser.NodeListener(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if ((JvmConfigReader.this.serverConfigName == null || JvmConfigReader.this.serverConfigName.length() == 0) && JvmConfigReader.this.serverName.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.serverConfigName = attributes.getValue("config-ref");
                }
            }
        };
    }

    public TreeParser.NodeListener getConfigFinder() {
        return new TreeParser.NodeListener(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.serverConfigName != null && JvmConfigReader.this.serverConfigName.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.readConfig = true;
                }
            }

            @Override
            public void endNode(String qname) throws SAXException {
                if ("config".equals(qname)) {
                    JvmConfigReader.this.readConfig = false;
                }
            }
        };
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        if (this.readConfig) {
            int attrLen = attributes.getLength();
            for (int i = 0; i < attrLen; ++i) {
                String name = attributes.getLocalName(i);
                if (name == null || name.isEmpty()) {
                    name = attributes.getQName(i);
                }
                String value = attributes.getValue(i);
                if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                this.propMap.put(name, value);
            }
        }
    }

    @Override
    public void readCData(String qname, char[] ch, int start, int length) throws SAXException {
        if (this.readConfig && JVM_OPTIONS_TAG.equals(qname)) {
            this.b.append(ch, start, length);
        }
    }

    @Override
    public void endNode(String qname) throws SAXException {
        if (this.readConfig && JVM_OPTIONS_TAG.equals(qname)) {
            this.jvmOptions.add(new JvmOption(this.b.toString()));
            this.b.delete(0, this.b.length());
        }
    }

    public TreeParser.NodeListener getMonitoringFinder() {
        return new TreeParser.NodeListener(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.readConfig) {
                    JvmConfigReader.this.isMonitoringEnabled = !"false".equals(attributes.getValue("monitoring-enabled"));
                }
            }
        };
    }

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        LinkedList<TreeParser.Path> paths = new LinkedList<TreeParser.Path>();
        paths.add(new TreeParser.Path("/domain/servers/server", this.getServerFinder()));
        paths.add(new TreeParser.Path("/domain/configs/config", this.getConfigFinder()));
        paths.add(new TreeParser.Path("/domain/configs/config/java-config", this));
        paths.add(new TreeParser.Path("/domain/configs/config/monitoring-service", this.getMonitoringFinder()));
        return paths;
    }

    public List<JvmOption> getJvmOptions() {
        return this.jvmOptions;
    }

    public Map<String, String> getPropMap() {
        return this.propMap;
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public static class JvmOption {
        public final String option;
        public final Optional<String> vendor;
        public final Optional<JDKVersion> minVersion;
        public final Optional<JDKVersion> maxVersion;
        private static final Pattern PATTERN = Pattern.compile("^\\[(.*)\\|(.*)\\](.*)");

        public JvmOption(String option) {
            Matcher matcher = PATTERN.matcher(option);
            if (matcher.matches()) {
                if (matcher.group(1).contains("-") && Character.isLetter(matcher.group(1).charAt(0))) {
                    String[] parts = matcher.group(1).split("-");
                    this.vendor = Optional.ofNullable(parts[0]);
                    this.minVersion = Optional.ofNullable(JDKVersion.toValue(parts[1]));
                } else {
                    this.vendor = Optional.empty();
                    this.minVersion = Optional.ofNullable(JDKVersion.toValue(matcher.group(1)));
                }
                this.maxVersion = Optional.ofNullable(JDKVersion.toValue(matcher.group(2)));
                this.option = matcher.group(3);
            } else {
                this.option = option;
                this.vendor = Optional.empty();
                this.minVersion = Optional.empty();
                this.maxVersion = Optional.empty();
            }
        }

        public JvmOption(String option, String minVersion, String maxVersion) {
            this.option = option;
            this.vendor = Optional.empty();
            this.minVersion = Optional.ofNullable(JDKVersion.toValue(minVersion));
            this.maxVersion = Optional.ofNullable(JDKVersion.toValue(maxVersion));
        }

        public static boolean hasVersionPattern(String option) {
            return PATTERN.matcher(option).matches();
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.option);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JvmOption other = (JvmOption)obj;
            return Objects.equals(this.option, other.option);
        }

        public String toString() {
            if (!this.minVersion.isPresent() && !this.maxVersion.isPresent()) {
                return this.option;
            }
            return String.format("[%s|%s]%s", this.minVersion.isPresent() ? this.minVersion.get() : "", this.maxVersion.isPresent() ? this.maxVersion.get() : "", this.option);
        }
    }
}

