/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.spi;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.webkit.debugging.api.TransportStateException;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class MobileDebugTransport
implements TransportImplementation {
    protected ResponseCallback callBack;
    private String indexHtmlLocation;
    private String bundleId;
    private BrowserURLMapperImplementation.BrowserURLMapper mapper;
    private final RequestProcessor RP = new RequestProcessor(MobileDebugTransport.class);

    public final void registerResponseCallback(ResponseCallback callback) {
        this.callBack = callback;
    }

    public final void sendCommand(final Command command) throws TransportStateException {
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                MobileDebugTransport.this.sendCommandImpl(command);
            }
        });
    }

    protected abstract void sendCommandImpl(Command var1);

    public final URL getConnectionURL() {
        try {
            if (this.indexHtmlLocation == null || this.indexHtmlLocation.isEmpty()) {
                return null;
            }
            return new URL(this.indexHtmlLocation);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final String translate(String toString) {
        return toString.replaceAll("localhost", WebUtils.getLocalhostInetAddress().getHostAddress());
    }

    public final void setBaseUrl(String documentURL) {
        this.indexHtmlLocation = documentURL;
        if (this.mapper != null && documentURL != null) {
            int idx = documentURL.lastIndexOf("/www/");
            assert (idx > -1) : "document url does not contain 'www' in path: " + documentURL;
            documentURL = documentURL.substring(0, idx + "/www/".length());
            documentURL = documentURL.replaceAll("file:///", "file:/");
            documentURL = documentURL.replaceAll("file:/", "file:///");
            try {
                this.mapper.setBrowserURLRoot(WebUtils.urlToString((URL)new URL(documentURL)));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public final void setBundleIdentifier(String name) {
        this.bundleId = name;
    }

    protected final String getBundleIdentifier() {
        return this.bundleId;
    }

    public final void setBrowserURLMapper(BrowserURLMapperImplementation.BrowserURLMapper mapper) {
        this.mapper = mapper;
    }

    public void flush() {
    }
}

