/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.Language;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.parser.Parser;

public abstract class TokenInputUtils {
    public static TokenInput create(Language language, Parser parser, CharInput input) {
        return new TokenInputImpl(new TokenReader(language, parser, input), input);
    }

    public static TokenInput create(ASTToken[] array) {
        return new ArrayInput(array);
    }

    public static TokenInput create(List list) {
        return new ListInput(list);
    }

    private static class ListInput
    extends TokenInput {
        private List list;
        private int index = 0;
        private int length;

        private ListInput(List list) {
            this.list = list;
            this.length = list.size();
        }

        @Override
        public ASTToken read() {
            if (this.index < this.length) {
                return (ASTToken)this.list.get(this.index++);
            }
            return null;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            ASTToken t = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                t = (ASTToken)this.list.get(this.list.size() - 1);
                return t.getOffset() + t.getLength();
            }
            t = this.next(1);
            return t.getOffset();
        }

        @Override
        public boolean eof() {
            return this.index >= this.length;
        }

        @Override
        public ASTToken next(int i) {
            if (this.index + i - 1 < this.length) {
                return (ASTToken)this.list.get(this.index + i - 1);
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = this.index;
            for (int j = 0; j < 10 && i < this.length; ++i, ++j) {
                sb.append(this.list.get(i)).append(" ");
            }
            return sb.toString();
        }
    }

    private static class ArrayInput
    extends TokenInput {
        private ASTToken[] array;
        private int index = 0;
        private int length;

        private ArrayInput(ASTToken[] array) {
            this.array = array;
            this.length = array.length;
        }

        @Override
        public ASTToken read() {
            if (this.index < this.length) {
                return this.array[this.index++];
            }
            return null;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            ASTToken t = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                t = this.array[this.array.length - 1];
                return t.getOffset() + t.getLength();
            }
            t = this.next(1);
            return t.getOffset();
        }

        @Override
        public boolean eof() {
            return this.index >= this.length;
        }

        @Override
        public ASTToken next(int i) {
            if (this.index + i - 1 < this.length) {
                return this.array[this.index + i - 1];
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = this.index;
            for (int j = 0; j < 10 && i < this.length; ++i, ++j) {
                sb.append(this.array[i]).append(" ");
            }
            return sb.toString();
        }
    }

    private static class TokenInputImpl
    extends TokenInput {
        private TokenReader tokenReader;
        private List<ASTToken> tokens = new ArrayList<ASTToken>();
        private int index = 0;
        private CharInput input;

        TokenInputImpl(TokenReader tokenReader, CharInput input) {
            this.input = input;
            this.tokenReader = tokenReader;
        }

        @Override
        public ASTToken next(int i) {
            while (this.index + i - 1 >= this.tokens.size()) {
                this.tokens.add(this.tokenReader.readToken(this.input));
            }
            return this.tokens.get(this.index + i - 1);
        }

        @Override
        public boolean eof() {
            return this.next(1) == null;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            ASTToken t = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                int i = this.tokens.size() - 1;
                while ((t = this.tokens.get(i--)) == null && i > 0) {
                }
                if (t == null) {
                    return 0;
                }
                return t.getOffset() + t.getLength();
            }
            t = this.next(1);
            return t.getOffset();
        }

        @Override
        public ASTToken read() {
            ASTToken t = this.next(1);
            if (t != null) {
                ++this.index;
            }
            return t;
        }

        @Override
        public void setIndex(int index) {
            if (index > this.tokens.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.index = index;
        }

        public String getString(int from) {
            throw new InternalError();
        }

        public String toString() {
            return this.input.toString();
        }
    }

    private static class TokenReader {
        private Language language;
        private Parser parser;
        private CharInput input;
        private int state = -1;
        private Parser.Cookie cookie = new MyCookie();
        private ASTToken next;

        private TokenReader(Language language, Parser parser, CharInput input) {
            this.language = language;
            this.parser = parser;
            this.input = input;
        }

        public ASTToken nextToken(CharInput input) {
            if (this.next == null) {
                this.next = this.readToken(input);
            }
            return this.next;
        }

        public ASTToken readToken(CharInput input) {
            if (input.eof()) {
                return null;
            }
            if (this.next != null) {
                ASTToken p = this.next;
                this.next = null;
                return p;
            }
            ASTToken token = this.parser.read(this.cookie, input, this.language);
            if (token != null) {
                return token;
            }
            int offset = input.getIndex();
            return ASTToken.create(this.language, "error", String.valueOf(input.read()), offset, 1, null);
        }

        private class MyCookie
        implements Parser.Cookie {
            private MyCookie() {
            }

            @Override
            public int getState() {
                return TokenReader.this.state;
            }

            @Override
            public void setState(int state) {
                TokenReader.this.state = state;
            }

            @Override
            public void setProperties(Feature tokenProperties) {
            }
        }
    }
}

