/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.progress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.ui.api.TestResultDisplayHandler;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.TestSuiteInfo;
import org.openide.filesystems.FileObject;

public final class TestProgressHandler
implements TestResultDisplayHandler.Spi<TestProgressHandler> {
    private final NbCodeLanguageClient lspClient;
    private final IDebugProtocolClient debugClient;
    private final String uri;

    public TestProgressHandler(NbCodeLanguageClient lspClient, IDebugProtocolClient debugClient, String uri) {
        this.lspClient = lspClient;
        this.debugClient = debugClient;
        this.uri = uri;
    }

    public TestProgressHandler create(TestSession session) {
        return this;
    }

    public void displayOutput(TestProgressHandler token, String text, boolean error) {
        if (text != null) {
            OutputEventArguments output = new OutputEventArguments();
            output.setOutput(text.endsWith("\n") ? text : text + "\n");
            this.debugClient.output(output);
        }
    }

    public void displaySuiteRunning(TestProgressHandler token, String suiteName) {
        this.lspClient.notifyTestProgress(new TestProgressParams(this.uri, new TestSuiteInfo(suiteName, "running")));
    }

    public void displaySuiteRunning(TestProgressHandler token, TestSuite suite) {
        this.lspClient.notifyTestProgress(new TestProgressParams(this.uri, new TestSuiteInfo(suite.getName(), "running")));
    }

    public void displayReport(TestProgressHandler token, Report report) {
        String status;
        HashMap<String, FileObject> fileLocations = new HashMap<String, FileObject>();
        LinkedHashMap<String, TestSuiteInfo.TestCaseInfo> testCases = new LinkedHashMap<String, TestSuiteInfo.TestCaseInfo>();
        for (Testcase test : report.getTests()) {
            String status2;
            String className = test.getClassName();
            String name = test.getName();
            int idx = name.indexOf(40);
            if (idx > 0) {
                name = name.substring(0, idx);
            }
            String id = className + ':' + name;
            switch (test.getStatus()) {
                case PASSED: {
                    status2 = "passed";
                    break;
                }
                case ERROR: {
                    status2 = "errored";
                    break;
                }
                case FAILED: {
                    status2 = "failed";
                    break;
                }
                case SKIPPED: {
                    status2 = "skipped";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected testcase status: " + test.getStatus());
                }
            }
            List<String> stackTrace = test.getTrouble() != null ? Arrays.asList(test.getTrouble().getStackTrace()) : null;
            String location = test.getLocation();
            FileObject fo = location != null ? fileLocations.computeIfAbsent(location, loc -> {
                LineConvertors.FileLocator fileLocator = (LineConvertors.FileLocator)test.getSession().getProject().getLookup().lookup(LineConvertors.FileLocator.class);
                int i = loc.indexOf(58);
                if (i > 0) {
                    loc = loc.substring(0, i);
                }
                return fileLocator != null ? fileLocator.find(loc) : null;
            }) : null;
            TestSuiteInfo.TestCaseInfo info = (TestSuiteInfo.TestCaseInfo)testCases.get(id);
            if (info != null) {
                this.updateState(info, status2);
                continue;
            }
            info = new TestSuiteInfo.TestCaseInfo(id, name, className + '.' + name, fo != null ? Utils.toUri(fo) : null, null, status2, stackTrace);
            testCases.put(id, info);
        }
        switch (report.getStatus()) {
            case PASSED: 
            case FAILED: {
                status = "completed";
                break;
            }
            case ERROR: {
                status = "errored";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected testsuite status: " + report.getStatus());
            }
        }
        FileObject fo = fileLocations.size() == 1 ? (FileObject)fileLocations.values().iterator().next() : null;
        this.lspClient.notifyTestProgress(new TestProgressParams(this.uri, new TestSuiteInfo(report.getSuiteClassName(), fo != null ? Utils.toUri(fo) : null, null, status, new ArrayList<TestSuiteInfo.TestCaseInfo>(testCases.values()))));
    }

    public void displayMessage(TestProgressHandler token, String message) {
    }

    public void displayMessageSessionFinished(TestProgressHandler token, String message) {
    }

    public int getTotalTests(TestProgressHandler token) {
        return 0;
    }

    private void updateState(TestSuiteInfo.TestCaseInfo info, String state) {
        switch (state) {
            case "errored": {
                info.setState(state);
                break;
            }
            case "failed": {
                if ("errored".equals(info.getState())) break;
                info.setState(state);
                break;
            }
            case "passed": {
                if (!"skipped".equals(info.getState())) break;
                info.setState(state);
            }
        }
    }
}

