/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public final class GetterSetterGenerator
extends CodeGenerator {
    public static final String GENERATE_GETTERS = "java.generate.getters";
    public static final String GENERATE_SETTERS = "java.generate.setters";
    public static final String GENERATE_GETTERS_SETTERS = "java.generate.getters.setters";
    private final Set<String> commands = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.generate.getters", "java.generate.setters", "java.generate.getters.setters")));
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(CompilationInfo info, CodeActionParams params) {
        String name;
        List only = params.getContext().getOnly();
        boolean all = only != null && only.contains("source");
        Pair<Set<VariableElement>, Set<VariableElement>> pair = GetterSetterGenerator.findMissingGettersSetters(info, params.getRange(), all);
        boolean missingGetters = !((Set)pair.first()).isEmpty();
        boolean missingSetters = !((Set)pair.second()).isEmpty();
        String uri = Utils.toUri(info.getFileObject());
        int offset = GetterSetterGenerator.getOffset(info, params.getRange().getStart());
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        if (missingGetters) {
            name = ((Set)pair.first()).size() == 1 ? Bundle.DN_GenerateGetterFor(((VariableElement)((Set)pair.first()).iterator().next()).getSimpleName().toString()) : Bundle.DN_GenerateGetters();
            result.add(GetterSetterGenerator.createCodeAction(name, all ? "source.generate" : "quickfix", GENERATE_GETTERS, uri, offset, all, ((Set)pair.first()).stream().map(variableElement -> {
                QuickPickItem item = new QuickPickItem(GetterSetterGenerator.createLabel(info, variableElement));
                item.setUserData(new CodeGenerator.ElementData((Element)variableElement));
                return item;
            }).collect(Collectors.toList())));
        }
        if (missingSetters) {
            name = ((Set)pair.second()).size() == 1 ? Bundle.DN_GenerateSetterFor(((VariableElement)((Set)pair.second()).iterator().next()).getSimpleName().toString()) : Bundle.DN_GenerateSetters();
            result.add(GetterSetterGenerator.createCodeAction(name, all ? "source.generate" : "quickfix", GENERATE_SETTERS, uri, offset, all, ((Set)pair.second()).stream().map(variableElement -> {
                QuickPickItem item = new QuickPickItem(GetterSetterGenerator.createLabel(info, variableElement));
                item.setUserData(new CodeGenerator.ElementData((Element)variableElement));
                return item;
            }).collect(Collectors.toList())));
        }
        if (missingGetters && missingSetters) {
            ((Set)pair.first()).retainAll((Collection)pair.second());
            name = ((Set)pair.first()).size() == 1 ? Bundle.DN_GenerateGetterSetterFor(((VariableElement)((Set)pair.first()).iterator().next()).getSimpleName().toString()) : Bundle.DN_GenerateGettersSetters();
            result.add(GetterSetterGenerator.createCodeAction(name, all ? "source.generate" : "quickfix", GENERATE_GETTERS_SETTERS, uri, offset, all, ((Set)pair.first()).stream().map(variableElement -> {
                QuickPickItem item = new QuickPickItem(GetterSetterGenerator.createLabel(info, variableElement));
                item.setUserData(new CodeGenerator.ElementData((Element)variableElement));
                return item;
            }).collect(Collectors.toList())));
        }
        return result;
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.size() > 3) {
            String text;
            int kind;
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            int offset = (Integer)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Integer.class);
            boolean all = (Boolean)this.gson.fromJson(this.gson.toJson(arguments.get(2)), Boolean.TYPE);
            List<Object> fields = Arrays.asList((Object[])this.gson.fromJson(this.gson.toJson(arguments.get(3)), QuickPickItem[].class));
            switch (command) {
                case "java.generate.getters": {
                    kind = 1;
                    text = Bundle.DN_SelectGetters();
                    break;
                }
                case "java.generate.setters": {
                    kind = 2;
                    text = Bundle.DN_SelectSetters();
                    break;
                }
                default: {
                    kind = 0;
                    text = Bundle.DN_SelectGettersSetters();
                }
            }
            if (all && fields.size() > 1) {
                client.showQuickPick(new ShowQuickPickParams(text, true, fields)).thenAccept(selected -> {
                    if (selected != null && !selected.isEmpty()) {
                        this.generate(client, kind, uri, offset, (List<QuickPickItem>)selected);
                    }
                });
            } else if (fields.size() == 1) {
                this.generate(client, kind, uri, offset, fields);
            }
        } else {
            client.logMessage(new MessageParams(MessageType.Error, String.format("Illegal number of arguments received for command: %s", command)));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void generate(NbCodeLanguageClient client, int kind, String uri, int offset, List<QuickPickItem> fields) throws IllegalArgumentException {
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = wc.getTreeUtilities().pathFor(offset);
                tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
                if (tp != null) {
                    List variableElements = fields.stream().map(item -> {
                        CodeGenerator.ElementData data = (CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeGenerator.ElementData.class);
                        return (VariableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    GeneratorUtils.generateGettersAndSetters((WorkingCopy)wc, (TreePath)tp, variableElements, (int)kind, (int)-1);
                }
            }));
            client.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(uri, edits))));
        }
        catch (IOException ex) {
            client.logMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }

    private static Pair<Set<VariableElement>, Set<VariableElement>> findMissingGettersSetters(CompilationInfo info, Range range, boolean all) {
        TreePath tp = info.getTreeUtilities().pathFor(GetterSetterGenerator.getOffset(info, range.getStart()));
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Pair.of(Collections.emptySet(), Collections.emptySet());
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(tp);
        if (type == null) {
            return Pair.of(Collections.emptySet(), Collections.emptySet());
        }
        int selectionStart = GetterSetterGenerator.getOffset(info, range.getStart());
        int selectionEnd = GetterSetterGenerator.getOffset(info, range.getEnd());
        ClassTree clazz = (ClassTree)tp.getLeaf();
        HashSet<VariableElement> selectedFields = new HashSet<VariableElement>();
        for (Tree tree : clazz.getMembers()) {
            if (tree.getKind() != Tree.Kind.VARIABLE) continue;
            int start = (int)info.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree);
            int end = (int)info.getTrees().getSourcePositions().getEndPosition(tp.getCompilationUnit(), tree);
            if (!all && !GetterSetterGenerator.intersects(start, end, selectionStart, selectionEnd)) continue;
            selectedFields.add((VariableElement)info.getTrees().getElement(new TreePath(tp, tree)));
        }
        Pair<Set<VariableElement>, Set<VariableElement>> pair = GetterSetterGenerator.findMissingGettersSetters(info, type);
        ((Set)pair.first()).retainAll(selectedFields);
        ((Set)pair.second()).retainAll(selectedFields);
        return pair;
    }

    private static boolean intersects(int fieldStart, int fieldEnd, int selectionStart, int selectionEnd) {
        return selectionStart <= fieldEnd && selectionEnd >= fieldStart;
    }

    private static Pair<Set<VariableElement>, Set<VariableElement>> findMissingGettersSetters(CompilationInfo info, TypeElement type) {
        LinkedHashSet<VariableElement> missingGetters = new LinkedHashSet<VariableElement>();
        LinkedHashSet<VariableElement> missingSetters = new LinkedHashSet<VariableElement>();
        ElementUtilities eu = info.getElementUtilities();
        CodeStyle codeStyle = CodeStyle.getDefault((FileObject)info.getFileObject());
        for (VariableElement variableElement : ElementFilter.fieldsIn(info.getElements().getAllMembers(type))) {
            boolean hasSetter;
            if ("<error>".contentEquals(variableElement.getSimpleName())) continue;
            boolean hasGetter = eu.hasGetter(type, variableElement, codeStyle);
            boolean bl = hasSetter = variableElement.getModifiers().contains((Object)Modifier.FINAL) || eu.hasSetter(type, variableElement, codeStyle);
            if (!hasGetter) {
                missingGetters.add(variableElement);
            }
            if (hasSetter) continue;
            missingSetters.add(variableElement);
        }
        return Pair.of(missingGetters, missingSetters);
    }
}

