/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.xml.multiview.AbstractMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.openide.actions.SaveAction;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.ProxyLookup;

public class XmlMultiViewElement
extends AbstractMultiViewElement
implements Serializable {
    static final long serialVersionUID = -326467724916080580L;
    private transient XmlMultiViewEditorSupport.XmlCloneableEditor xmlEditor;
    private transient JComponent toolbar;
    private transient ToolbarInitializer initializer;
    private static final RequestProcessor INIT_RP = new RequestProcessor("XmlMultiViewElementToolbar initializer", 3);

    public XmlMultiViewElement() {
    }

    public XmlMultiViewElement(XmlMultiViewDataObject dObj) {
        super(dObj);
    }

    public void componentDeactivated() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
        this.getXmlEditor().componentActivated();
    }

    public void componentShowing() {
        this.getXmlEditor().componentShowing();
    }

    @Override
    public void componentOpened() {
        this.getXmlEditor().componentOpened();
    }

    @Override
    public void componentClosed() {
        this.getXmlEditor().componentClosed();
    }

    public Lookup getLookup() {
        return new ProxyLookup(new Lookup[]{this.dObj.getNodeDelegate().getLookup()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            JEditorPane editorPane = this.getXmlEditor().getEditorPane();
            XmlMultiViewElement xmlMultiViewElement = this;
            synchronized (xmlMultiViewElement) {
                if (this.toolbar == null) {
                    if (this.initializer == null) {
                        this.initializer = new ToolbarInitializer(editorPane);
                        INIT_RP.post((Runnable)this.initializer);
                    }
                    JPanel fake = new JPanel();
                    fake.setLayout(new BorderLayout());
                    this.initializer.addToolbarPlaceholder(fake);
                    return fake;
                }
            }
        }
        return this.toolbar;
    }

    public JComponent getVisualRepresentation() {
        return this.getXmlEditor();
    }

    private XmlMultiViewEditorSupport.XmlCloneableEditor getXmlEditor() {
        if (this.xmlEditor == null) {
            this.xmlEditor = (XmlMultiViewEditorSupport.XmlCloneableEditor)this.dObj.getEditorSupport().createCloneableEditor();
            ActionMap map = this.xmlEditor.getActionMap();
            SaveAction act = (SaveAction)SystemAction.get(SaveAction.class);
            KeyStroke stroke = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            this.xmlEditor.getInputMap(1).put(stroke, "save");
            map.put("save", (Action)act);
        }
        return this.xmlEditor;
    }

    private class ToolbarInitializer
    implements Runnable {
        private final List<JPanel> toolbarPanels = new ArrayList<JPanel>(3);
        private final JEditorPane editorPane;
        private Document doc;
        private JComponent realToolBar;

        public ToolbarInitializer(JEditorPane editorPane) {
            this.editorPane = editorPane;
        }

        void addToolbarPlaceholder(JPanel p) {
            this.toolbarPanels.add(p);
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runInAwt();
                return;
            }
            this.doc = this.editorPane.getDocument();
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInAwt() {
            if (this.doc instanceof NbDocument.CustomToolbar) {
                this.realToolBar = ((NbDocument.CustomToolbar)this.doc).createToolbar(this.editorPane);
            }
            XmlMultiViewElement xmlMultiViewElement = XmlMultiViewElement.this;
            synchronized (xmlMultiViewElement) {
                if (this.realToolBar == null) {
                    XmlMultiViewElement.this.toolbar = new JPanel();
                } else {
                    XmlMultiViewElement.this.toolbar = this.realToolBar;
                }
                XmlMultiViewElement.this.initializer = null;
            }
            if (this.realToolBar == null) {
                return;
            }
            for (JComponent jComponent : this.toolbarPanels) {
                if (!jComponent.isValid()) continue;
                jComponent.add((Component)this.realToolBar, "Center");
            }
        }
    }
}

