/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.cookies;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.xml.cookies.CookieFactory;
import org.netbeans.modules.xml.cookies.CookieFactoryCreator;
import org.netbeans.modules.xml.util.LookupManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.CookieSet;

public final class CookieManager
extends LookupManager {
    private final DataObject dataObject;
    private final CookieSet cookieSet;
    private final Map<CookieFactoryCreator, CookieFactory> factoryMap;

    public CookieManager(DataObject dataObject, CookieSet cookieSet, Class clazz) {
        if (!CookieFactoryCreator.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Parameter class must extend CookieFactoryCreator class.");
        }
        this.dataObject = dataObject;
        this.cookieSet = cookieSet;
        this.factoryMap = new HashMap<CookieFactoryCreator, CookieFactory>();
        this.register(clazz);
        this.addedToResult(this.getResult());
    }

    @Override
    protected void removedFromResult(Collection removed) {
        for (CookieFactoryCreator creator : removed) {
            CookieFactory factory = this.factoryMap.remove(creator);
            if (factory == null) continue;
            factory.unregisterCookies(this.cookieSet);
        }
    }

    @Override
    protected void addedToResult(Collection added) {
        for (CookieFactoryCreator creator : this.getResult()) {
            CookieFactory factory = creator.createCookieFactory(this.dataObject);
            if (factory == null) continue;
            this.factoryMap.put(creator, factory);
            factory.registerCookies(this.cookieSet);
        }
    }
}

