/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.subversion.config.KVFile;
import org.netbeans.modules.subversion.config.SVNCredentialFile;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class PasswordFile
extends SVNCredentialFile {
    private static final KVFile.Key PASSTYPE_KEY = new KVFile.Key(0, "passtype");
    private static final KVFile.Key PASSWORD_KEY = new KVFile.Key(1, "password");
    private static final KVFile.Key REALMSTRING_KEY = new KVFile.Key(2, "svn:realmstring");
    private static final KVFile.Key USERNAME_KEY = new KVFile.Key(3, "username");
    private static final String PASSTYPE_SIMPLE = "simple";
    private static Map<String, PasswordFile> files;

    public PasswordFile(String realmString) {
        super(PasswordFile.getFile(realmString));
    }

    private PasswordFile(File file) {
        super(file);
    }

    public static PasswordFile findFileForUrl(SVNUrl svnUrl) {
        PasswordFile pf;
        if (files == null) {
            files = new HashMap<String, PasswordFile>(1);
        }
        if ((pf = files.get(svnUrl.toString())) == null && (pf = PasswordFile.findFileForUrlIntern(svnUrl)) != null) {
            files.put(svnUrl.toString(), pf);
        }
        return pf;
    }

    private static PasswordFile findFileForUrlIntern(SVNUrl svnUrl) {
        String urlString = SvnUtils.ripUserFromHost(svnUrl.getHost());
        String realmString = "<" + svnUrl.getProtocol() + "://" + urlString + ">";
        PasswordFile nbPasswordFile = new PasswordFile(realmString);
        if (!nbPasswordFile.getFile().exists()) {
            File configDir = new File(SvnConfigFiles.getUserConfigPath() + "/auth/svn.simple");
            File[] files = configDir.listFiles();
            if (files == null) {
                return null;
            }
            for (int i = 0; i < files.length; ++i) {
                PasswordFile passwordFile = new PasswordFile(files[i]);
                if (!passwordFile.acceptSvnUrl(svnUrl) || !passwordFile.getPasstype().equals(PASSTYPE_SIMPLE)) continue;
                passwordFile.setRealmString(realmString);
                return passwordFile;
            }
            nbPasswordFile.setRealmString(realmString);
            nbPasswordFile.setPasstype(PASSTYPE_SIMPLE);
            nbPasswordFile.setPassword("");
            nbPasswordFile.setUsername("");
            return nbPasswordFile;
        }
        return nbPasswordFile;
    }

    @Override
    public void store() throws IOException {
        this.store(PasswordFile.getFile(this.getRealmString()));
    }

    public String getPassword() {
        return this.getStringValue(this.getPasswordKey());
    }

    public String getUsername() {
        return this.getStringValue(this.getUsernameKey());
    }

    public void setPassword(String password) {
        this.setValue(this.getPasswordKey(), password);
    }

    public void setUsername(String username) {
        this.setValue(this.getUsernameKey(), username);
    }

    @Override
    protected String getRealmString() {
        return this.getStringValue(this.getRealmstringKey());
    }

    @Override
    protected void setRealmString(String realm) {
        this.setValue(this.getRealmstringKey(), realm.getBytes());
    }

    private void setPasstype(String passtype) {
        this.setValue(this.getPasstypeKey(), passtype);
    }

    private String getPasstype() {
        return this.getStringValue(this.getPasstypeKey());
    }

    private boolean acceptSvnUrl(SVNUrl svnUrl) {
        if (svnUrl == null) {
            return false;
        }
        String realmStrig = this.getRealmString();
        if (realmStrig == null || realmStrig.length() < 6) {
            return false;
        }
        String urlString = SvnUtils.ripUserFromHost(svnUrl.getHost());
        return realmStrig.substring(1).startsWith(svnUrl.getProtocol() + "://" + urlString);
    }

    private static File getFile(String realmString) {
        return new File(SvnConfigFiles.getNBConfigPath() + "auth/svn.simple/" + PasswordFile.getFileName(realmString));
    }

    private KVFile.Key getPasstypeKey() {
        return this.getKey(PASSTYPE_KEY);
    }

    private KVFile.Key getPasswordKey() {
        return this.getKey(PASSWORD_KEY);
    }

    private KVFile.Key getRealmstringKey() {
        return this.getKey(REALMSTRING_KEY);
    }

    private KVFile.Key getUsernameKey() {
        return this.getKey(USERNAME_KEY);
    }
}

