/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.docker.ChunkedInputStream;
import org.openide.util.Pair;

public final class HttpUtils {
    private static final Pattern HTTP_RESPONSE_PATTERN = Pattern.compile("^HTTP/1\\.1 (\\d\\d\\d) (.*)$");

    private HttpUtils() {
    }

    public static Response readResponse(InputStream is) throws IOException {
        String response = HttpUtils.readResponseLine(is);
        if (response == null) {
            throw new IOException("No response from server");
        }
        Matcher m = HTTP_RESPONSE_PATTERN.matcher(response);
        if (!m.matches()) {
            throw new IOException("Wrong response from server");
        }
        int responseCode = Integer.parseInt(m.group(1));
        String message = m.group(2);
        Map<String, String> headers = HttpUtils.parseHeaders(is);
        return new Response(responseCode, message, headers);
    }

    @CheckForNull
    public static String readContent(InputStream is, Response response) throws IOException {
        int current;
        Integer length = HttpUtils.getLength(response.getHeaders());
        if (length == null || length == 0) {
            return null;
        }
        Charset encoding = HttpUtils.getCharset(response.getHeaders().get("CONTENT-TYPE"));
        byte[] content = new byte[length.intValue()];
        int count = 0;
        do {
            if ((current = is.read(content, count, length - count)) >= 0 || count >= length) continue;
            throw new IOException("Stream closed before reading content");
        } while ((count += current) < length);
        return new String(content, encoding);
    }

    public static InputStream getResponseStream(InputStream is, Response response, boolean allowSocketStream) throws IOException {
        if (HttpUtils.isChunked(response.getHeaders())) {
            return new ChunkedInputStream(new BufferedInputStream(is));
        }
        final Integer l = HttpUtils.getLength(response.getHeaders());
        if (l != null) {
            return new BufferedInputStream(new FilterInputStream(is){
                private int available;
                {
                    super(x0);
                    this.available = l;
                }

                @Override
                public int available() throws IOException {
                    return Math.min(super.available(), this.available);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    if (this.available <= 0) {
                        return -1;
                    }
                    int real = Math.min(this.available, len);
                    int count = super.read(b, off, real);
                    this.available -= count;
                    return count;
                }

                @Override
                public int read() throws IOException {
                    if (this.available <= 0) {
                        return -1;
                    }
                    --this.available;
                    return super.read();
                }
            });
        }
        if (allowSocketStream) {
            return new BufferedInputStream(is);
        }
        throw new IOException("Undefined content length");
    }

    public static Integer getLength(Map<String, String> headers) throws IOException {
        String value = headers.get("CONTENT-LENGTH");
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Wrong content length: " + value);
        }
    }

    @NonNull
    public static Charset getCharset(Response response) {
        return HttpUtils.getCharset(response.getHeaders().get("CONTENT-TYPE"));
    }

    public static String encodeParameter(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    public static String encodeBase64(String value) throws UnsupportedEncodingException {
        return Base64.getEncoder().encodeToString(value.getBytes("UTF-8"));
    }

    public static void configureHeaders(OutputStream os, Map<String, String> defaultHeaders, Pair<String, String> ... headers) throws IOException {
        StringBuilder sb = new StringBuilder();
        HttpUtils.configureHeaders(sb, defaultHeaders, headers);
        os.write(sb.toString().getBytes("ISO-8859-1"));
    }

    public static void configureHeaders(StringBuilder sb, Map<String, String> defaultHeaders, Pair<String, String> ... headers) throws IOException {
        HashMap<String, String> toUse = new HashMap<String, String>(defaultHeaders);
        for (Pair<String, String> h : headers) {
            if (h == null) continue;
            toUse.put((String)h.first(), (String)h.second());
        }
        for (Map.Entry entry : toUse.entrySet()) {
            sb.append((String)entry.getKey()).append(":").append(" ");
            sb.append((String)entry.getValue()).append("\r\n");
        }
    }

    static String readResponseLine(InputStream is) throws IOException {
        int b;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((b = is.read()) != -1) {
            if (b == 13) {
                int next = is.read();
                if (next == 10) {
                    return bos.toString("ISO-8859-1");
                }
                if (next == -1) {
                    return null;
                }
                bos.write(b);
                bos.write(next);
                continue;
            }
            bos.write(b);
        }
        return null;
    }

    private static Map<String, String> parseHeaders(InputStream is) throws IOException {
        String line;
        HashMap<String, String> result = new HashMap<String, String>();
        while ((line = HttpUtils.readResponseLine(is).trim()) != null && !"".equals(line)) {
            int index = line.indexOf(58);
            if (index <= 0) {
                throw new IOException("Invalid header: " + line);
            }
            if (index == line.length() - 1) continue;
            result.put(line.substring(0, index).toUpperCase(Locale.ENGLISH).trim(), line.substring(index + 1).trim());
        }
        return result;
    }

    private static Charset getCharset(String contentType) {
        Charset encoding = Charset.forName("UTF-8");
        if (contentType != null) {
            String[] parts;
            for (String p : parts = contentType.trim().split(";")) {
                String upper = p.toUpperCase(Locale.ENGLISH);
                if (!upper.startsWith("CHARSET")) continue;
                int index = upper.indexOf("=", 7);
                if (index <= 0 || index >= upper.length() - 1) break;
                try {
                    encoding = Charset.forName(upper.substring(index + 1).trim());
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {}
                break;
            }
        }
        return encoding;
    }

    private static boolean isChunked(Map<String, String> headers) {
        String value = headers.get("TRANSFER-ENCODING");
        return value != null && value.contains("chunked");
    }

    public static class Response {
        private final int code;
        private final String message;
        private final Map<String, String> headers;

        Response(int code, String message, Map<String, String> headers) {
            this.code = code;
            this.message = message;
            this.headers = headers;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

