/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.docker.IgnorePattern;
import org.openide.filesystems.FileObject;

public class IgnoreFileFilter
implements FileFilter {
    private final FileObject buildContext;
    private final FileObject dockerfile;
    private final FileObject dockerignore;
    private final List<IgnorePattern> patterns = new ArrayList<IgnorePattern>();

    public IgnoreFileFilter(FileObject buildContext, FileObject dockerfile, char separator) throws IOException {
        this.buildContext = buildContext;
        this.dockerfile = dockerfile != null ? dockerfile : buildContext.getFileObject("Dockerfile");
        this.dockerignore = buildContext.getFileObject(".dockerignore");
        if (this.dockerignore != null && this.dockerignore.isData()) {
            this.patterns.addAll(this.load(this.dockerignore, separator));
        }
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.equals(this.dockerfile) || pathname.equals(this.dockerignore)) {
            return true;
        }
        assert (pathname.getAbsolutePath().startsWith(this.buildContext.getPath()) && !pathname.equals(this.buildContext));
        String path = pathname.getAbsolutePath().substring(this.buildContext.getPath().length());
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return this.accept(path);
    }

    public boolean accept(String relativePath) {
        assert (!(relativePath.startsWith("/") || relativePath.endsWith("/") || relativePath.isEmpty()));
        String path = relativePath;
        boolean include = true;
        for (IgnorePattern p : this.patterns) {
            if (!p.matches(path)) continue;
            include = p.isNegative();
        }
        return include;
    }

    private List<IgnorePattern> load(FileObject dockerignore, char separator) throws IOException {
        ArrayList<IgnorePattern> ret = new ArrayList<IgnorePattern>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(dockerignore.getInputStream(), "UTF-8"));){
            String line;
            while ((line = r.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
                ret.add(IgnorePattern.compile(line, Character.valueOf(separator), true));
            }
        }
        return ret;
    }
}

