/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.conf;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.custom.conf.Element;

public class Tag
extends Element {
    private final Map<String, Attribute> attrsMap = new HashMap<String, Attribute>();
    private final Map<String, Tag> childrenMap = new HashMap<String, Tag>();

    public Tag(String name) {
        this(name, null, null, null, null, false, new String[0]);
    }

    public Tag(String name, String description, String documentation, String documentationURL, Tag parent, boolean required, String ... contexts) {
        super(name, description, documentation, documentationURL, parent, required, contexts);
    }

    public void setAttributes(Collection<Attribute> attributes) {
        for (Attribute a : attributes) {
            this.attrsMap.put(a.getName(), a);
        }
    }

    public Collection<String> getAttributesNames() {
        return this.attrsMap.keySet();
    }

    public Collection<Attribute> getAttributes() {
        return this.attrsMap.values();
    }

    public Attribute getAttribute(String name) {
        return this.attrsMap.get(name);
    }

    public void add(Attribute a) {
        this.attrsMap.put(a.getName(), a);
    }

    public void remove(Attribute a) {
        this.attrsMap.remove(a.getName());
    }

    public void setChildren(Collection<Tag> children) {
        for (Tag t : children) {
            this.childrenMap.put(t.getName(), t);
        }
    }

    public Collection<String> getTagsNames() {
        return this.childrenMap.keySet();
    }

    public Collection<Tag> getTags() {
        return this.childrenMap.values();
    }

    public Tag getTag(String tagName) {
        return this.childrenMap.get(tagName);
    }

    public void add(Tag t) {
        this.childrenMap.put(t.getName(), t);
    }

    public void remove(Tag t) {
        this.childrenMap.remove(t.getName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tag[");
        sb.append(super.toString());
        sb.append(',');
        sb.append("children={");
        for (Tag t : this.childrenMap.values()) {
            sb.append(t.toString());
            sb.append(',');
        }
        sb.append('}');
        sb.append(',');
        sb.append("attributes={");
        for (Attribute a : this.attrsMap.values()) {
            sb.append(a.toString());
            sb.append(',');
        }
        sb.append('}');
        sb.append("]");
        return sb.toString();
    }
}

