/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.overlaypanel;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class OverlayPanelRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OverlayPanel panel = (OverlayPanel)component;
        if (panel.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)panel);
        } else {
            this.encodeMarkup(context, panel);
            this.encodeScript(context, panel);
        }
    }

    protected void encodeMarkup(FacesContext context, OverlayPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        String style = panel.getStyle();
        String styleClass = panel.getStyleClass();
        styleClass = styleClass == null ? "ui-overlaypanel ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow" : "ui-overlaypanel ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow " + styleClass;
        writer.startElement("div", (UIComponent)panel);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", (UIComponent)panel);
        writer.writeAttribute("class", (Object)"ui-overlaypanel-content", "styleClass");
        if (!panel.isDynamic()) {
            this.renderChildren(context, (UIComponent)panel);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, OverlayPanel panel) throws IOException {
        UIComponent target = SearchExpressionFacade.resolveComponent(context, (UIComponent)panel, panel.getFor());
        String clientId = panel.getClientId(context);
        String targetClientId = target.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("OverlayPanel", panel.resolveWidgetVar(), clientId).attr("target", targetClientId).attr("showEvent", panel.getShowEvent(), null).attr("hideEvent", panel.getHideEvent(), null).attr("showEffect", panel.getShowEffect(), null).attr("hideEffect", panel.getHideEffect(), null).callback("onShow", "function()", panel.getOnShow()).callback("onHide", "function()", panel.getOnHide()).attr("my", panel.getMy(), null).attr("at", panel.getAt(), null).attr("appendToBody", panel.isAppendToBody(), false).attr("dynamic", panel.isDynamic(), false).attr("dismissable", panel.isDismissable(), true).attr("showCloseIcon", panel.isShowCloseIcon(), false);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

