/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.util;

import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Scope;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class Constants {
    public static final String NAME = "discoclient";
    public static final String DISCO_API_BASE_URL = "https://api.foojay.io";
    public static final String PROPERTY_KEY_DISCO_URL = "url";
    public static final Pattern POSITIVE_INTEGER_PATTERN = Pattern.compile("\\d+");
    public static final String PACKAGES_PATH = "/disco/v1.0/packages";
    public static final String EPHEMERAL_IDS_PATH = "/disco/v1.0/ephemeral_ids";
    public static final String MAJOR_VERSIONS_PATH = "/disco/v1.0/major_versions";
    public static final String DISTRIBUTIONS_PATH = "/disco/v1.0/distributions";
    public static final String API_DISTRIBUTION = "distro";
    public static final String API_VERSION = "version";
    public static final String API_VERSION_BY_DEFINITION = "version_by_definition";
    public static final String API_ARCHITECTURE = "architecture";
    public static final String API_ARCHIVE_TYPE = "archive_type";
    public static final String API_PACKAGE_TYPE = "package_type";
    public static final String API_OPERATING_SYSTEM = "operating_system";
    public static final String API_LIBC_TYPE = "libc_type";
    public static final String API_RELEASE_STATUS = "release_status";
    public static final String API_SUPPORT_TERM = "term_of_support";
    public static final String API_BITNESS = "bitness";
    public static final String API_JAVAFX_BUNDLED = "javafx_bundled";
    public static final String API_DIRECTLY_DOWNLOADABLE = "directly_downloadable";
    public static final String API_LATEST = "latest";
    public static final String API_DISCOVERY_SCOPE_ID = "discovery_scope_id";
    public static final ConcurrentHashMap<Distribution, List<Scope>> SCOPE_LOOKUP = new ConcurrentHashMap();

    static {
        SCOPE_LOOKUP.put(Distribution.AOJ, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.AOJ_OPENJ9, Arrays.asList(Scope.PUBLIC, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.CORRETTO, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.DRAGONWELL, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.GRAALVM_CE8, Arrays.asList(Scope.PUBLIC, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.GRAALVM_CE11, Arrays.asList(Scope.PUBLIC, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.GRAALVM_CE16, Arrays.asList(Scope.PUBLIC, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.LIBERICA, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.LIBERICA_NATIVE, Arrays.asList(Scope.PUBLIC, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.MANDREL, Arrays.asList(Scope.PUBLIC, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.MICROSOFT, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.OJDK_BUILD, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.OPEN_LOGIC, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.ORACLE, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.NOT_DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.ORACLE_OPEN_JDK, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.RED_HAT, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.NOT_DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.SAP_MACHINE, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.TEMURIN, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.TRAVA, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
        SCOPE_LOOKUP.put(Distribution.ZULU, Arrays.asList(Scope.PUBLIC, Scope.BUILD_OF_OPEN_JDK, Scope.DIRECTLY_DOWNLOADABLE));
    }
}

