/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.mocha;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.javascript.nodejs.api.NodeJsSupport;
import org.netbeans.modules.javascript.v8debug.api.Connector;
import org.netbeans.modules.selenium2.api.Utils;
import org.netbeans.modules.selenium2.webclient.api.RunInfo;
import org.netbeans.modules.selenium2.webclient.api.SeleniumRerunHandler;
import org.netbeans.modules.selenium2.webclient.api.TestRunnerReporter;
import org.netbeans.modules.selenium2.webclient.api.Utilities;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaJSPreferences;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaPreferencesValidator;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaSeleniumPreferences;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class MochaRunner {
    private static final Logger LOG = Logger.getLogger(MochaRunner.class.getName());
    private static final String DEBUG_HOST = "localhost";
    private static final int DEBUG_PORT = 5858;

    public static void runTests(FileObject[] activatedFOs, boolean isSelenium) {
        MochaRunner.internalMochaRunner(activatedFOs, isSelenium, false);
    }

    public static void debugTests(FileObject[] activatedFOs, boolean isSelenium) {
        MochaRunner.internalMochaRunner(activatedFOs, isSelenium, true);
    }

    private static void internalMochaRunner(FileObject[] activatedFOs, boolean isSelenium, boolean debug) {
        FileObject testsFolder;
        assert (!EventQueue.isDispatchThread());
        Project p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]);
        if (p == null) {
            return;
        }
        File mochaNBReporter = InstalledFileLocator.getDefault().locate("mocha/netbeans-reporter.js", "org.netbeans.modules.selenium2.webclient.mocha", false);
        if (mochaNBReporter == null) {
            return;
        }
        String node = MochaRunner.getNode(p);
        if (node == null) {
            MochaRunner.openNodeSettings(p);
            return;
        }
        FileObject fileObject = testsFolder = isSelenium ? Utilities.getTestsSeleniumFolder((Project)p, (boolean)true) : Utilities.getTestsFolder((Project)p, (boolean)true);
        if (testsFolder == null) {
            Utilities.openCustomizer((Project)p, (String)"SOURCES");
            return;
        }
        String mochaInstallFolder = isSelenium ? MochaSeleniumPreferences.getMochaDir(p) : MochaJSPreferences.getMochaDir(p);
        ValidationResult validationResult = new MochaPreferencesValidator().validateMochaInstallFolder(mochaInstallFolder).getResult();
        if (mochaInstallFolder == null || mochaInstallFolder.isEmpty() || !validationResult.isFaultless()) {
            Utilities.openCustomizer((Project)p, (String)(isSelenium ? "SELENIUM_TESTING" : "JS_TESTING"));
            return;
        }
        boolean testProject = activatedFOs.length == 1 && activatedFOs[0].equals(p.getProjectDirectory());
        RunInfo runInfo = MochaRunner.getRunInfo(p, activatedFOs, testsFolder, mochaInstallFolder, isSelenium, testProject);
        String displayname = ProjectUtils.getInformation((Project)runInfo.getProject()).getDisplayName() + (isSelenium ? " Selenium" : " Unit") + " Tests";
        ExternalExecutable externalexecutable = new ExternalExecutable(node).workDir(FileUtil.toFile((FileObject)p.getProjectDirectory())).displayName(displayname).additionalParameters(MochaRunner.getAdditionalArguments(p, activatedFOs, testsFolder, mochaInstallFolder, mochaNBReporter, isSelenium, debug, testProject)).environmentVariables(runInfo.getEnvVars());
        TestRunnerReporter testRunnerReporter = new TestRunnerReporter(runInfo, "mocha-netbeans-reporter ");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ExecutionDescriptor.LineConvertorFactory outputLineConvertorFactory = MochaRunner.getOutputLineConvertorFactory(testRunnerReporter, runInfo, countDownLatch, debug);
        ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true).controllable(true).showProgress(true).showSuspended(true).outLineBased(true).errLineBased(true).outConvertorFactory(outputLineConvertorFactory);
        final Future task = externalexecutable.run(descriptor);
        if (debug) {
            try {
                countDownLatch.await(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            Connector.Properties props = MochaRunner.createConnectorProperties(DEBUG_HOST, 5858, p, isSelenium);
            try {
                Connector.connect((Connector.Properties)props, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        task.cancel(true);
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @CheckForNull
    private static String getNode(@NullAllowed Project project) {
        return NodeJsSupport.getInstance().getNode(project);
    }

    private static void openNodeSettings(@NullAllowed Project project) {
        NodeJsSupport.getInstance().openNodeSettings(project);
    }

    private static ExecutionDescriptor.LineConvertorFactory getOutputLineConvertorFactory(final TestRunnerReporter testRunnerReporter, final RunInfo runInfo, final CountDownLatch countDownLatch, boolean debug) {
        if (!debug) {
            return new ExecutionDescriptor.LineConvertorFactory(){

                public LineConvertor newLineConvertor() {
                    return new OutputLineConvertor(testRunnerReporter, runInfo, null);
                }
            };
        }
        final Runnable countDownTask = new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        };
        return new ExecutionDescriptor.LineConvertorFactory(){

            public LineConvertor newLineConvertor() {
                return new OutputLineConvertor(testRunnerReporter, runInfo, countDownTask);
            }
        };
    }

    private static ArrayList<String> getAdditionalArguments(Project p, FileObject[] activatedFOs, FileObject testsFolder, String mochaInstallFolder, File mochaNBReporter, boolean isSelenium, boolean debug, boolean testProject) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(mochaInstallFolder + "/bin/mocha");
        if (!isSelenium && MochaJSPreferences.isAutoWatch(p)) {
            arguments.add("-w");
        }
        if (debug) {
            arguments.add("--debug-brk");
        }
        arguments.add("-t");
        arguments.add(isSelenium ? Integer.toString(MochaSeleniumPreferences.getTimeout(p)) : Integer.toString(MochaJSPreferences.getTimeout(p)));
        arguments.add("-R");
        arguments.add(mochaNBReporter.getPath());
        if (testProject) {
            String testFolder = FileUtil.getRelativePath((FileObject)p.getProjectDirectory(), (FileObject)testsFolder);
            arguments.add(testFolder + "/**/*.js");
        } else {
            ArrayList<String> files2test = new ArrayList<String>();
            for (FileObject fo : activatedFOs) {
                String file2test = FileUtil.getRelativePath((FileObject)p.getProjectDirectory(), (FileObject)fo);
                if (file2test == null || files2test.contains(file2test)) continue;
                files2test.add(file2test);
            }
            for (String file2test : files2test) {
                arguments.add(file2test);
            }
        }
        return arguments;
    }

    private static RunInfo getRunInfo(Project p, FileObject[] activatedFOs, FileObject testsFolder, String mochaInstallFolder, boolean isSelenium, boolean testProject) {
        RunInfo.Builder builder = new RunInfo.Builder(activatedFOs).setTestingProject(testProject).addEnvVar("MOCHA_DIR", mochaInstallFolder).setRerunHandler((RerunHandler)new SeleniumRerunHandler(p, activatedFOs, "Mocha", isSelenium)).setIsSelenium(isSelenium);
        if (activatedFOs.length == 1 && !activatedFOs[0].equals(p.getProjectDirectory())) {
            String testFile = FileUtil.getRelativePath((FileObject)testsFolder, (FileObject)activatedFOs[0]);
            builder = builder.setTestFile(testFile);
        }
        return builder.build();
    }

    private static Connector.Properties createConnectorProperties(String host, int port, Project project, boolean isSelenium) {
        List<File> sourceRoots = MochaRunner.getRoots(project, "HTML5-Sources");
        List<File> siteRoots = MochaRunner.getRoots(project, "HTML5-SiteRoot");
        List<File> testRoots = MochaRunner.getRoots(project, isSelenium ? "HTML5-Tests-Selenium" : "HTML5-Tests");
        ArrayList<String> localPaths = new ArrayList<String>(sourceRoots.size());
        List localPathsExclusionFilter = Collections.emptyList();
        sourceRoots.addAll(testRoots);
        for (File src : sourceRoots) {
            localPaths.add(src.getAbsolutePath());
            for (File site : siteRoots) {
                if (!MochaRunner.isSubdirectoryOf(src, site)) continue;
                if (localPathsExclusionFilter.isEmpty()) {
                    localPathsExclusionFilter = new ArrayList();
                }
                localPathsExclusionFilter.add(site.getAbsolutePath());
            }
        }
        return new Connector.Properties(host, port, localPaths, Collections.emptyList(), localPathsExclusionFilter);
    }

    private static List<File> getRoots(Project project, String type) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups(type);
        ArrayList<File> roots = new ArrayList<File>(sourceGroups.length);
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            File root = FileUtil.toFile((FileObject)rootFolder);
            assert (root != null) : rootFolder;
            roots.add(root);
        }
        return roots;
    }

    private static boolean isSubdirectoryOf(File folder, File child) {
        String chp;
        String fp;
        if (!folder.isDirectory()) {
            return false;
        }
        try {
            fp = folder.getCanonicalPath();
        }
        catch (IOException ioex) {
            fp = folder.getAbsolutePath();
        }
        try {
            chp = child.getCanonicalPath();
        }
        catch (IOException ioex) {
            chp = child.getAbsolutePath();
        }
        if (!chp.startsWith(fp)) {
            return false;
        }
        int fl = fp.length();
        if (chp.length() == fl) {
            return true;
        }
        char separ = chp.charAt(fl);
        return File.separatorChar == separ;
    }

    private static final class FileOutputListener
    implements OutputListener {
        final File file;
        final int line;
        final int column;

        public FileOutputListener(File file, int line, int column) {
            assert (file != null);
            this.file = file;
            this.line = line;
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    Utils.openFile((File)file, (int)line, (int)column);
                }
            });
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static class OutputLineConvertor
    implements LineConvertor {
        private final TestRunnerReporter testRunnerReporter;
        private final RunInfo runInfo;
        private Runnable debuggerStartTask;

        public OutputLineConvertor(TestRunnerReporter testRunnerReporter, RunInfo runInfo, Runnable debuggerStartTask) {
            this.testRunnerReporter = testRunnerReporter;
            this.runInfo = runInfo;
            this.debuggerStartTask = debuggerStartTask;
        }

        public List<ConvertedLine> convert(String line) {
            String output2display;
            if (this.debuggerStartTask != null && line.startsWith("debugger listening on port")) {
                this.debuggerStartTask.run();
                this.debuggerStartTask = null;
            }
            if ((output2display = this.testRunnerReporter.processLine(line)) == null) {
                return Collections.emptyList();
            }
            TestRunnerReporter.CallStackCallback callStackCallback = new TestRunnerReporter.CallStackCallback(this.runInfo.getProject());
            Pair parsedLocation = callStackCallback.parseLocation(line, false);
            FileOutputListener fileOutputListener = parsedLocation == null ? null : new FileOutputListener((File)parsedLocation.first(), ((int[])parsedLocation.second())[0], ((int[])parsedLocation.second())[1]);
            return Collections.singletonList(ConvertedLine.forText((String)output2display, (OutputListener)fileOutputListener));
        }
    }
}

