/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ForeignKeyColumnNode
extends BaseNode {
    private static final String ICON = "org/netbeans/modules/db/resources/columnForeign.gif";
    private static final String FOLDER = "ForeignKeyColumn";
    private String name = "";
    private final MetadataElementHandle<ForeignKeyColumn> keyColumnHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ForeignKeyColumnNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        ForeignKeyColumnNode node = new ForeignKeyColumnNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private ForeignKeyColumnNode(NodeDataLookup lookup, NodeProvider provider) {
        super(lookup, FOLDER, provider);
        this.keyColumnHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        ForeignKeyColumn column = (ForeignKeyColumn)ForeignKeyColumnNode.this.keyColumnHandle.resolve(metaData);
                        ForeignKeyColumnNode.this.name = column.getReferringColumn().getName() + " -> " + column.getReferredColumn().getParent().getName() + "." + column.getReferredColumn().getName();
                        ForeignKeyColumnNode.this.updateProperties(column);
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(ForeignKeyColumn column) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        try {
            Column referred = column.getReferredColumn();
            Column referring = column.getReferringColumn();
            this.addProperty("PositionInFK", "PositionInFKDescription", Integer.class, false, column.getPosition());
            this.addProperty("ReferringFKSchema", "ReferringFKSchema", String.class, false, referring.getParent().getParent().getName());
            this.addProperty("ReferringFKTable", "ReferringFKTable", String.class, false, referring.getParent().getName());
            this.addProperty("ReferringFKColumn", "ReferringFKColumn", String.class, false, referring.getName());
            this.addProperty("ReferredFKSchema", "ReferredFKSchema", String.class, false, referred.getParent().getParent().getName());
            this.addProperty("ReferredFKTable", "ReferredFKTable", String.class, false, referred.getParent().getName());
            this.addProperty("ReferredFKColumn", "ReferredFKColumn", String.class, false, referred.getName());
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public int getPosition() {
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        final int[] array = new int[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    ForeignKeyColumn column = (ForeignKeyColumn)ForeignKeyColumnNode.this.keyColumnHandle.resolve(metaData);
                    array[0] = column == null ? -1 : column.getPosition();
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
        }
        return array[0];
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICON;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ForeignKeyColumnNode.class, (String)"ND_Column");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ForeignKeyColumnNode.class);
    }
}

