/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.web.WebAppMetadataModelFactory;
import org.netbeans.modules.j2ee.dd.spi.webservices.WebservicesMetadataModelFactory;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.j2ee.BaseEEModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.WebProjectUtils;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation2;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class WebModuleImpl
extends BaseEEModuleImpl
implements WebModuleImplementation2,
J2eeModuleImplementation2 {
    private static final String WEB_INF = "WEB-INF";
    private MetadataModel<WebAppMetadata> webAppMetadataModel;
    private MetadataModel<WebAppMetadata> webAppAnnMetadataModel;
    private MetadataModel<WebservicesMetadata> webservicesMetadataModel;
    private boolean inplace = false;
    private static Map<Profile, List<DependencyDesc>> javaEEMap = new HashMap<Profile, List<DependencyDesc>>();

    public WebModuleImpl(Project project, WebModuleProviderImpl provider) {
        super(project, provider, "web.xml", "WEB-INF/web.xml");
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.WAR;
    }

    public FileObject getArchive() throws IOException {
        return this.getArchive("org.apache.maven.plugins", "maven-war-plugin", "war", "war");
    }

    public FileObject getWebInf() {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.getFileObject(WEB_INF);
        }
        return null;
    }

    public FileObject createWebInf() throws IOException {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.createFolder(WEB_INF);
        }
        return null;
    }

    public FileObject getDocumentBase() {
        return WebProjectUtils.getDocumentBase(this.project);
    }

    public void setWarInplace(boolean inplace) {
        this.inplace = inplace;
    }

    public Profile getJ2eeProfile() {
        Profile profile = JavaEEProjectSettings.getProfile((Project)this.project);
        if (profile != null) {
            return profile;
        }
        Profile pomProfile = this.getProfileFromPOM(this.project);
        if (pomProfile != null) {
            if (Profile.JAVA_EE_6_FULL.equals(pomProfile)) {
                return Profile.JAVA_EE_6_WEB;
            }
            if (Profile.JAVA_EE_7_FULL.equals(pomProfile)) {
                return Profile.JAVA_EE_7_WEB;
            }
            if (Profile.JAVA_EE_8_FULL.equals(pomProfile)) {
                return Profile.JAVA_EE_8_WEB;
            }
            if (Profile.JAKARTA_EE_8_FULL.equals(pomProfile)) {
                return Profile.JAKARTA_EE_8_WEB;
            }
            if (Profile.JAKARTA_EE_9_FULL.equals(pomProfile)) {
                return Profile.JAKARTA_EE_9_WEB;
            }
            return pomProfile;
        }
        Profile descriptorProfile = this.getProfileFromDescriptor();
        if (descriptorProfile != null) {
            return descriptorProfile;
        }
        return Profile.JAVA_EE_8_WEB;
    }

    private Profile getProfileFromDescriptor() {
        DDProvider prov = DDProvider.getDefault();
        FileObject dd = this.getDeploymentDescriptor();
        if (dd != null) {
            try {
                WebApp wa = prov.getDDRoot(dd);
                String waVersion = wa.getVersion();
                if ("2.4".equals(waVersion)) {
                    return Profile.J2EE_14;
                }
                if ("2.5".equals(waVersion)) {
                    return Profile.JAVA_EE_5;
                }
                if ("3.0".equals(waVersion)) {
                    return Profile.JAVA_EE_6_WEB;
                }
                if ("3.1".equals(waVersion)) {
                    return Profile.JAVA_EE_7_WEB;
                }
                if ("4.0".equals(waVersion)) {
                    return Profile.JAKARTA_EE_8_WEB;
                }
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
        return null;
    }

    private Profile getProfileFromPOM(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject != null) {
            MavenProject mavenProject = nbMavenProject.getMavenProject();
            List dependencies = mavenProject.getDependencies();
            for (Map.Entry<Profile, List<DependencyDesc>> entry : javaEEMap.entrySet()) {
                for (DependencyDesc dependencyDesc : entry.getValue()) {
                    Dependency dependency = this.checkForDependency(dependencies, dependencyDesc);
                    if (dependency == null) continue;
                    String version = dependency.getVersion();
                    if (dependencyDesc.version != null && (version == null || !version.startsWith(dependencyDesc.version))) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    private Dependency checkForDependency(List<Dependency> dependencies, DependencyDesc dependencyDesc) {
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                if (!dependency.getArtifactId().equals(dependencyDesc.artifactID) || !dependency.getGroupId().equals(dependencyDesc.groupID)) continue;
                return dependency;
            }
        }
        return null;
    }

    @Override
    public File getDDFile(String path) {
        URI webappDir = this.mavenproject().getWebAppDirectory();
        if (webappDir.getAuthority() != null) {
            return null;
        }
        File file = new File(new File(webappDir), path);
        return FileUtil.normalizeFile((File)file);
    }

    @Override
    public FileObject getDeploymentDescriptor() {
        File dd = this.getDDFile("WEB-INF/web.xml");
        if (dd != null) {
            return FileUtil.toFileObject((File)dd);
        }
        return null;
    }

    public String getContextPath() {
        if (this.getDeploymentDescriptor() != null || this.getJ2eeProfile() != null && this.getJ2eeProfile().isAtLeast(Profile.JAVA_EE_6_WEB)) {
            try {
                String path = this.provider.getConfigSupport().getWebContextRoot();
                if (path != null) {
                    return path;
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return "/" + this.mavenproject().getMavenProject().getArtifactId();
    }

    public void setContextPath(String newPath) {
        if (this.getDeploymentDescriptor() != null || this.getJ2eeProfile() != null && this.getJ2eeProfile().isAtLeast(Profile.JAVA_EE_6_WEB)) {
            try {
                this.provider.getConfigSupport().setWebContextRoot(newPath);
            }
            catch (ConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public String getModuleVersion() {
        WebApp wapp = this.getWebApp();
        String version = null;
        if (wapp != null) {
            version = wapp.getVersion();
        }
        if (version == null) {
            version = "4.0";
        }
        return version;
    }

    private WebApp getWebApp() {
        try {
            FileObject deploymentDescriptor = this.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public FileObject getContentDirectory() throws IOException {
        FileObject webappFO;
        if (this.inplace) {
            webappFO = this.getDocumentBase();
        } else {
            MavenProject mavenProject = this.mavenproject().getMavenProject();
            String webappLocation = WebProjectUtils.getPluginProperty(this.project, "webappDirectory");
            if (webappLocation == null) {
                webappLocation = mavenProject.getBuild().getDirectory() + File.separator + mavenProject.getBuild().getFinalName();
            }
            File webapp = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)webappLocation);
            webappFO = FileUtil.toFileObject((File)webapp);
        }
        if (webappFO != null) {
            webappFO.refresh();
        }
        return webappFO;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == WebAppMetadata.class) {
            MetadataModel<WebAppMetadata> model = this.getAnnotationMetadataModel();
            return model;
        }
        if (type == WebservicesMetadata.class) {
            MetadataModel<WebservicesMetadata> model = this.getWebservicesMetadataModel();
            return model;
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getMetadataModel() {
        if (this.webAppMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            final FileObject webInf = this.getOrCreateWebInf();
            if (ddFO == null && webInf != null) {
                webInf.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent fe) {
                        if ("web.xml".equals(fe.getFile().getNameExt())) {
                            webInf.removeFileChangeListener((FileChangeListener)this);
                            WebModuleImpl.this.resetMetadataModel();
                        }
                    }
                });
            }
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)true);
        }
        return this.webAppMetadataModel;
    }

    private FileObject getOrCreateWebInf() {
        FileObject webInf = this.getWebInf();
        if (webInf == null) {
            try {
                webInf = this.createWebInf();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return webInf;
    }

    private synchronized void resetMetadataModel() {
        this.webAppMetadataModel = null;
    }

    private synchronized MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        if (this.webservicesMetadataModel == null) {
            FileObject ddFO = this.getWebServicesDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webservicesMetadataModel = WebservicesMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.webservicesMetadataModel;
    }

    private FileObject getWebServicesDeploymentDescriptor() {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.getFileObject("WEB-INF/webservices.xml");
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getAnnotationMetadataModel() {
        if (this.webAppAnnMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppAnnMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)false);
        }
        return this.webAppAnnMetadataModel;
    }

    static {
        ArrayList<DependencyDesc> javaEE5 = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> javaEE6Web = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> javaEE6Full = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> javaEE7Web = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> javaEE7Full = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> javaEE8Web = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> javaEE8Full = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> jakartaEE8Web = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> jakartaEE8Full = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> jakartaEE9Web = new ArrayList<DependencyDesc>();
        ArrayList<DependencyDesc> jakartaEE9Full = new ArrayList<DependencyDesc>();
        javaEE5.add(new DependencyDesc("javaee", "javaee-api", "5.0"));
        javaEE5.add(new DependencyDesc("javax", "javaee-web-api", "5.0"));
        javaEE6Full.add(new DependencyDesc("javax", "javaee-api", "6.0"));
        javaEE6Web.add(new DependencyDesc("javax", "javaee-web-api", "6.0"));
        javaEE7Full.add(new DependencyDesc("javax", "javaee-api", "7.0"));
        javaEE7Web.add(new DependencyDesc("javax", "javaee-web-api", "7.0"));
        javaEE8Full.add(new DependencyDesc("javax", "javaee-api", "8.0"));
        javaEE8Web.add(new DependencyDesc("javax", "javaee-web-api", "8.0"));
        jakartaEE8Web.add(new DependencyDesc("jakarta.platform", "jakarta.jakartaee-api", "8.0.0"));
        jakartaEE8Full.add(new DependencyDesc("jakarta.platform", "jakarta.jakartaee-web-api", "8.0.0"));
        jakartaEE9Web.add(new DependencyDesc("jakarta.platform", "jakarta.jakartaee-api", "9.0.0"));
        jakartaEE9Full.add(new DependencyDesc("jakarta.platform", "jakarta.jakartaee-web-api", "9.0.0"));
        javaEE5.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-all", "2"));
        javaEE5.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-web", "2"));
        javaEE6Full.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-all", "3"));
        javaEE6Web.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-web", "3"));
        javaEE7Full.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-all", "4"));
        javaEE7Web.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-web", "4"));
        javaEE8Full.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-all", "5.1.0"));
        javaEE8Web.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-web", "5.1.0"));
        jakartaEE8Full.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-all", "5.1.0"));
        jakartaEE8Web.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-web", "5.1.0"));
        jakartaEE9Full.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-all", "6"));
        jakartaEE9Web.add(new DependencyDesc("org.glassfish.main.extras", "glassfish-embedded-web", "6"));
        javaEE5.add(new DependencyDesc("weblogic", "weblogic", "10"));
        javaEE6Full.add(new DependencyDesc("weblogic", "weblogic", "12"));
        javaEE5.add(new DependencyDesc("org.jboss.spec", "jboss-javaee-5.0", null));
        javaEE5.add(new DependencyDesc("org.jboss.spec", "jboss-javaee-all-5.0", null));
        javaEE6Full.add(new DependencyDesc("org.jboss.spec", "jboss-javaee-6.0", null));
        javaEE6Full.add(new DependencyDesc("org.jboss.spec", "jboss-javaee-all-6.0", null));
        javaEE6Web.add(new DependencyDesc("org.jboss.spec", "jboss-javaee-web-6.0", null));
        javaEEMap.put(Profile.JAVA_EE_5, javaEE5);
        javaEEMap.put(Profile.JAVA_EE_6_WEB, javaEE6Web);
        javaEEMap.put(Profile.JAVA_EE_6_FULL, javaEE6Full);
        javaEEMap.put(Profile.JAVA_EE_7_WEB, javaEE7Web);
        javaEEMap.put(Profile.JAVA_EE_7_FULL, javaEE7Full);
        javaEEMap.put(Profile.JAVA_EE_8_WEB, javaEE8Web);
        javaEEMap.put(Profile.JAVA_EE_8_FULL, javaEE8Full);
        javaEEMap.put(Profile.JAKARTA_EE_8_WEB, jakartaEE8Web);
        javaEEMap.put(Profile.JAKARTA_EE_8_FULL, jakartaEE8Full);
        javaEEMap.put(Profile.JAKARTA_EE_9_WEB, jakartaEE9Web);
        javaEEMap.put(Profile.JAKARTA_EE_9_FULL, jakartaEE9Full);
    }

    private static class DependencyDesc {
        private final String groupID;
        private final String artifactID;
        private final String version;

        public DependencyDesc(String groupID, String artifactID, String version) {
            this.groupID = groupID;
            this.artifactID = artifactID;
            this.version = version;
        }
    }
}

