/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtil {
    public static final Resolver NULL_RESOLVER = new Resolver(){

        @Override
        public String resolve(String[] groups) {
            return null;
        }
    };

    public static String resolveRefs(CharSequence text, Pattern pattern, Resolver resolver) {
        if (text == null) {
            return "";
        }
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                String[] groups = new String[matcher.groupCount() + 1];
                for (int i = 0; i < groups.length; ++i) {
                    groups[i] = matcher.group(i);
                }
                String resolved = resolver.resolve(groups);
                matcher.appendReplacement(sb, resolved == null ? "" : resolved.replace("\\", "\\\\").replace("$", "\\$"));
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return text.toString();
    }

    public static interface Resolver {
        public String resolve(String[] var1);
    }

    public static class MappedResolver
    implements Resolver {
        protected final Map<String, String> myMap;

        public MappedResolver(Map<String, String> map) {
            this.myMap = map;
        }

        public MappedResolver() {
            this(new HashMap<String, String>());
        }

        public MappedResolver set(String name, String value) {
            this.myMap.put(name, value);
            return this;
        }

        public Map<String, String> getMMap() {
            return this.myMap;
        }

        @Override
        public String resolve(String[] groups) {
            return groups.length > 2 ? null : this.myMap.get(groups[1]);
        }
    }
}

