/**
 * A selectable choice. See the OPTION element definition in HTML 4.01.
 */
var HTMLOptionElement = {
}
/**
 * The index of this OPTION in its parent SELECT, starting from 0.
 * @syntax hTMLOptionElement.index
 * @returns {Number} 
 */
HTMLOptionElement.prototype.index = new Number();

/**
 * Represents the current state of the corresponding form control, in an interactive user agent. Changing this attribute changes the state of the form control, but does not change the value of the HTML selected attribute of the element.
 * @syntax hTMLOptionElement.selected
 * @returns {boolean} 
 */
HTMLOptionElement.prototype.selected = new boolean();

/**
 * The text contained within the option element.
 * @syntax hTMLOptionElement.text
 * @returns {String} 
 */
HTMLOptionElement.prototype.text = new String();

/**
 * Represents the value of the HTML selected attribute. The value of this attribute does not change if the state of the corresponding form control, in an interactive user agent, changes. See the selected attribute definition in HTML 4.01.
 * @syntax hTMLOptionElement.defaultSelected
 * @returns {boolean} 
 */
HTMLOptionElement.prototype.defaultSelected = new boolean();

/**
 * Returns the FORM element containing this control. Returns null if this control is not within the context of a form.
 * @syntax hTMLOptionElement.form
 * @returns {HTMLFormElement} 
 */
HTMLOptionElement.prototype.form = new HTMLFormElement();

/**
 * The current form control value. See the value attribute definition in HTML 4.01.
 * @syntax hTMLOptionElement.value
 * @returns {String} 
 */
HTMLOptionElement.prototype.value = new String();

/**
 * Option label for use in hierarchical menus. See the label attribute definition in HTML 4.01.
 * @syntax hTMLOptionElement.label
 * @returns {String} 
 */
HTMLOptionElement.prototype.label = new String();

/**
 * The control is unavailable in this context. See the disabled attribute definition in HTML 4.01.
 * @syntax hTMLOptionElement.disabled
 * @returns {boolean} 
 */
HTMLOptionElement.prototype.disabled = new boolean();

/**
 * Represents the HTMLOptionElement prototype object.
 * @syntax HTMLOptionElement.prototype
 * @static
 */
HTMLOptionElement.prototype;

