/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpd.MPD9AbstractReader;
import net.sf.mpxj.mpd.ResultSetRow;
import net.sf.mpxj.mpd.Row;

public final class MPD9DatabaseReader
extends MPD9AbstractReader {
    private DataSource m_dataSource;
    private boolean m_allocatedConnection;
    private Connection m_connection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;
    private boolean m_hasResourceBaselines;
    private boolean m_hasTaskBaselines;
    private boolean m_hasAssignmentBaselines;

    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            List<ResultSetRow> list = this.getRows("SELECT PROJ_ID, PROJ_NAME FROM MSP_PROJECTS");
            for (ResultSetRow resultSetRow : list) {
                this.processProjectListItem(hashMap, resultSetRow);
            }
            return hashMap;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_project = new ProjectFile();
            this.m_eventManager = this.m_project.getEventManager();
            ProjectConfig projectConfig = this.m_project.getProjectConfig();
            projectConfig.setAutoTaskID(false);
            projectConfig.setAutoTaskUniqueID(false);
            projectConfig.setAutoResourceID(false);
            projectConfig.setAutoResourceUniqueID(false);
            projectConfig.setAutoOutlineLevel(false);
            projectConfig.setAutoOutlineNumber(false);
            projectConfig.setAutoWBS(false);
            projectConfig.setAutoCalendarUniqueID(false);
            projectConfig.setAutoAssignmentUniqueID(false);
            this.m_project.getProjectProperties().setFileApplication("Microsoft");
            this.m_project.getProjectProperties().setFileType("MPD");
            this.m_project.getEventManager().addProjectListeners(this.m_projectListeners);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processResourceBaselines();
            this.processTasks();
            this.processTaskBaselines();
            this.processLinks();
            this.processAssignments();
            this.processAssignmentBaselines();
            this.processExtendedAttributes();
            this.processSubProjects();
            this.postProcessing();
            ProjectFile projectFile = this.m_project;
            return projectFile;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
        finally {
            this.reset();
            if (this.m_allocatedConnection && this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
                this.m_connection = null;
            }
        }
    }

    private void processProjectProperties() throws SQLException {
        List<ResultSetRow> list = this.getRows("SELECT * FROM MSP_PROJECTS WHERE PROJ_ID=?", this.m_projectID);
        if (!list.isEmpty()) {
            this.processProjectProperties(list.get(0));
        }
    }

    private void processCalendars() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_CALENDARS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processCalendar(resultSetRow);
        }
        this.updateBaseCalendarNames();
        this.processCalendarData(this.m_project.getCalendars());
    }

    private void processCalendarData(List<ProjectCalendar> list) throws SQLException {
        for (ProjectCalendar projectCalendar : list) {
            this.processCalendarData(projectCalendar, this.getRows("SELECT * FROM MSP_CALENDAR_DATA WHERE PROJ_ID=? AND CAL_UID=?", this.m_projectID, projectCalendar.getUniqueID()));
        }
    }

    private void processCalendarData(ProjectCalendar projectCalendar, List<ResultSetRow> list) {
        for (ResultSetRow resultSetRow : list) {
            this.processCalendarData(projectCalendar, resultSetRow);
        }
    }

    private void processResources() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_RESOURCES WHERE PROJ_ID=?", this.m_projectID)) {
            this.processResource(resultSetRow);
        }
    }

    private void processResourceBaselines() throws SQLException {
        if (this.m_hasResourceBaselines) {
            for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_RESOURCE_BASELINES WHERE PROJ_ID=?", this.m_projectID)) {
                this.processResourceBaseline(resultSetRow);
            }
        }
    }

    private void processTasks() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_TASKS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processTask(resultSetRow);
        }
    }

    private void processTaskBaselines() throws SQLException {
        if (this.m_hasTaskBaselines) {
            for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_TASK_BASELINES WHERE PROJ_ID=?", this.m_projectID)) {
                this.processTaskBaseline(resultSetRow);
            }
        }
    }

    private void processLinks() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_LINKS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processLink(resultSetRow);
        }
    }

    private void processAssignments() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_ASSIGNMENTS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processAssignment(resultSetRow);
        }
    }

    private void processAssignmentBaselines() throws SQLException {
        if (this.m_hasAssignmentBaselines) {
            for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_ASSIGNMENT_BASELINES WHERE PROJ_ID=?", this.m_projectID)) {
                this.processAssignmentBaseline(resultSetRow);
            }
        }
    }

    private void processExtendedAttributes() throws SQLException {
        this.processTextFields();
        this.processNumberFields();
        this.processFlagFields();
        this.processDurationFields();
        this.processDateFields();
        this.processOutlineCodeFields();
    }

    private void processSubProjects() {
        int n = 1;
        for (Task task : this.m_project.getTasks()) {
            String string = task.getSubprojectName();
            if (string == null) continue;
            String string2 = string;
            int n2 = 0x1000000 + n * 0x400000;
            int n3 = string.lastIndexOf(92);
            if (n3 != -1) {
                string2 = string.substring(n3 + 1);
            }
            SubProject subProject = new SubProject();
            subProject.setFileName(string2);
            subProject.setFullPath(string);
            subProject.setUniqueIDOffset(n2);
            subProject.setTaskUniqueID(task.getUniqueID());
            task.setSubProject(subProject);
            ++n;
        }
    }

    private void processTextFields() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_TEXT_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processTextField(resultSetRow);
        }
    }

    private void processNumberFields() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_NUMBER_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processNumberField(resultSetRow);
        }
    }

    private void processFlagFields() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_FLAG_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processFlagField(resultSetRow);
        }
    }

    private void processDurationFields() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_DURATION_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processDurationField(resultSetRow);
        }
    }

    private void processDateFields() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_DATE_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processDateField(resultSetRow);
        }
    }

    private void processOutlineCodeFields() throws SQLException {
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_CODE_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processOutlineCodeFields(resultSetRow);
        }
    }

    private void processOutlineCodeFields(Row row) throws SQLException {
        Integer n = row.getInteger("CODE_REF_UID");
        Integer n2 = row.getInteger("CODE_UID");
        for (ResultSetRow resultSetRow : this.getRows("SELECT * FROM MSP_OUTLINE_CODES WHERE CODE_UID=?", n2)) {
            this.processOutlineCodeField(n, resultSetRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String string) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> linkedList = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(string);
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                linkedList.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String string, Integer n) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> linkedList = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(string);
            this.m_ps.setInt(1, NumberHelper.getInt(n));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                linkedList.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String string, Integer n, Integer n2) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> linkedList = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(string);
            this.m_ps.setInt(1, NumberHelper.getInt(n));
            this.m_ps.setInt(2, NumberHelper.getInt(n2));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                linkedList.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
            this.queryDatabaseMetaData();
        }
    }

    private void releaseConnection() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_rs = null;
        }
        if (this.m_ps != null) {
            try {
                this.m_ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_ps = null;
        }
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
        int n = resultSetMetaData.getColumnCount() + 1;
        for (int i = 1; i < n; ++i) {
            String string = resultSetMetaData.getColumnName(i);
            Integer n2 = resultSetMetaData.getColumnType(i);
            this.m_meta.put(string, n2);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
        this.queryDatabaseMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryDatabaseMetaData() {
        ResultSet resultSet = null;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            DatabaseMetaData databaseMetaData = this.m_connection.getMetaData();
            resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("TABLE_NAME"));
            }
            this.m_hasResourceBaselines = hashSet.contains("MSP_RESOURCE_BASELINES");
            this.m_hasTaskBaselines = hashSet.contains("MSP_TASK_BASELINES");
            this.m_hasAssignmentBaselines = hashSet.contains("MSP_ASSIGNMENT_BASELINES");
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
    }
}

