/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.GenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlTransient;

public class MultiReceiveAction
extends GenericReceiveAction {
    private List<ReceiveAction> expectedActionCandidates;
    @XmlTransient
    private ReceiveAction selectedAction;

    public MultiReceiveAction() {
        this.messages = null;
        this.records = null;
    }

    public MultiReceiveAction(ReceiveAction ... receiveActions) {
        this.expectedActionCandidates = Arrays.asList(receiveActions);
        this.messages = null;
        this.records = null;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.selectedAction.executedAsPlanned();
    }

    public ReceiveAction getSelectedAction() {
        return this.selectedAction;
    }

    @Override
    public void execute(State state) {
        super.execute(state);
        this.selectedAction = new ReceiveAction();
        for (ReceiveAction receiveAction : this.expectedActionCandidates) {
            if (!this.compareExpectedActionsWithReceivedActions2(receiveAction)) continue;
            this.selectedAction = receiveAction;
            break;
        }
        if (this.selectedAction.earlyCleanShutdown != null) {
            state.getTlsContext().setEarlyCleanShutdown(this.selectedAction.earlyCleanShutdown);
        }
        this.selectedAction.setReceivedMessages(super.getReceivedMessages());
        this.selectedAction.setReceivedRecords(super.getReceivedRecords());
        this.selectedAction.setExecuted(super.isExecuted());
    }

    public List<ReceiveAction> getExpectedActionCandidates() {
        return this.expectedActionCandidates;
    }

    private boolean compareExpectedActionsWithReceivedActions(ReceiveAction actionCandidate) {
        List<ProtocolMessage> expectedMessagesCandidate = actionCandidate.getExpectedMessages();
        if (expectedMessagesCandidate.size() != super.getReceivedMessages().size()) {
            return false;
        }
        for (int i = 0; i < expectedMessagesCandidate.size(); ++i) {
            ProtocolMessage expectedMessageCandidate = expectedMessagesCandidate.get(i);
            ProtocolMessage receivedMessage = this.getReceivedMessages().get(i);
            if (expectedMessageCandidate.getClass().equals(receivedMessage.getClass())) {
                return false;
            }
            if (!(expectedMessageCandidate instanceof AlertMessage) || !(receivedMessage instanceof AlertMessage)) continue;
            return Objects.equals(expectedMessageCandidate, receivedMessage);
        }
        return true;
    }

    private boolean compareExpectedActionsWithReceivedActions2(ReceiveAction actionCandidate) {
        actionCandidate.setReceivedMessages(super.getReceivedMessages());
        return actionCandidate.executedAsPlanned();
    }
}

