/*
Copyright (C) 2017 Belledonne Communications SARL

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef _LINPHONE_ACCOUNT_LISTENER_HH
#define _LINPHONE_ACCOUNT_LISTENER_HH

#include <string>
#include "enums.hh"
#include "object.hh"






namespace linphone {

	class Account;

	/**
	 *
	 */
	class AccountListener: public Listener {
	
		public:


	
		public:
			
		
			/**
			 * @brief Callback for notifying when a registration state has changed for the
			 * account. 
			 *
			 * @param message A non nullptr informational message about the state.   
			 */
			LINPHONECXX_PUBLIC virtual void onRegistrationStateChanged(const std::shared_ptr<linphone::Account> & account, linphone::RegistrationState state, const std::string & message) {};
			
			
	};

};

#endif // _LINPHONE_ACCOUNT_LISTENER_HH
