# This file was automatically generated by bifcl from event.bif.

##! The protocol-independent events that the C/C++ core of Zeek can generate.
##!
##! This is mostly events not related to a specific transport- or
##! application-layer protocol, but also includes a few that may be generated
##! by more than one protocols analyzer (like events generated by both UDP and
##! TCP analysis.)


























## Generated at Zeek initialization time. The event engine generates this
## event just before normal input processing begins. It can be used to execute
## one-time initialization code at startup. At the time a handler runs, Zeek will
## have executed any global initializations and statements.
##
## .. zeek:see:: zeek_done network_time_init
##
## .. note::
##
##    When a ``zeek_init`` handler executes, Zeek has not yet seen any input
##    packets and therefore :zeek:id:`network_time` is not initialized yet. An
##    artifact of that is that any timer installed in a ``zeek_init`` handler,
##    like with :zeek:keyword:`schedule`, will fire immediately with the first
##    packet. The standard way to work around that is to ignore the first time
##    the timer fires and immediately reschedule or to instead schedule the
##    first event from with the :zeek:see:`network_time_init` event.
##
export {
global zeek_init: event();


## Generated at Zeek termination time. The event engine generates this event when
## Zeek is about to terminate, either due to having exhausted reading its input
## trace file(s), receiving a termination signal, or because Zeek was run without
## a network input source and has finished executing any global statements.
##
## .. zeek:see:: zeek_init
##
## .. note::
##
##    If Zeek terminates due to an invocation of :zeek:id:`exit`, then this event
##    is not generated.
global zeek_done: event();


## Generated as one of the first steps of Zeek's main-loop termination, just
## before it starts to flush any remaining events/timers/state. The event
## engine generates this event when Zeek is about to terminate, either due to
## having exhausted reading its input trace file(s), receiving a termination
## signal, or because Zeek was run without a network input source and has
## finished executing any global statements.  This event comes before
## :zeek:see:`zeek_init`.
##
## t: The time at with the Zeek-termination process started.
##
## .. zeek:see:: zeek_init zeek_done
##
## .. note::
##
##    If Zeek terminates due to an invocation of :zeek:id:`exit`, then this event
##    is not generated.
global net_done: event(t: time );


## Generated when network time is initialized. The event engine generates this
## event after the network time has been determined but before processing of
## packets is started.
##
## .. zeek:see:: zeek_init network_time
##
global network_time_init: event();


## Generated for every new connection. This event is raised with the first
## packet of a previously unknown connection. Zeek uses a flow-based definition
## of "connection" here that includes not only TCP sessions but also UDP and
## ICMP flows.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update connection_timeout
##    scheduled_analyzer_applied new_connection_contents partial_connection
##
## .. note::
##
##    Handling this event is potentially expensive. For example, during a SYN
##    flooding attack, every spoofed SYN packet will lead to a new
##    event.
global new_connection: event(c: connection );


## Generated for a connection whose tunneling has changed.  This could
## be from a previously seen connection now being encapsulated in a tunnel,
## or from the outer encapsulation changing.  Note that connection *c*'s
## *tunnel* field is NOT automatically/internally assigned to the new
## encapsulation value of *e* after this event is raised.  If the desired
## behavior is to track the latest tunnel encapsulation per-connection,
## then a handler of this event should assign *e* to ``c$tunnel`` (which Zeek's
## default scripts are doing).
##
## c: The connection whose tunnel/encapsulation changed.
##
## e: The new encapsulation.
global tunnel_changed: event(c: connection , e: EncapsulatingConnVector );


## Generated when a TCP connection timed out. This event is raised when
## no activity was seen for an interval of at least
## :zeek:id:`tcp_connection_linger`, and either one endpoint has already
## closed the connection or one side never became active.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update
##    scheduled_analyzer_applied new_connection new_connection_contents
##    partial_connection
##
## .. note::
##
##    The precise semantics of this event can be unintuitive as it only
##    covers a subset of cases where a connection times out. Often, handling
##    :zeek:id:`connection_state_remove` is the better option. That one will be
##    generated reliably when an interval of ``tcp_inactivity_timeout`` has
##    passed without any activity seen (but also for all other ways a
##    connection may terminate).
global connection_timeout: event(c: connection );


## Generated when a connection's internal state is about to be removed from
## memory. Zeek generates this event reliably once for every connection when it
## is about to delete the internal state. As such, the event is well-suited for
## script-level cleanup that needs to be performed for every connection.  This
## event is generated not only for TCP sessions but also for UDP and ICMP
## flows.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection udp_inactivity_timeout
##    tcp_inactivity_timeout icmp_inactivity_timeout conn_stats
global connection_state_remove: event(c: connection );


## Generated when a connection 4-tuple is reused. This event is raised when Zeek
## sees a new TCP session or UDP flow using a 4-tuple matching that of an
## earlier connection it still considers active.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_reused: event(c: connection );


## Generated in regular intervals during the lifetime of a connection. The
## event is raised each ``connection_status_update_interval`` seconds
## and can be used to check conditions on a regular basis.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove  connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_status_update: event(c: connection );


## Generated for a connection over IPv6 when one direction has changed
## the flow label that it's using.
##
## c: The connection.
##
## is_orig: True if the event is raised for the originator side.
##
## old_label: The old flow label that the endpoint was using.
##
## new_label: The new flow label that the endpoint is using.
##
## .. zeek:see:: connection_established new_connection
global connection_flow_label_changed: event(c: connection , is_orig: bool , old_label: count , new_label: count );


## Generated when a UDP session for a supported protocol has finished. Some of
## Zeek's application-layer UDP analyzers flag the end of a session by raising
## this event. Currently, the analyzers for DNS, NTP, Netbios, Syslog, AYIYA,
## Teredo, and GTPv1 support this.
##
## u: The connection record for the corresponding UDP flow.
##
## .. zeek:see:: udp_contents udp_reply udp_request
global udp_session_done: event(u: connection );


## Generated when a connection is seen that is marked as being expected.
## The function :zeek:id:`Analyzer::schedule_analyzer` tells Zeek to expect a
## particular connection to come up, and which analyzer to associate with it.
## Once the first packet of such a connection is indeed seen, this event is
## raised.
##
## c: The connection.
##
## a: The analyzer that was scheduled for the connection with the
##    :zeek:id:`Analyzer::schedule_analyzer` call. When the event is raised, that
##    analyzer will already have been activated to process the connection. The
##    ``count`` is one of the ``ANALYZER_*`` constants, e.g., ``ANALYZER_HTTP``.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update connection_timeout
##    new_connection new_connection_contents partial_connection
##
## .. todo:: We don't have a good way to document the automatically generated
##    ``ANALYZER_*`` constants right now.
global scheduled_analyzer_applied: event(c: connection , a: Analyzer::Tag );


## Generated for every packet Zeek sees that have a valid link-layer header. This
## is a very very low-level and expensive event that should be avoided when at all
## possible. It's usually infeasible to handle when processing even medium volumes
## of traffic in real-time. That said, if you work from a trace and want to do some
## packet-level analysis, it may come in handy.
##
## p: Information from the header of the packet that triggered the event.
##
## .. zeek:see:: new_packet packet_contents
global raw_packet: event(p: raw_pkt_hdr );


## Generated for all packets that make it into Zeek's connection processing. In
## contrast to :zeek:id:`raw_packet` this filters out some more packets that don't
## pass certain sanity checks.
##
## This is a very low-level and expensive event that should be avoided when at all
## possible. It's usually infeasible to handle when processing even medium volumes
## of traffic in real-time. That said, if you work from a trace and want to do some
## packet-level analysis, it may come in handy.
##
## c: The connection the packet is part of.
##
## p: Information from the header of the packet that triggered the event.
##
## .. zeek:see:: tcp_packet packet_contents raw_packet
global new_packet: event(c: connection , p: pkt_hdr );


## Generated for every IPv6 packet that contains extension headers.
## This is potentially an expensive event to handle if analysing IPv6 traffic
## that happens to utilize extension headers frequently.
##
## c: The connection the packet is part of.
##
## p: Information from the header of the packet that triggered the event.
##
## .. zeek:see:: new_packet tcp_packet packet_contents esp_packet
global ipv6_ext_headers: event(c: connection , p: pkt_hdr );


## Generated for any packets using the IPv6 Encapsulating Security Payload (ESP)
## extension header.
##
## p: Information from the header of the packet that triggered the event.
##
## .. zeek:see:: new_packet tcp_packet ipv6_ext_headers
global esp_packet: event(p: pkt_hdr );


## Generated for any packet using a Mobile IPv6 Mobility Header.
##
## p: Information from the header of the packet that triggered the event.
##
## .. zeek:see:: new_packet tcp_packet ipv6_ext_headers
global mobile_ipv6_message: event(p: pkt_hdr );


## Generated for every packet that has a non-empty transport-layer payload.
## This is a very low-level and expensive event that should be avoided when
## at all possible.  It's usually infeasible to handle when processing even
## medium volumes of traffic in real-time. It's even worse than
## :zeek:id:`new_packet`. That said, if you work from a trace and want to
## do some packet-level analysis, it may come in handy.
##
## c: The connection the packet is part of.
##
## contents: The raw transport-layer payload.
##
## .. zeek:see:: new_packet tcp_packet
global packet_contents: event(c: connection , contents: string );


## Generated when Zeek detects a TCP retransmission inconsistency. When
## reassembling a TCP stream, Zeek buffers all payload until it sees the
## responder acking it. If during that time, the sender resends a chunk of
## payload but with different content than originally, this event will be
## raised. In addition, if :zeek:id:`tcp_max_old_segments` is larger than zero,
## mismatches with that older still-buffered data will likewise trigger the event.
##
## c: The connection showing the inconsistency.
##
## t1: The original payload.
##
## t2: The new payload.
##
## tcp_flags: A string with the TCP flags of the packet triggering the
##            inconsistency. In the string, each character corresponds to one
##            set flag, as follows: ``S`` -> SYN; ``F`` -> FIN; ``R`` -> RST;
##            ``A`` -> ACK; ``P`` -> PUSH; ``U`` -> URGENT. This string will
##            not always be set, only if the information is available; it's
##            "best effort".
##
## .. zeek:see:: tcp_rexmit tcp_contents
global rexmit_inconsistency: event(c: connection , t1: string , t2: string , tcp_flags: string );


## Generated when Zeek detects a gap in a reassembled TCP payload stream. This
## event is raised when Zeek, while reassembling a payload stream, determines
## that a chunk of payload is missing (e.g., because the responder has already
## acknowledged it, even though Zeek didn't see it).
##
## c: The connection.
##
## is_orig: True if the gap is on the originator's side.
##
## seq: The sequence number where the gap starts.
##
## length: The number of bytes missing.
##
## .. note::
##
##    Content gaps tend to occur occasionally for various reasons, including
##    broken TCP stacks. If, however, one finds lots of them, that typically
##    means that there is a problem with the monitoring infrastructure such as
##    a tap dropping packets, split routing on the path, or reordering at the
##    tap.
global content_gap: event(c: connection , is_orig: bool , seq: count , length: count );


## Generated when a protocol analyzer confirms that a connection is indeed
## using that protocol. Zeek's dynamic protocol detection heuristically activates
## analyzers as soon as it believes a connection *could* be using a particular
## protocol. It is then left to the corresponding analyzer to verify whether
## that is indeed the case; if so, this event will be generated.
##
## c: The connection.
##
## atype: The type of the analyzer confirming that its protocol is in
##        use. The value is one of the ``Analyzer::ANALYZER_*`` constants. For example,
##        ``Analyzer::ANALYZER_HTTP`` means the HTTP analyzer determined that it's indeed
##        parsing an HTTP connection.
##
## aid:   A unique integer ID identifying the specific *instance* of the
##        analyzer *atype*  that is analyzing the connection ``c``. The ID can
##        be used to reference the analyzer when using builtin functions like
##        :zeek:id:`disable_analyzer`.
##
## .. zeek:see:: protocol_violation
##
## .. note::
##
##    Zeek's default scripts use this event to determine the ``service`` column
##    of :zeek:type:`Conn::Info`: once confirmed, the protocol will be listed
##    there (and thus in ``conn.log``).
global protocol_confirmation: event(c: connection , atype: Analyzer::Tag , aid: count );


## Generated if a DPD signature matched but the DPD buffer is already exhausted
## and thus the analyzer could not be attached. While this does not confirm
## that a protocol is actually used, it allows to retain that information.
##
## c: The connection.
##
## atype: The type of the analyzer confirming that its protocol is in
##        use. The value is one of the ``Analyzer::ANALYZER_*`` constants. For example,
##        ``Analyzer::ANALYZER_HTTP`` means the HTTP analyzer determined that it's indeed
##        parsing an HTTP connection.
##
## .. zeek:see:: dpd_buffer_size
global protocol_late_match: event(c: connection , atype: Analyzer::Tag );


## Generated when a protocol analyzer determines that a connection it is parsing
## is not conforming to the protocol it expects. Zeek's dynamic protocol
## detection heuristically activates analyzers as soon as it believes a
## connection *could* be using a particular protocol. It is then left to the
## corresponding analyzer to verify whether that is indeed the case; if not,
## the analyzer will trigger this event.
##
## c: The connection.
##
## atype: The type of the analyzer confirming that its protocol is in
##        use. The value is one of the ``Analyzer::ANALYZER_*`` constants. For example,
##        ``Analyzer::ANALYZER_HTTP`` means the HTTP analyzer determined that it's indeed
##        parsing an HTTP connection.
##
## aid:   A unique integer ID identifying the specific *instance* of the
##        analyzer *atype*  that is analyzing the connection ``c``. The ID can
##        be used to reference the analyzer when using builtin functions like
##        :zeek:id:`disable_analyzer`.
##
## reason: TODO.
##
## .. zeek:see:: protocol_confirmation
##
## .. note::
##
##    Zeek's default scripts use this event to disable an analyzer via
##    :zeek:id:`disable_analyzer` if it's parsing the wrong protocol. That's
##    however a script-level decision and not done automatically by the event
##    engine.
global protocol_violation: event(c: connection , atype: Analyzer::Tag , aid: count , reason: string );


## Generated when a TCP connection terminated, passing on statistics about the
## two endpoints. This event is always generated when Zeek flushes the internal
## connection state, independent of how a connection terminates.
##
## c: The connection.
##
## os: Statistics for the originator endpoint.
##
## rs: Statistics for the responder endpoint.
##
## .. zeek:see:: connection_state_remove
global conn_stats: event(c: connection , os: endpoint_stats , rs: endpoint_stats );


## Generated for unexpected activity related to a specific connection.  When
## Zeek's packet analysis encounters activity that does not conform to a
## protocol's specification, it raises one of the ``*_weird`` events to report
## that. This event is raised if the activity is tied directly to a specific
## connection.
##
## name: A unique name for the specific type of "weird" situation. Zeek's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## c: The corresponding connection.
##
## addl: Optional additional context further describing the situation.
##
## source: Optional source for the weird. When called by analyzers, this should
##         be filled in with the name of the analyzer.
##
## .. zeek:see:: flow_weird net_weird file_weird expired_conn_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global conn_weird: event(name: string , c: connection , addl: string , source: string );

global conn_weird: event(name: string , c: connection , addl: string );


## Generated for unexpected activity related to a specific connection whose
## internal state has already been expired.  That is to say,
## :zeek:see:`Reporter::conn_weird` may have been called from a script, but
## the internal connection object/state was expired and so the full
## :zeek:see:`connection` record is no longer available, just the UID
## and :zeek:see:`conn_id`.
## When Zeek's packet analysis encounters activity that does not conform to a
## protocol's specification, it raises one of the ``*_weird`` events to report
## that. This event is raised if the activity is tied directly to a specific
## connection.
##
## name: A unique name for the specific type of "weird" situation. Zeek's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## id: The tuple associated with a previously-expired connection.
##
## uid: The UID string associated with a previously-expired connection.
##
## addl: Optional additional context further describing the situation.
##
## source: Optional source for the weird. When called by analyzers, this should
##         be filled in with the name of the analyzer.
##
## .. zeek:see:: flow_weird net_weird file_weird conn_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global expired_conn_weird: event(name: string , id: conn_id , uid: string , addl: string , source: string );

global expired_conn_weird: event(name: string , id: conn_id , uid: string , addl: string );


## Generated for unexpected activity related to a pair of hosts, but independent
## of a specific connection.  When Zeek's packet analysis encounters activity
## that does not conform to a protocol's specification, it raises one of
## the ``*_weird`` events to report that. This event is raised if the activity
## is related to a pair of hosts, yet not to a specific connection between
## them.
##
## name: A unique name for the specific type of "weird" situation. Zeek's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## src: The source address corresponding to the activity.
##
## dst: The destination address corresponding to the activity.
##
## addl: Optional additional context further describing the situation.
##
## source: Optional source for the weird. When called by analyzers, this should
##         be filled in with the name of the analyzer.
##
## .. zeek:see:: conn_weird net_weird file_weird expired_conn_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global flow_weird: event(name: string , src: addr , dst: addr , addl: string , source: string );

global flow_weird: event(name: string , src: addr , dst: addr , addl: string );


## Generated for unexpected activity that is not tied to a specific connection
## or pair of hosts. When Zeek's packet analysis encounters activity that
## does not conform to a protocol's specification, it raises one of the
## ``*_weird`` events to report that. This event is raised if the activity is
## not tied directly to a specific connection or pair of hosts.
##
## name: A unique name for the specific type of "weird" situation. Zeek's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## addl: Optional additional context further describing the situation.
##
## source: Optional source for the weird. When called by analyzers, this should
##         be filled in with the name of the analyzer.
##
## .. zeek:see:: flow_weird file_weird conn_weird expired_conn_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global net_weird: event(name: string , addl: string , source: string );

global net_weird: event(name: string , addl: string );


## Generated for unexpected activity that is tied to a file.
## When Zeek's packet analysis encounters activity that
## does not conform to a protocol's specification, it raises one of the
## ``*_weird`` events to report that.
##
## name: A unique name for the specific type of "weird" situation. Zeek's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## f: The corresponding file.
##
## addl: Additional information related to the weird.
##
## source: The name of the file analyzer that generated the weird.
##
## .. zeek:see:: flow_weird net_weird conn_weird expired_conn_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global file_weird: event(name: string , f: fa_file , addl: string , source: string );

global file_weird: event(name: string , f: fa_file , addl: string );


## Generated regularly for the purpose of profiling Zeek's processing. This event
## is raised for every :zeek:id:`load_sample_freq` packet. For these packets,
## Zeek records script-level functions executed during their processing as well
## as further internal locations. By sampling the processing in this form, one
## can understand where Zeek spends its time.
##
## samples: A set with functions and locations seen during the processing of
##          the sampled packet.
##
## CPU: The CPU time spent on processing the sampled packet.
##
## dmem: The difference in memory usage caused by processing the sampled packet.
global load_sample: event(samples: load_sample_info , CPU: interval , dmem: int );


## Generated when a signature matches. Zeek's signature engine provides
## high-performance pattern matching separately from the normal script
## processing. If a signature with an ``event`` action matches, this event is
## raised.
##
## See the :doc:`user manual </frameworks/signatures>` for more information
## about Zeek's signature engine.
##
## state: Context about the match, including which signatures triggered the
##        event and the connection for which the match was found.
##
## msg: The message passed to the ``event`` signature action.
##
## data: The last chunk of input that triggered the match. Note that the
##       specifics here are not well-defined as Zeek does not buffer any input.
##       If a match is split across packet boundaries, only the last chunk
##       triggering the match will be passed on to the event.
global signature_match: event(state: signature_state , msg: string , data: string );


## Generated each time Zeek's internal profiling log is updated. The file is
## defined by :zeek:id:`profiling_file`, and its update frequency by
## :zeek:id:`profiling_interval` and :zeek:id:`expensive_profiling_multiple`.
##
## f: The profiling file.
##
## expensive: True if this event corresponds to heavier-weight profiling as
##            indicated by the :zeek:id:`expensive_profiling_multiple` variable.
##
## .. zeek:see::  profiling_interval expensive_profiling_multiple
global profiling_update: event(f: file , expensive: bool );


## Raised for informational messages reported via Zeek's reporter framework. Such
## messages may be generated internally by the event engine and also by other
## scripts calling :zeek:id:`Reporter::info`.
##
## t: The time the message was passed to the reporter.
##
## msg: The message itself.
##
## location: A (potentially empty) string describing a location associated with
##           the message.
##
## .. zeek:see:: reporter_warning reporter_error Reporter::info Reporter::warning
##    Reporter::error
##
## .. note:: Zeek will not call reporter events recursively. If the handler of
##    any reporter event triggers a new reporter message itself, the output
##    will go to ``stderr`` instead.
global reporter_info: event(t: time , msg: string , location: string ) &error_handler;


## Raised for warnings reported via Zeek's reporter framework. Such messages may
## be generated internally by the event engine and also by other scripts calling
## :zeek:id:`Reporter::warning`.
##
## t: The time the warning was passed to the reporter.
##
## msg: The warning message.
##
## location: A (potentially empty) string describing a location associated with
##     the warning.
##
## .. zeek:see:: reporter_info reporter_error Reporter::info Reporter::warning
##    Reporter::error
##
## .. note:: Zeek will not call reporter events recursively. If the handler of
##    any reporter event triggers a new reporter message itself, the output
##    will go to ``stderr`` instead.
global reporter_warning: event(t: time , msg: string , location: string ) &error_handler;


## Raised for errors reported via Zeek's reporter framework. Such messages may
## be generated internally by the event engine and also by other scripts calling
## :zeek:id:`Reporter::error`.
##
## t: The time the error was passed to the reporter.
##
## msg: The error message.
##
## location: A (potentially empty) string describing a location associated with
##     the error.
##
## .. zeek:see:: reporter_info reporter_warning Reporter::info Reporter::warning
##    Reporter::error
##
## .. note:: Zeek will not call reporter events recursively. If the handler of
##    any reporter event triggers a new reporter message itself, the output
##    will go to ``stderr`` instead.
global reporter_error: event(t: time , msg: string , location: string ) &error_handler;


## Raised for each policy script loaded by the script interpreter.
##
## path: The full path to the script loaded.
##
## level: The "nesting level": zero for a top-level Zeek script and incremented
##        recursively for each ``@load``.
global zeek_script_loaded: event(path: string , level: count );


## Generated each time Zeek's script interpreter opens a file. This event is
## triggered only for files opened via :zeek:id:`open`, and in particular not for
## normal log files as created by log writers.
##
## f: The opened file.
global file_opened: event(f: file );


## Marks a point in the event stream at which the event queue started flushing.
global event_queue_flush_point: event();


## This event is handled to provide feedback to the file analysis framework
## about how to identify the logical "file" to which some data/input
## belongs.  All incoming data to the framework is buffered, and depends
## on a handler for this event to return a string value that uniquely
## identifies a file.  Among all handlers of this event, the last one to
## call :zeek:see:`set_file_handle` will "win".
##
## tag: The analyzer which is carrying the file data.
##
## c: The connection which is carrying the file data.
##
## is_orig: The direction the file data is flowing over the connection.
##
## .. zeek:see:: set_file_handle
global get_file_handle: event(tag: Analyzer::Tag , c: connection , is_orig: bool );


## Indicates that an analysis of a new file has begun. The analysis can be
## augmented at this time via :zeek:see:`Files::add_analyzer`.
##
## f: The file.
##
## .. zeek:see:: file_over_new_connection file_timeout file_gap
##    file_sniff file_state_remove
global file_new: event(f: fa_file );


## Indicates that a file has been seen being transferred over a connection
## different from the original.
##
## f: The file.
##
## c: The new connection over which the file is seen being transferred.
##
## is_orig: true if the originator of *c* is the one sending the file.
##
## .. zeek:see:: file_new file_timeout file_gap file_sniff
##    file_state_remove
global file_over_new_connection: event(f: fa_file , c: connection , is_orig: bool );


## Provide all metadata that has been inferred about a particular file
## from inspection of the initial content that been seen at the beginning
## of the file.  The analysis can be augmented at this time via
## :zeek:see:`Files::add_analyzer`.  The amount of data fed into the file
## sniffing can be increased or decreased by changing either
## :zeek:see:`default_file_bof_buffer_size` or the `bof_buffer_size` field
## in an `fa_file` record. The event will be raised even if content inspection
## has been unable to infer any metadata, in which case the fields in *meta*
## will be left all unset.
##
## f: The file.
##
## meta: Metadata that's been discovered about the file.
##
## .. zeek:see:: file_over_new_connection file_timeout file_gap
##    file_state_remove
global file_sniff: event(f: fa_file , meta: fa_metadata );


## Indicates that file analysis has timed out because no activity was seen
## for the file in a while.
##
## f: The file.
##
## .. zeek:see:: file_new file_over_new_connection file_gap
##    file_sniff file_state_remove default_file_timeout_interval
##    Files::set_timeout_interval
global file_timeout: event(f: fa_file );


## Indicates that a chunk of the file is missing.
##
## f: The file.
##
## offset: The byte offset from the start of the file at which the gap begins.
##
## len: The number of missing bytes.
##
## .. zeek:see:: file_new file_over_new_connection file_timeout
##    file_sniff file_state_remove file_reassembly_overflow
global file_gap: event(f: fa_file , offset: count , len: count );


## Indicates that the file had an overflow of the reassembly buffer.
## This is a specialization of the :zeek:id:`file_gap` event.
##
## f: The file.
##
## offset: The byte offset from the start of the file at which the reassembly
##         couldn't continue due to running out of reassembly buffer space.
##
## skipped: The number of bytes of the file skipped over to flush some
##          file data and get back under the reassembly buffer size limit.
##          This value will also be represented as a gap.
##
## .. zeek:see:: file_new file_over_new_connection file_timeout
##    file_sniff file_state_remove file_gap
##    Files::enable_reassembler Files::reassembly_buffer_size
##    Files::enable_reassembly Files::disable_reassembly
##    Files::set_reassembly_buffer_size
global file_reassembly_overflow: event(f: fa_file , offset: count , skipped: count );


## This event is generated each time file analysis is ending for a given file.
##
## f: The file.
##
## .. zeek:see:: file_new file_over_new_connection file_timeout file_gap
##    file_sniff
global file_state_remove: event(f: fa_file );


## Generated when an internal DNS lookup produces the same result as last time.
## Zeek keeps an internal DNS cache for host names and IP addresses it has
## already resolved. This event is generated when a subsequent lookup returns
## the same result as stored in the cache.
##
## dm: A record describing the new resolver result (which matches the old one).
##
## .. zeek:see:: dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified
global dns_mapping_valid: event(dm: dns_mapping );


## Generated when an internal DNS lookup got no answer even though it had
## succeeded in the past. Zeek keeps an internal DNS cache for host names and IP
## addresses it has already resolved. This event is generated when a
## subsequent lookup does not produce an answer even though we have
## already stored a result in the cache.
##
## dm: A record describing the old resolver result.
##
## .. zeek:see:: dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_valid
global dns_mapping_unverified: event(dm: dns_mapping );


## Generated when an internal DNS lookup succeeded but an earlier attempt
## did not. Zeek keeps an internal DNS cache for host names and IP
## addresses it has already resolved. This event is generated when a subsequent
## lookup produces an answer for a query that was marked as failed in the cache.
##
## dm: A record describing the new resolver result.
##
## .. zeek:see:: dns_mapping_altered dns_mapping_lost_name dns_mapping_unverified
##    dns_mapping_valid
global dns_mapping_new_name: event(dm: dns_mapping );


## Generated when an internal DNS lookup returned zero answers even though it
## had succeeded in the past. Zeek keeps an internal DNS cache for host names
## and IP addresses it has already resolved. This event is generated when
## on a subsequent lookup we receive an answer that is empty even
## though we have already stored a result in the cache.
##
## dm: A record describing the old resolver result.
##
## .. zeek:see:: dns_mapping_altered dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid
global dns_mapping_lost_name: event(dm: dns_mapping );


## Generated when an internal DNS lookup returns a different host name than
## in the past.  Zeek keeps an internal DNS cache for host names
## and IP addresses it has already resolved. This event is generated when
## on a subsequent lookup we receive an answer that has a different host
## string than we already have in the cache.
##
## prev: A record describing the old resolver result.

## latest: A record describing the new resolver result.
##
## .. zeek:see:: dns_mapping_altered dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid
global dns_mapping_name_changed: event(prev: dns_mapping , latest: dns_mapping );


## Generated when an internal DNS lookup produced a different result than in
## the past.  Zeek keeps an internal DNS cache for host names and IP addresses
## it has already resolved. This event is generated when a subsequent lookup
## returns a different answer than we have stored in the cache.
##
## dm: A record describing the new resolver result.
##
## old_addrs: Addresses that used to be part of the returned set for the query
##            described by *dm*, but are not anymore.
##
## new_addrs: Addresses that were not part of the returned set for the query
##            described by *dm*, but now are.
##
## .. zeek:see:: dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid
global dns_mapping_altered: event(dm: dns_mapping , old_addrs: addr_set , new_addrs: addr_set );


## A meta event generated for events that Zeek raises. This will report all
## events for which at least one handler is defined.
##
## Note that handling this meta event is expensive and should be limited to
## debugging purposes.
##
## name: The name of the event.
##
## params: The event's parameters.
global new_event: event(name: string , params: call_argument_vector );


## Shows an IP address anonymization mapping.
global anonymization_mapping: event(orig: addr , mapped: addr );


## An event that signals a pcap file is done being processed.
##
## path: the filesystem path of the pcap file
global Pcap::file_done: event(path: string );


## Generated when a packet analyzer attempts to forward a protocol that it doesn't
## know how to handle.
##
## analzyer_name: The string name of the analyzer attempting to forward the protocol
##
## protocol: The identifier of the protocol being forwarded
##
## first_bytes: A certain number of bytes at the start of the unknown protocol's header.
##
## .. zeek:see:: UnknownProtocol::first_bytes_count
global unknown_protocol: event(analyzer_name: string , protocol: count , first_bytes: string );

} # end of export section
module GLOBAL;
